/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.autoupdate.ui.Unit;

public class UnitCategory {
    final String name;
    boolean isExpanded = true;
    List<Unit> units = new ArrayList<Unit>();
    private boolean isVisible;
    private String filter;

    public UnitCategory(String name) {
        this.name = name != null ? name : "";
    }

    public UnitCategory(String name, List<Unit> units, boolean isExpanded) {
        this.name = name;
        this.units.addAll(units);
        this.isExpanded = isExpanded;
    }

    public final boolean isVisible(String filter) {
        assert (filter != null);
        assert (this.getCategoryName() != null);
        if (this.filter != null && this.filter.equals(filter)) {
            return this.isVisible;
        }
        this.filter = filter;
        boolean bl = this.isVisible = filter.length() == 0 || this.getCategoryName().toLowerCase().contains(filter);
        if (!this.isVisible) {
            List<Unit> allUnits = this.getUnits();
            for (Unit unit : allUnits) {
                if (!unit.isVisible(filter)) continue;
                this.isVisible = true;
                break;
            }
        }
        return this.isVisible;
    }

    public List<Unit> getVisibleUnits(String filter, boolean orMarked) {
        ArrayList<Unit> visibleUnits;
        boolean categoryFilterMatch = filter.length() == 0 || this.getCategoryName().toLowerCase().contains(filter);
        List<Unit> allUnits = this.getUnits();
        ArrayList<Unit> arrayList = visibleUnits = categoryFilterMatch ? new ArrayList<Unit>(allUnits) : new ArrayList();
        if (!categoryFilterMatch) {
            for (Unit unit : allUnits) {
                if (!unit.isVisible(filter) && (!orMarked || !unit.isMarked())) continue;
                visibleUnits.add(unit);
            }
        }
        return visibleUnits;
    }

    public List<Unit> getMarkedUnits() {
        ArrayList<Unit> markedUnits = new ArrayList<Unit>();
        List<Unit> allUnits = this.getUnits();
        for (Unit u : allUnits) {
            if (!u.isMarked()) continue;
            markedUnits.add(u);
        }
        return markedUnits;
    }

    public String getCategoryName() {
        return this.name;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public boolean addUnit(Unit u) {
        return this.units.add(u);
    }

    public void addUnits(List<Unit> units) {
        for (Unit unit : units) {
            this.addUnit(unit);
        }
    }

    public boolean removeUnit(Unit u) {
        return this.units.remove(u);
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    void toggleExpanded() {
        this.isExpanded = !this.isExpanded;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

