/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class IdClassOverridesEqualsAndHashCode
extends JPAClassRule {
    public IdClassOverridesEqualsAndHashCode() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.IDCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        boolean hasEquals = false;
        boolean hasHashCode = false;
        for (ExecutableElement method : ElementFilter.methodsIn(subject.getEnclosedElements())) {
            String methodName = method.getSimpleName().toString();
            if ("equals".equals(methodName) && method.getParameters().size() == 1) {
                if ("java.lang.Object".equals(((Object)method.getParameters().get(0).asType()).toString())) {
                    hasEquals = true;
                }
            } else if ("hashCode".equals(methodName) && method.getParameters().size() == 0) {
                hasHashCode = true;
            }
            if (!hasHashCode || !hasEquals) continue;
            return null;
        }
        return new ErrorDescription[]{IdClassOverridesEqualsAndHashCode.createProblem(subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_IdClassDoesNotOverrideEquals"))};
    }
}

