/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.repository.sfs.FileStorage;
import org.netbeans.modules.cnd.repository.sfs.IndexedStorageFile;
import org.netbeans.modules.cnd.repository.sfs.WriteStatistics;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class DoubleFileStorage
extends FileStorage {
    private Map<Key, Persistent> fickleMap = new HashMap<Key, Persistent>();
    private File basePath;
    private IndexedStorageFile cache_0_dataFile;
    private IndexedStorageFile cache_1_dataFile;
    private boolean defragmenting = false;
    private AtomicBoolean cache_1_dataFileIsActive = new AtomicBoolean(false);

    private boolean getFlag() {
        return this.cache_1_dataFileIsActive.get();
    }

    private IndexedStorageFile getFileByFlag(boolean flag) {
        return flag ? this.cache_1_dataFile : this.cache_0_dataFile;
    }

    private IndexedStorageFile getActive() {
        return this.cache_1_dataFileIsActive.get() ? this.cache_1_dataFile : this.cache_0_dataFile;
    }

    private IndexedStorageFile getPassive() {
        return this.cache_1_dataFileIsActive.get() ? this.cache_0_dataFile : this.cache_1_dataFile;
    }

    public DoubleFileStorage(File basePath) throws IOException {
        this(basePath, false);
    }

    DoubleFileStorage(File basePath, boolean createCleanExistent) throws IOException {
        this.basePath = basePath;
        this.cache_0_dataFile = new IndexedStorageFile(basePath, "cache-0", createCleanExistent);
        this.cache_1_dataFile = new IndexedStorageFile(basePath, "cache-1", createCleanExistent);
        if (this.cache_0_dataFile.getDataFileUsedSize() == 0L && this.cache_1_dataFile.getDataFileUsedSize() == 0L) {
            this.cache_1_dataFileIsActive.set(false);
        } else if (this.cache_0_dataFile.getDataFileUsedSize() != 0L && this.cache_1_dataFile.getDataFileUsedSize() != 0L) {
            this.cache_1_dataFileIsActive.set(this.cache_0_dataFile.getFragmentationPercentage() >= this.cache_1_dataFile.getFragmentationPercentage());
        } else {
            this.cache_1_dataFileIsActive.set(this.cache_0_dataFile.getDataFileUsedSize() != 0L);
        }
    }

    @Override
    public void close() throws IOException {
        this.cache_0_dataFile.close();
        this.cache_1_dataFile.close();
    }

    @Override
    public Persistent read(Key key) throws IOException {
        if (Stats.hardFickle && key.getBehavior() == Key.Behavior.LargeAndMutable) {
            return this.fickleMap.get(key);
        }
        boolean activeFlag = this.getFlag();
        Persistent object = this.getFileByFlag(activeFlag).read(key);
        if (object == null) {
            object = this.getFileByFlag(!activeFlag).read(key);
        }
        return object;
    }

    @Override
    public void write(Key key, Persistent object) throws IOException {
        if (Stats.writeStatistics) {
            WriteStatistics.instance().update(1);
        }
        if (Stats.hardFickle && key.getBehavior() == Key.Behavior.LargeAndMutable) {
            this.fickleMap.put(key, object);
            return;
        }
        boolean activeFlag = this.getFlag();
        this.getFileByFlag(activeFlag).write(key, object);
        this.getFileByFlag(!activeFlag).remove(key);
    }

    @Override
    public void remove(Key key) throws IOException {
        if (Stats.hardFickle && key.getBehavior() == Key.Behavior.LargeAndMutable) {
            this.fickleMap.remove(key);
            return;
        }
        boolean activeFlag = this.getFlag();
        this.getFileByFlag(activeFlag).remove(key);
        this.getFileByFlag(!activeFlag).remove(key);
    }

    @Override
    public boolean defragment(long timeout) throws IOException {
        boolean needMoreTime = false;
        if (Stats.writeStatistics) {
            WriteStatistics.instance().update(0);
        }
        if (Stats.traceDefragmentation) {
            System.out.printf(">>> Defragmenting %s; timeout %d ms total fragmentation %d%%\n", this.basePath.getAbsolutePath(), timeout, this.getFragmentationPercentage());
            System.out.printf("\tActive:  %s\n", this.getActive().getTraceString());
            System.out.printf("\tPassive: %s\n", this.getPassive().getTraceString());
        }
        if (timeout > 0L && !this.defragmenting && this.getFragmentationPercentage() < Stats.defragmentationThreashold) {
            if (Stats.traceDefragmentation) {
                System.out.printf("\tFragmentation is too low\n", new Object[0]);
            }
            return needMoreTime;
        }
        if (!this.defragmenting) {
            this.defragmenting = true;
            this.cache_1_dataFileIsActive.set(!this.cache_1_dataFileIsActive.get());
        }
        needMoreTime = this._defragment(timeout);
        if (this.getPassive().getObjectsCount() == 0) {
            this.defragmenting = false;
        }
        if (Stats.traceDefragmentation) {
            System.out.printf("<<< Defragmenting %s; timeout %d ms total fragmentation %d%%\n", this.basePath.getAbsolutePath(), timeout, this.getFragmentationPercentage());
            System.out.printf("\tActive:  %s\n", this.getActive().getTraceString());
            System.out.printf("\tPassive: %s\n", this.getPassive().getTraceString());
        }
        return needMoreTime;
    }

    private boolean _defragment(long timeout) throws IOException {
        boolean needMoreTime = false;
        long time = timeout > 0L || Stats.traceDefragmentation ? System.currentTimeMillis() : 0L;
        int cnt = 0;
        boolean activeFlag = this.getFlag();
        Iterator<Key> it = this.getFileByFlag(!activeFlag).getKeySetIterator();
        while (it.hasNext()) {
            Key key = it.next();
            ChunkInfo chunk = this.getFileByFlag(!activeFlag).getChunkInfo(key);
            int size = chunk.getSize();
            long newOffset = this.getFileByFlag(activeFlag).getSize();
            this.getFileByFlag(activeFlag).moveDataFromOtherFile(this.getFileByFlag(!activeFlag).getDataFile(), chunk.getOffset(), size, newOffset, key);
            this.getFileByFlag(!activeFlag).remove(key);
            if (timeout <= 0L || ++cnt % 10 != 0 || System.currentTimeMillis() - time < timeout) continue;
            needMoreTime = true;
            break;
        }
        if (Stats.traceDefragmentation) {
            String text = it.hasNext() ? " finished by timeout" : " completed";
            System.out.printf("\t # defragmentinging %s %s; moved: %d remaining: %d \n", this.getFileByFlag(!activeFlag).getDataFileName(), text, cnt, this.getFileByFlag(!activeFlag).getObjectsCount());
        }
        return needMoreTime;
    }

    @Override
    public void dump(PrintStream ps) throws IOException {
        ps.printf("\nDumping DoubleFileStorage; baseFile %s\n", this.basePath.getAbsolutePath());
        ps.printf("\nActive file:\n", new Object[0]);
        boolean activeFlag = this.getFlag();
        this.getFileByFlag(activeFlag).dump(ps);
        ps.printf("\nPassive file:\n", new Object[0]);
        this.getFileByFlag(!activeFlag).dump(ps);
        ps.printf("\n", new Object[0]);
    }

    @Override
    public void dumpSummary(PrintStream ps) throws IOException {
        ps.printf("\nDumping DoubleFileStorage; baseFile %s\n", this.basePath.getAbsolutePath());
        ps.printf("\nActive file:\n", new Object[0]);
        boolean activeFlag = this.getFlag();
        this.getFileByFlag(activeFlag).dumpSummary(ps);
        ps.printf("\nPassive file:\n", new Object[0]);
        this.getFileByFlag(!activeFlag).dumpSummary(ps);
        ps.printf("\n", new Object[0]);
    }

    @Override
    public int getFragmentationPercentage() throws IOException {
        boolean activeFlag = this.getFlag();
        long fileSize = this.getFileByFlag(activeFlag).getSize() + this.getFileByFlag(!activeFlag).getSize();
        float delta = fileSize - (this.getFileByFlag(activeFlag).getDataFileUsedSize() + this.getFileByFlag(!activeFlag).getDataFileUsedSize());
        float percentage = delta * 100.0f / (float)fileSize;
        return Math.round(percentage);
    }

    @Override
    public long getSize() throws IOException {
        boolean activeFlag = this.getFlag();
        return this.getFileByFlag(activeFlag).getSize() + this.getFileByFlag(!activeFlag).getSize();
    }

    @Override
    public int getObjectsCount() {
        boolean activeFlag = this.getFlag();
        return this.getFileByFlag(activeFlag).getObjectsCount() + this.getFileByFlag(!activeFlag).getObjectsCount();
    }
}

