/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.FixLineSyntaxState;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocalBaseAction;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.netbeans.modules.editor.lib2.typinghooks.TypedBreakInterceptorsManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class ActionFactory {
    private static final Logger LOG = Logger.getLogger(ActionFactory.class.getName());

    private ActionFactory() {
    }

    static void reformat(Reformat formatter, Document doc, int startPos, int endPos, AtomicBoolean canceled) throws BadLocationException {
        GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
        int pos = startPos;
        if (gdoc != null) {
            pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
        }
        LinkedList<PositionRegion> regions = new LinkedList<PositionRegion>();
        while (pos < endPos) {
            int stopPos = endPos;
            if (gdoc != null && ((stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1 || stopPos > endPos)) {
                stopPos = endPos;
            }
            if (pos < stopPos) {
                regions.addFirst(new PositionRegion(doc, pos, stopPos));
                pos = stopPos;
            } else {
                ++pos;
            }
            if (gdoc == null) continue;
            pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
        }
        if (canceled.get()) {
            return;
        }
        for (PositionRegion region : regions) {
            formatter.reformat(region.getStartOffset(), region.getEndOffset());
        }
    }

    private static Fold getLineFold(FoldHierarchy hierarchy, int dot, int lineStart, int lineEnd) {
        Fold nextFold;
        Fold caretOffsetFold = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)dot);
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)lineStart);
        while (fold != null && (fold.getEndOffset() <= dot || !fold.isCollapsed() && fold.getFoldCount() > 0 && fold.getStartOffset() + 1 < dot) && (nextFold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(fold.getFoldCount() > 0 ? fold.getStartOffset() + 1 : fold.getEndOffset()))) != null && nextFold.getStartOffset() < lineEnd) {
            if (nextFold == fold) {
                return fold;
            }
            fold = nextFold;
        }
        if (fold == null || fold.getStartOffset() > lineEnd) {
            if (caretOffsetFold == null) {
                caretOffsetFold = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)lineStart);
            }
            return caretOffsetFold;
        }
        if (caretOffsetFold == null) {
            return fold;
        }
        if (caretOffsetFold.isCollapsed()) {
            return caretOffsetFold;
        }
        if (caretOffsetFold.getEndOffset() > fold.getEndOffset() && fold.getEndOffset() > dot) {
            return fold;
        }
        if (fold.getStartOffset() > caretOffsetFold.getEndOffset()) {
            return caretOffsetFold;
        }
        if (fold.getEndOffset() < dot) {
            return caretOffsetFold;
        }
        return fold;
    }

    public static class CutToLineBeginOrEndAction
    extends LocalBaseAction {
        public CutToLineBeginOrEndAction() {
            super(14);
        }

        @Override
        public void actionPerformed(final ActionEvent evt, final JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            final BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomicAsUser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                    try {
                        Action cutAction;
                        ActionMap actionMap = target.getActionMap();
                        if (actionMap != null && (cutAction = actionMap.get("cut-to-clipboard")) != null) {
                            int boundOffset;
                            Caret caret = target.getCaret();
                            int caretOffset = caret.getDot();
                            boolean toLineEnd = "cut-to-line-end".equals(CutToLineBeginOrEndAction.this.getValue("Name"));
                            int n = boundOffset = toLineEnd ? Utilities.getRowEnd(target, caretOffset) : Utilities.getRowStart(target, caretOffset);
                            if (toLineEnd) {
                                String text = target.getText(caretOffset, boundOffset - caretOffset);
                                if (boundOffset < doc.getLength() && text != null && text.matches("^[\\s]*$")) {
                                    ++boundOffset;
                                }
                            }
                            caret.moveDot(boundOffset);
                            cutAction.actionPerformed(evt);
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                    }
                }
            });
        }
    }

    public static class StartNewLine
    extends LocalBaseAction {
        public StartNewLine() {
            super(14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            block10: {
                int insertionOffset;
                int caretOffset;
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    caretOffset = target.getCaretPosition();
                    insertionOffset = Utilities.getRowEnd(target, caretOffset);
                }
                catch (BadLocationException ble) {
                    LOG.log(Level.FINE, null, ble);
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                final TypedBreakInterceptorsManager.Transaction transaction = TypedBreakInterceptorsManager.getInstance().openTransaction(target, caretOffset, insertionOffset);
                try {
                    if (transaction.beforeInsertion()) break block10;
                    final Boolean[] result = new Boolean[]{Boolean.FALSE};
                    final Indent indenter = Indent.get((Document)doc);
                    indenter.lock();
                    try {
                        doc.runAtomicAsUser(new Runnable(){

                            @Override
                            public void run() {
                                Object[] r = transaction.textTyped();
                                String insertionText = r == null ? "\n" : (String)r[0];
                                int breakInsertPosition = r == null ? -1 : (Integer)r[1];
                                int caretPosition = r == null ? -1 : (Integer)r[2];
                                int[] reindentBlocks = r == null ? null : (int[])r[3];
                                try {
                                    StartNewLine.this.performLineBreakInsertion(target, insertionOffset, insertionText, breakInsertPosition, caretPosition, reindentBlocks, indenter);
                                    result[0] = Boolean.TRUE;
                                }
                                catch (BadLocationException ble) {
                                    LOG.log(Level.FINE, null, ble);
                                    target.getToolkit().beep();
                                }
                            }
                        });
                    }
                    finally {
                        indenter.unlock();
                    }
                    if (result[0].booleanValue()) {
                        transaction.afterInsertion();
                    }
                }
                finally {
                    transaction.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performLineBreakInsertion(JTextComponent target, int insertionOffset, String insertionText, int breakInsertPosition, int caretPosition, int[] reindentBlocks, Indent indenter) throws BadLocationException {
            BaseDocument doc = (BaseDocument)target.getDocument();
            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
            try {
                Caret caret = target.getCaret();
                int dotPos = caret.getDot();
                doc.insertString(dotPos, "-", null);
                doc.remove(dotPos, 1);
                doc.insertString(insertionOffset, insertionText, null);
                dotPos = insertionOffset;
                Position newDotPos = doc.createPosition(dotPos += caretPosition != -1 ? caretPosition : (breakInsertPosition != -1 ? breakInsertPosition + 1 : insertionText.indexOf(10) + 1));
                if (reindentBlocks != null && reindentBlocks.length > 0) {
                    for (int i = 0; i < reindentBlocks.length / 2; ++i) {
                        int startOffset = insertionOffset + reindentBlocks[2 * i];
                        int endOffset = insertionOffset + reindentBlocks[2 * i + 1];
                        indenter.reindent(startOffset, endOffset);
                    }
                } else {
                    indenter.reindent(dotPos);
                }
                caret.setDot(newDotPos.getOffset());
            }
            finally {
                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
            }
        }
    }

    public static class DumpViewHierarchyAction
    extends LocalBaseAction {
        public DumpViewHierarchyAction() {
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            AbstractDocument adoc = (AbstractDocument)target.getDocument();
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            adoc.readLock();
            try {
                hierarchy.lock();
                try {
                    System.err.println("FOLD HIERARCHY DUMP:\n" + hierarchy);
                    TokenHierarchy th = TokenHierarchy.get((Document)adoc);
                    System.err.println("TOKEN HIERARCHY DUMP:\n" + (th != null ? th : "<NULL-TH>"));
                }
                finally {
                    hierarchy.unlock();
                }
            }
            finally {
                adoc.readUnlock();
            }
            View rootView = null;
            TextUI textUI = target.getUI();
            if (textUI != null) {
                rootView = textUI.getRootView(target);
            }
            if (rootView != null) {
                System.err.println("DOCUMENT VIEW: " + System.identityHashCode(rootView) + "\n" + rootView);
                int caretOffset = target.getCaretPosition();
                int caretViewIndex = rootView.getViewIndex(caretOffset, Position.Bias.Forward);
                System.err.println("caretOffset=" + caretOffset + ", caretViewIndex=" + caretViewIndex);
                if (caretViewIndex >= 0 && caretViewIndex < rootView.getViewCount()) {
                    View caretView = rootView.getView(caretViewIndex);
                    System.err.println("caretView: " + caretView);
                }
                System.err.println(FixLineSyntaxState.lineInfosToString(adoc));
            }
            if (adoc instanceof BaseDocument) {
                System.err.println("DOCUMENT:\n" + ((BaseDocument)adoc).toStringDetail());
            }
        }
    }

    public static class ExpandAllFolds
    extends LocalBaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expandAll((FoldHierarchy)hierarchy);
        }
    }

    public static class CollapseAllFolds
    extends LocalBaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapseAll((FoldHierarchy)hierarchy);
        }
    }

    public static class ExpandFold
    extends LocalBaseAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            int dot = target.getCaret().getDot();
            hierarchy.lock();
            try {
                try {
                    int rowStart = javax.swing.text.Utilities.getRowStart(target, dot);
                    int rowEnd = javax.swing.text.Utilities.getRowEnd(target, dot);
                    Fold fold = ActionFactory.getLineFold(hierarchy, dot, rowStart, rowEnd);
                    if (fold != null) {
                        hierarchy.expand(fold);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    public static class CollapseFold
    extends LocalBaseAction {
        private boolean dotInFoldArea(JTextComponent target, Fold fold, int dot) throws BadLocationException {
            int foldStart = fold.getStartOffset();
            int foldEnd = fold.getEndOffset();
            int foldRowStart = javax.swing.text.Utilities.getRowStart(target, foldStart);
            int foldRowEnd = javax.swing.text.Utilities.getRowEnd(target, foldEnd);
            return foldRowStart <= dot && foldRowEnd >= dot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Fold fold;
            int dot;
            FoldHierarchy hierarchy;
            block7: {
                hierarchy = FoldHierarchy.get((JTextComponent)target);
                dot = target.getCaret().getDot();
                hierarchy.lock();
                int rowStart = javax.swing.text.Utilities.getRowStart(target, dot);
                int rowEnd = javax.swing.text.Utilities.getRowEnd(target, dot);
                fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)rowStart);
                fold = ActionFactory.getLineFold(hierarchy, dot, rowStart, rowEnd);
                if (fold != null) break block7;
                hierarchy.unlock();
                return;
            }
            try {
                try {
                    if (this.dotInFoldArea(target, fold, dot)) {
                        hierarchy.collapse(fold);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    public static class AnnotationsCyclingAction
    extends LocalBaseAction {
        public AnnotationsCyclingAction() {
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument(target);
                    int caretLine = Utilities.getLineOffset(doc, caret.getDot());
                    AnnotationDesc aDesc = doc.getAnnotations().activateNextAnnotation(caretLine);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ToggleLineNumbersAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3502499718130556526L;
        private JCheckBoxMenuItem item = null;

        public ToggleLineNumbersAction() {
            super("toggle-line-numbers");
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            this.toggleLineNumbers();
        }

        @Override
        public JMenuItem getPopupMenuItem(JTextComponent target) {
            this.item = new JCheckBoxMenuItem(NbBundle.getBundle(BaseKit.class).getString("line-numbers-menuitem"), this.isLineNumbersVisible());
            this.item.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ToggleLineNumbersAction.this.actionPerformed(null, null);
                }
            });
            return this.item;
        }

        protected boolean isLineNumbersVisible() {
            return false;
        }

        protected void toggleLineNumbers() {
        }
    }

    public static class GenerateGutterPopupAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3502499718130556525L;

        public GenerateGutterPopupAction() {
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        @Override
        public JMenuItem getPopupMenuItem(JTextComponent target) {
            EditorUI ui = Utilities.getEditorUI(target);
            try {
                return ui.getDocument().getAnnotations().createMenu(Utilities.getKit(target), Utilities.getLineOffset(ui.getDocument(), target.getCaret().getDot()));
            }
            catch (BadLocationException ex) {
                return null;
            }
        }
    }

    public static class InsertDateTimeAction
    extends LocalBaseAction {
        static final long serialVersionUID = 2865619897402L;

        public InsertDateTimeAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    SimpleDateFormat formatter = new SimpleDateFormat();
                    Date currentTime = new Date();
                    String dateString = formatter.format(currentTime);
                    doc.insertString(caret.getDot(), dateString, null);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ScrollDownAction
    extends LocalBaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Rectangle bounds = editorUI.getExtentBounds();
                bounds.y -= editorUI.getLineHeight();
                bounds.x += editorUI.getTextMargin().left;
                editorUI.scrollRectToVisible(bounds, 2);
            }
        }
    }

    public static class ScrollUpAction
    extends LocalBaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Rectangle bounds = editorUI.getExtentBounds();
                bounds.y += editorUI.getLineHeight();
                bounds.x += editorUI.getTextMargin().left;
                editorUI.scrollRectToVisible(bounds, 2);
            }
        }
    }

    public static class JumpListPrevComponentAction
    extends LocalBaseAction {
        static final long serialVersionUID = 2032230534727849525L;

        public JumpListPrevComponentAction() {
            super("jump-list-prev-component");
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpPrevComponent(target);
            }
        }
    }

    public static class JumpListNextComponentAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2059070050865876892L;

        public JumpListNextComponentAction() {
            super("jump-list-next-component");
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpNextComponent(target);
            }
        }
    }

    public static class JumpListPrevAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7174907031986424265L;
        PropertyChangeListener pcl;

        public JumpListPrevAction() {
            super("jump-list-prev");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_previous.png");
            this.pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JumpListPrevAction.this.setEnabled(JumpList.hasPrev());
                }
            };
            JumpList.addPropertyChangeListener(this.pcl);
            this.setEnabled(JumpList.hasPrev());
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpPrev(target);
            }
        }
    }

    public static class JumpListNextAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6891721278404990446L;
        PropertyChangeListener pcl;

        public JumpListNextAction() {
            super("jump-list-next");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_next.png");
            this.pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JumpListNextAction.this.setEnabled(JumpList.hasNext());
                }
            };
            JumpList.addPropertyChangeListener(this.pcl);
            this.setEnabled(JumpList.hasNext());
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpNext(target);
            }
        }
    }

    public static class SelectNextParameterAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8045372985336370934L;

        public SelectNextParameterAction() {
            super("select-next-parameter", 34);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                int dotPos = caret.getDot();
                int selectStartPos = -1;
                try {
                    int selectEndPos;
                    if (dotPos > 0 && doc.getChars(dotPos - 1, 1)[0] == ',') {
                        selectStartPos = dotPos;
                    }
                    if (dotPos < doc.getLength()) {
                        char dotChar = doc.getChars(dotPos, 1)[0];
                        if (dotChar == ',') {
                            selectStartPos = dotPos + 1;
                        } else if (dotChar == ')') {
                            caret.setDot(dotPos + 1);
                        }
                    }
                    if (selectStartPos >= 0 && (selectEndPos = doc.find(new FinderFactory.CharArrayFwdFinder(new char[]{',', ')'}), selectStartPos, -1)) >= 0) {
                        target.select(selectStartPos, selectEndPos);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class SelectIdentifierAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7288216961333147873L;

        public SelectIdentifierAction() {
            super(2);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    if (Utilities.isSelectionShowing(caret)) {
                        caret.setDot(caret.getDot());
                    } else {
                        int[] block = Utilities.getIdentifierBlock((BaseDocument)target.getDocument(), caret.getDot());
                        if (block != null) {
                            caret.setDot(block[0]);
                            caret.moveDot(block[1]);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class LastNonWhiteAction
    extends LocalBaseAction {
        static final long serialVersionUID = 4503533041729712917L;

        public LastNonWhiteAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos = Utilities.getRowLastNonWhite((BaseDocument)target.getDocument(), caret.getDot());
                    if (pos >= 0) {
                        boolean select = "selection-last-non-white".equals(this.getValue("Name"));
                        if (select) {
                            caret.moveDot(pos);
                        } else {
                            caret.setDot(pos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class FirstNonWhiteAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5888439539790901158L;

        public FirstNonWhiteAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos = Utilities.getRowFirstNonWhite((BaseDocument)target.getDocument(), caret.getDot());
                    if (pos >= 0) {
                        boolean select = "selection-first-non-white".equals(this.getValue("Name"));
                        if (select) {
                            caret.moveDot(pos);
                        } else {
                            caret.setDot(pos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class FormatAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7666172828961171865L;

        public FormatAction() {
            super(14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = Utilities.getDocument(target);
                if (doc == null) {
                    return;
                }
                Cursor origCursor = target.getCursor();
                target.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    final AtomicBoolean canceled = new AtomicBoolean();
                    ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (canceled.get()) {
                                return;
                            }
                            final Reformat formatter = Reformat.get((Document)doc);
                            formatter.lock();
                            try {
                                if (canceled.get()) {
                                    return;
                                }
                                doc.runAtomicAsUser(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            int endPos;
                                            int startPos;
                                            if (Utilities.isSelectionShowing(caret)) {
                                                startPos = target.getSelectionStart();
                                                endPos = target.getSelectionEnd();
                                            } else {
                                                startPos = 0;
                                                endPos = doc.getLength();
                                            }
                                            ActionFactory.reformat(formatter, doc, startPos, endPos, canceled);
                                        }
                                        catch (GuardedException e) {
                                            target.getToolkit().beep();
                                        }
                                        catch (BadLocationException e) {
                                            Utilities.annotateLoggable(e);
                                        }
                                    }
                                });
                            }
                            finally {
                                formatter.unlock();
                            }
                        }
                    }, (String)NbBundle.getMessage(FormatAction.class, (String)"Format_in_progress"), (AtomicBoolean)canceled, (boolean)false);
                }
                catch (Exception e) {
                    Logger.getLogger(FormatAction.class.getName()).log(Level.FINE, null, e);
                }
                finally {
                    target.setCursor(origCursor);
                }
            }
        }
    }

    public static class AdjustCaretAction
    extends LocalBaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 3223383913531191066L;

        public static AdjustCaretAction createAdjustTop() {
            return new AdjustCaretAction(0);
        }

        public static AdjustCaretAction createAdjustCenter() {
            return new AdjustCaretAction(50);
        }

        public static AdjustCaretAction createAdjustBottom() {
            return new AdjustCaretAction(100);
        }

        public AdjustCaretAction(int percentFromWindowTop) {
            this.percentFromWindowTop = percentFromWindowTop;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Utilities.getEditorUI(target).adjustCaret(this.percentFromWindowTop);
            }
        }
    }

    public static class AdjustWindowAction
    extends LocalBaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 8864278998999643292L;

        public static AdjustWindowAction createAdjustTop() {
            return new AdjustWindowAction(0);
        }

        public static AdjustWindowAction createAdjustCenter() {
            return new AdjustWindowAction(50);
        }

        public static AdjustWindowAction createAdjustBottom() {
            return new AdjustWindowAction(100);
        }

        public AdjustWindowAction(int percentFromWindowTop) {
            this.percentFromWindowTop = percentFromWindowTop;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Utilities.getEditorUI(target).adjustWindow(this.percentFromWindowTop);
            }
        }
    }

    public static class ReindentLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public ReindentLineAction() {
            super(14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                final GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
                final Indent indenter = Indent.get((Document)doc);
                indenter.lock();
                try {
                    doc.runAtomicAsUser(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Position endPosition;
                                int startPos;
                                if (Utilities.isSelectionShowing(caret)) {
                                    startPos = target.getSelectionStart();
                                    endPosition = doc.createPosition(target.getSelectionEnd());
                                } else {
                                    startPos = Utilities.getRowStart(doc, caret.getDot());
                                    endPosition = doc.createPosition(Utilities.getRowEnd(doc, caret.getDot()));
                                }
                                int pos = startPos;
                                if (gdoc != null) {
                                    pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                                }
                                while (pos <= endPosition.getOffset()) {
                                    int stopPos = endPosition.getOffset();
                                    if (gdoc != null && ((stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1 || stopPos > endPosition.getOffset())) {
                                        stopPos = endPosition.getOffset();
                                    }
                                    Position stopPosition = doc.createPosition(stopPos);
                                    indenter.reindent(pos, stopPos);
                                    pos += Math.max(stopPosition.getOffset() - pos, 1);
                                    if (gdoc == null) continue;
                                    pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                                }
                            }
                            catch (GuardedException e) {
                                target.getToolkit().beep();
                            }
                            catch (BadLocationException e) {
                                Utilities.annotateLoggable(e);
                            }
                        }
                    });
                }
                finally {
                    indenter.unlock();
                }
            }
        }
    }

    public static class ShiftLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5124732597493699582L;

        public ShiftLineAction() {
            super(10);
        }

        @Override
        protected void actionNameUpdate(String actionName) {
            super.actionNameUpdate(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = Utilities.getDocument(target);
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            boolean right = "shift-line-right".equals(ShiftLineAction.this.getValue("Name"));
                            if (Utilities.isSelectionShowing(caret)) {
                                BaseKit.changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), right ? 1 : -1);
                            } else {
                                BaseKit.shiftLine(doc, caret.getDot(), right);
                            }
                        }
                        catch (GuardedException e) {
                            target.getToolkit().beep();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class WordMatchAction
    extends LocalBaseAction {
        private boolean matchNext;
        static final long serialVersionUID = 595571114685133170L;

        public WordMatchAction() {
            super(14);
        }

        @Override
        protected void actionNameUpdate(String actionName) {
            super.actionNameUpdate(actionName);
            this.matchNext = "word-match-next".equals(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = Utilities.getEditorUI(target);
                Caret caret = target.getCaret();
                final BaseDocument doc = Utilities.getDocument(target);
                if (Utilities.isSelectionShowing(caret)) {
                    target.replaceSelection(null);
                }
                final int caretOffset = caret.getDot();
                final String s = editorUI.getWordMatch().getMatchWord(caretOffset, this.matchNext);
                final String prevWord = editorUI.getWordMatch().getPreviousWord();
                if (s != null) {
                    doc.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                boolean removePrevWord;
                                int offset = caretOffset;
                                boolean bl = removePrevWord = prevWord != null && prevWord.length() > 0;
                                if (removePrevWord) {
                                    offset -= prevWord.length();
                                }
                                Position pos = doc.createPosition(offset);
                                doc.remove(offset, prevWord.length());
                                doc.insertString(pos.getOffset(), s, null);
                            }
                            catch (BadLocationException e) {
                                target.getToolkit().beep();
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    });
                }
            }
        }
    }

    public static class RedoAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6048125996333769202L;

        public RedoAction() {
            super("redo", 30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Document doc = target.getDocument();
            UndoableEdit undoMgr = (UndoableEdit)doc.getProperty("undo-manager");
            if (target != null && undoMgr != null) {
                try {
                    undoMgr.redo();
                }
                catch (CannotRedoException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8628586205035497612L;

        public UndoAction() {
            super("undo", 30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Document doc = target.getDocument();
            UndoableEdit undoMgr = (UndoableEdit)doc.getProperty("undo-manager");
            if (target != null && undoMgr != null) {
                try {
                    undoMgr.undo();
                }
                catch (CannotUndoException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleHighlightSearchAction
    extends LocalBaseAction
    implements Presenter.Toolbar {
        static final long serialVersionUID = 4603809175771743200L;

        public ToggleHighlightSearchAction() {
            super("toggle-highlight-search", 32);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/toggle_highlight.png", (boolean)false));
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Boolean cur = (Boolean)EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
                cur = cur == null || cur == false ? Boolean.TRUE : Boolean.FALSE;
                EditorFindSupport.getInstance().putFindProperty("find-highlight-search", (Object)cur);
            }
        }

        public Component getToolbarPresenter() {
            MyGaGaButton b = new MyGaGaButton();
            ((AbstractButton)b).setModel(new HighlightButtonModel());
            b.putClientProperty("hideActionText", Boolean.TRUE);
            b.setAction(this);
            return b;
        }

        private static final class MyGaGaButton
        extends JToggleButton
        implements ChangeListener {
            @Override
            public void setModel(ButtonModel model) {
                ButtonModel oldModel = this.getModel();
                if (oldModel != null) {
                    oldModel.removeChangeListener(this);
                }
                super.setModel(model);
                ButtonModel newModel = this.getModel();
                if (newModel != null) {
                    newModel.addChangeListener(this);
                }
                this.stateChanged(null);
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                boolean selected = this.isSelected();
                super.setContentAreaFilled(selected);
                super.setBorderPainted(selected);
            }

            @Override
            public void setBorderPainted(boolean arg0) {
                if (!this.isSelected()) {
                    super.setBorderPainted(arg0);
                }
            }

            @Override
            public void setContentAreaFilled(boolean arg0) {
                if (!this.isSelected()) {
                    super.setContentAreaFilled(arg0);
                }
            }
        }

        private static final class HighlightButtonModel
        extends JToggleButton.ToggleButtonModel
        implements PropertyChangeListener {
            public HighlightButtonModel() {
                EditorFindSupport efs = EditorFindSupport.getInstance();
                efs.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)efs));
                this.propertyChange(null);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || evt.getPropertyName() == null || evt.getPropertyName().equals("find-highlight-search")) {
                    Boolean value = (Boolean)EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
                    this.setSelected(value == null ? false : value);
                }
            }
        }
    }

    public static class FindSelectionAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5601618936504699565L;

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Boolean revertValue;
                EditorFindSupport findSupport = EditorFindSupport.getInstance();
                Caret caret = target.getCaret();
                int dotPos = caret.getDot();
                HashMap<String, Object> props = new HashMap<String, Object>(findSupport.getFindProperties());
                String searchWord = null;
                boolean revert = false;
                Boolean originalValue = null;
                HashMap<String, Boolean> revertMap = (HashMap<String, Boolean>)props.get("revert-map");
                Boolean bl = revertValue = revertMap != null ? (Boolean)revertMap.get("find-whole-words") : null;
                if (Utilities.isSelectionShowing(caret)) {
                    searchWord = target.getSelectedText();
                    originalValue = props.put("find-whole-words", Boolean.FALSE);
                    if (Boolean.FALSE.equals(revertValue)) {
                        revertMap.remove("find-whole-words");
                    } else {
                        revert = !Boolean.FALSE.equals(originalValue);
                    }
                } else {
                    try {
                        searchWord = Utilities.getIdentifier((BaseDocument)target.getDocument(), dotPos);
                        originalValue = props.put("find-whole-words", Boolean.TRUE);
                        if (Boolean.TRUE.equals(revertValue)) {
                            revertMap.remove("find-whole-words");
                        } else {
                            revert = !Boolean.TRUE.equals(originalValue);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                if (searchWord != null) {
                    int n = searchWord.indexOf(10);
                    if (n >= 0) {
                        searchWord = searchWord.substring(0, n);
                    }
                    props.put("find-what", searchWord);
                    if (revert) {
                        revertMap = new HashMap<String, Boolean>();
                        revertMap.put("find-whole-words", originalValue != null ? originalValue : Boolean.FALSE);
                        props.put("revert-map", revertMap);
                    }
                    findSupport.putFindProperties(props);
                    findSupport.find(null, false);
                }
            }
        }
    }

    public static class FindPreviousAction
    extends LocalBaseAction {
        static final long serialVersionUID = -43746947902694926L;

        public FindPreviousAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorFindSupport.getInstance().find(null, true);
            }
        }
    }

    public static class FindNextAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6878814427731642684L;

        public FindNextAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorFindSupport.getInstance().find(null, false);
            }
        }
    }

    public static class ChangeCaseAction
    extends LocalBaseAction {
        int changeCaseMode;
        static final long serialVersionUID = 5680212865619897402L;

        public static ChangeCaseAction createToUpperCase() {
            return new ChangeCaseAction(0);
        }

        public static ChangeCaseAction createToLowerCase() {
            return new ChangeCaseAction(1);
        }

        public static ChangeCaseAction createSwitchCase() {
            return new ChangeCaseAction(2);
        }

        private ChangeCaseAction(int changeCaseMode) {
            super(30);
            this.changeCaseMode = changeCaseMode;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (Utilities.isSelectionShowing(caret)) {
                        int startPos = target.getSelectionStart();
                        int endPos = target.getSelectionEnd();
                        Utilities.changeCase(doc, startPos, endPos - startPos, this.changeCaseMode);
                        caret.setDot(endPos);
                    } else {
                        int dotPos = caret.getDot();
                        Utilities.changeCase(doc, dotPos, 1, this.changeCaseMode);
                        caret.setDot(dotPos + 1);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class AbbrevResetAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2807497346060448395L;

        public AbbrevResetAction() {
            super("abbrev-reset", 4);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }
    }

    public static class AbbrevExpandAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2124569510083544403L;

        public AbbrevExpandAction() {
            super("abbrev-expand", 26);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = ((BaseTextUI)target.getUI()).getEditorUI();
                try {
                    editorUI.getAbbrev().checkAndExpand(evt);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class StopMacroRecordingAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/stop_macro_recording.png");
        }

        protected MacroDialogSupport getMacroDialogSupport(Class kitClass) {
            return new MacroDialogSupport(kitClass);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                String macro = this.stopRecording(target);
                if (macro == null) {
                    target.getToolkit().beep();
                } else {
                    BaseKit kit = Utilities.getKit(target);
                    MacroDialogSupport support = this.getMacroDialogSupport(kit.getClass());
                    support.setBody(macro);
                    support.showMacroDialog();
                }
            }
        }
    }

    public static class StartMacroRecordingAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/start_macro_recording.png");
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && !this.startRecording(target)) {
                target.getToolkit().beep();
            }
        }
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet runningActions = new HashSet();
        private String macroName;

        public RunMacroAction(String name) {
            super("macro-" + name);
            this.macroName = name;
        }

        protected void error(JTextComponent target, String messageKey) {
            Utilities.setStatusText(target, LocaleSupport.getString(messageKey, "Error in macro: " + messageKey));
            Toolkit.getDefaultToolkit().beep();
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (!runningActions.add(this.macroName)) {
                this.error(target, "loop");
                return;
            }
            if (target == null) {
                return;
            }
            final BaseKit kit = Utilities.getKit(target);
            if (kit == null) {
                return;
            }
            String commandString = null;
            if (commandString == null) {
                this.error(target, "macro-not-found");
                runningActions.remove(this.macroName);
                return;
            }
            final StringBuffer actionName = new StringBuffer();
            final char[] command = commandString.toCharArray();
            final int len = command.length;
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomicAsUser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (int i = 0; i < len; ++i) {
                            if (Character.isWhitespace(command[i])) continue;
                            if (command[i] == '\"') {
                                while (++i < len && command[i] != '\"') {
                                    Action a;
                                    char ch = command[i];
                                    if (ch == '\\') {
                                        if (++i >= len) {
                                            RunMacroAction.this.error(target, "macro-malformed");
                                            return;
                                        }
                                        ch = command[i];
                                        if (ch != '\"' && ch != '\\') {
                                            RunMacroAction.this.error(target, "macro-malformed");
                                            return;
                                        }
                                    }
                                    if ((a = target.getKeymap().getDefaultAction()) == null) continue;
                                    ActionEvent newEvt = new ActionEvent(target, 0, new String(new char[]{ch}));
                                    if (a instanceof BaseAction) {
                                        ((BaseAction)a).updateComponent(target);
                                        ((BaseAction)a).actionPerformed(newEvt, target);
                                        continue;
                                    }
                                    a.actionPerformed(newEvt);
                                }
                                continue;
                            }
                            actionName.setLength(0);
                            while (i < len && !Character.isWhitespace(command[i])) {
                                char ch;
                                if ((ch = command[i++]) == '\\') {
                                    if (i >= len) {
                                        RunMacroAction.this.error(target, "macro-malformed");
                                        return;
                                    }
                                    if ((ch = command[i++]) != '\\' && !Character.isWhitespace(ch)) {
                                        RunMacroAction.this.error(target, "macro-malformed");
                                        return;
                                    }
                                }
                                actionName.append(ch);
                            }
                            Action a = kit.getActionByName(actionName.toString());
                            if (a != null) {
                                ActionEvent fakeEvt = new ActionEvent(target, 0, "");
                                if (a instanceof BaseAction) {
                                    ((BaseAction)a).updateComponent(target);
                                    ((BaseAction)a).actionPerformed(fakeEvt, target);
                                } else {
                                    a.actionPerformed(fakeEvt);
                                }
                                if (!"insert-break".equals(actionName.toString())) continue;
                                Action def = target.getKeymap().getDefaultAction();
                                ActionEvent fakeEvt10 = new ActionEvent(target, 0, new String(new byte[]{10}));
                                if (def instanceof BaseAction) {
                                    ((BaseAction)def).updateComponent(target);
                                    ((BaseAction)def).actionPerformed(fakeEvt10, target);
                                    continue;
                                }
                                def.actionPerformed(fakeEvt10);
                                continue;
                            }
                            RunMacroAction.this.error(target, "macro-unknown-action");
                            return;
                        }
                    }
                    finally {
                        runningActions.remove(RunMacroAction.this.macroName);
                    }
                }
            });
        }
    }

    public static class ToggleTypingModeAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2431132686507799723L;

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Boolean overwriteMode = (Boolean)editorUI.getProperty("overwriteMode");
                overwriteMode = overwriteMode == null || overwriteMode == false ? Boolean.TRUE : Boolean.FALSE;
                editorUI.putProperty("overwriteMode", overwriteMode);
            }
        }
    }

    public static class RemoveSelectionAction
    extends LocalBaseAction {
        static final long serialVersionUID = -1419424594746686573L;

        public RemoveSelectionAction() {
            super("remove-selection", 30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            target.replaceSelection(null);
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class CopySelectionElseLineDownAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public CopySelectionElseLineDownAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block14: {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                int start;
                                Element rootElement = doc.getDefaultRootElement();
                                Caret caret = target.getCaret();
                                boolean selection = false;
                                boolean backwardSelection = false;
                                int end = start = target.getCaretPosition();
                                if (Utilities.isSelectionShowing(caret)) {
                                    int selStart = caret.getDot();
                                    int selEnd = caret.getMark();
                                    start = Math.min(selStart, selEnd);
                                    end = Math.max(selStart, selEnd) - 1;
                                    selection = true;
                                    backwardSelection = selStart >= selEnd;
                                }
                                int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                                int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                                if (zeroBaseEndLineNumber == -1) {
                                    target.getToolkit().beep();
                                    return;
                                }
                                try {
                                    Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                                    int startLineStartOffset = startLineElement.getStartOffset();
                                    Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                                    int endLineEndOffset = endLineElement.getEndOffset();
                                    String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                                    int column = start - startLineStartOffset;
                                    if (endLineEndOffset == doc.getLength() + 1) {
                                        assert (linesText.charAt(linesText.length() - 1) == '\n');
                                        doc.insertString(endLineEndOffset - 1, "\n" + linesText.substring(0, linesText.length() - 1), null);
                                    } else {
                                        doc.insertString(endLineEndOffset, linesText, null);
                                    }
                                    if (selection) {
                                        if (backwardSelection) {
                                            caret.setDot(endLineEndOffset + column);
                                            caret.moveDot(endLineEndOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                        } else {
                                            caret.setDot(endLineEndOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                            caret.moveDot(endLineEndOffset + column);
                                        }
                                        break block14;
                                    }
                                    target.setCaretPosition(Math.min(doc.getLength() - 1, endLineEndOffset + column));
                                }
                                catch (BadLocationException ex) {
                                    target.getToolkit().beep();
                                }
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class CopySelectionElseLineUpAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public CopySelectionElseLineUpAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block11: {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                int start;
                                Element rootElement = doc.getDefaultRootElement();
                                Caret caret = target.getCaret();
                                boolean selection = false;
                                boolean backwardSelection = false;
                                int end = start = target.getCaretPosition();
                                if (Utilities.isSelectionShowing(caret)) {
                                    int selStart = caret.getDot();
                                    int selEnd = caret.getMark();
                                    start = Math.min(selStart, selEnd);
                                    end = Math.max(selStart, selEnd) - 1;
                                    selection = true;
                                    backwardSelection = selStart >= selEnd;
                                }
                                int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                                int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                                if (zeroBaseStartLineNumber == -1) {
                                    target.getToolkit().beep();
                                    return;
                                }
                                try {
                                    Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                                    int startLineStartOffset = startLineElement.getStartOffset();
                                    Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                                    int endLineEndOffset = endLineElement.getEndOffset();
                                    String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                                    int column = start - startLineStartOffset;
                                    doc.insertString(startLineStartOffset, linesText, null);
                                    if (selection) {
                                        if (backwardSelection) {
                                            caret.setDot(startLineStartOffset + column);
                                            caret.moveDot(startLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                        } else {
                                            caret.setDot(startLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                            caret.moveDot(startLineStartOffset + column);
                                        }
                                        break block11;
                                    }
                                    target.setCaretPosition(startLineStartOffset + column);
                                }
                                catch (BadLocationException ex) {
                                    target.getToolkit().beep();
                                }
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class MoveSelectionElseLineDownAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public MoveSelectionElseLineDownAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block13: {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                int start;
                                Element rootElement = doc.getDefaultRootElement();
                                Caret caret = target.getCaret();
                                boolean selection = false;
                                boolean backwardSelection = false;
                                int end = start = target.getCaretPosition();
                                if (Utilities.isSelectionShowing(caret)) {
                                    int selStart = caret.getDot();
                                    int selEnd = caret.getMark();
                                    start = Math.min(selStart, selEnd);
                                    end = Math.max(selStart, selEnd) - 1;
                                    selection = true;
                                    backwardSelection = selStart >= selEnd;
                                }
                                int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                                int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                                if (zeroBaseEndLineNumber == -1) {
                                    target.getToolkit().beep();
                                    return;
                                }
                                if (zeroBaseEndLineNumber >= rootElement.getElementCount() - 2) {
                                    return;
                                }
                                try {
                                    Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                                    int startLineStartOffset = startLineElement.getStartOffset();
                                    Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                                    int endLineEndOffset = endLineElement.getEndOffset();
                                    String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                                    Element nextLineElement = rootElement.getElement(zeroBaseEndLineNumber + 1);
                                    int nextLineStartOffset = nextLineElement.getStartOffset();
                                    int nextLineEndOffset = nextLineElement.getEndOffset();
                                    int column = start - startLineStartOffset;
                                    doc.insertString(nextLineEndOffset, linesText, null);
                                    doc.remove(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                                    if (selection) {
                                        if (backwardSelection) {
                                            caret.setDot(nextLineEndOffset - (endLineEndOffset - startLineStartOffset) + column);
                                            caret.moveDot(nextLineEndOffset - (endLineEndOffset - end - 1));
                                        } else {
                                            caret.setDot(nextLineEndOffset - (endLineEndOffset - end - 1));
                                            caret.moveDot(nextLineEndOffset - (endLineEndOffset - startLineStartOffset) + column);
                                        }
                                        break block13;
                                    }
                                    target.setCaretPosition(Math.min(doc.getLength() - 1, nextLineEndOffset + column - (endLineEndOffset - startLineStartOffset)));
                                }
                                catch (BadLocationException ex) {
                                    target.getToolkit().beep();
                                }
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class MoveSelectionElseLineUpAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public MoveSelectionElseLineUpAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block13: {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                int start;
                                Element rootElement = doc.getDefaultRootElement();
                                Caret caret = target.getCaret();
                                boolean selection = false;
                                boolean backwardSelection = false;
                                int end = start = target.getCaretPosition();
                                if (Utilities.isSelectionShowing(caret)) {
                                    int selStart = caret.getDot();
                                    int selEnd = caret.getMark();
                                    start = Math.min(selStart, selEnd);
                                    end = Math.max(selStart, selEnd) - 1;
                                    selection = true;
                                    backwardSelection = selStart >= selEnd;
                                }
                                int zeroBaseStartLineNumber = rootElement.getElementIndex(start);
                                int zeroBaseEndLineNumber = rootElement.getElementIndex(end);
                                if (zeroBaseStartLineNumber == -1) {
                                    target.getToolkit().beep();
                                    return;
                                }
                                if (zeroBaseStartLineNumber == 0) {
                                    return;
                                }
                                try {
                                    Element startLineElement = rootElement.getElement(zeroBaseStartLineNumber);
                                    int startLineStartOffset = startLineElement.getStartOffset();
                                    Element endLineElement = rootElement.getElement(zeroBaseEndLineNumber);
                                    int endLineEndOffset = endLineElement.getEndOffset();
                                    String linesText = doc.getText(startLineStartOffset, endLineEndOffset - startLineStartOffset);
                                    Element previousLineElement = rootElement.getElement(zeroBaseStartLineNumber - 1);
                                    int previousLineStartOffset = previousLineElement.getStartOffset();
                                    int column = start - startLineStartOffset;
                                    doc.remove(startLineStartOffset, Math.min(doc.getLength(), endLineEndOffset) - startLineStartOffset);
                                    doc.insertString(previousLineStartOffset, linesText, null);
                                    if (selection) {
                                        if (backwardSelection) {
                                            caret.setDot(previousLineStartOffset + column);
                                            caret.moveDot(previousLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                        } else {
                                            caret.setDot(previousLineStartOffset + (endLineEndOffset - startLineStartOffset) - (endLineEndOffset - end - 1));
                                            caret.moveDot(previousLineStartOffset + column);
                                        }
                                        break block13;
                                    }
                                    target.setCaretPosition(previousLineStartOffset + column);
                                }
                                catch (BadLocationException ex) {
                                    target.getToolkit().beep();
                                }
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class RemoveLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = -536315497241419877L;

        public RemoveLineAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            int bolPos = Utilities.getRowStart(target, target.getSelectionStart());
                            int eolPos = Utilities.getRowEnd(target, target.getSelectionEnd());
                            if (eolPos == doc.getLength()) {
                                if (bolPos > 0) {
                                    --bolPos;
                                }
                            } else {
                                ++eolPos;
                            }
                            doc.remove(bolPos, eolPos - bolPos);
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class RemoveLineBeginAction
    extends LocalBaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveLineBeginAction() {
            super(30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            int dotPos = caret.getDot();
                            int bolPos = Utilities.getRowStart(doc, dotPos);
                            if (dotPos == bolPos) {
                                if (dotPos > 0) {
                                    doc.remove(dotPos - 1, 1);
                                }
                            } else {
                                char[] chars = doc.getChars(bolPos, dotPos - bolPos);
                                if (Analyzer.isWhitespace(chars, 0, chars.length)) {
                                    doc.remove(bolPos, dotPos - bolPos);
                                } else {
                                    int firstNW = Utilities.getRowFirstNonWhite(doc, bolPos);
                                    if (firstNW >= 0 && firstNW < dotPos) {
                                        doc.remove(firstNW, dotPos - firstNW);
                                    }
                                }
                            }
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class RemoveWordNextAction
    extends LocalBaseAction {
        public RemoveWordNextAction() {
            super("remove-word-next", 30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            int dotPos = caret.getDot();
                            int eolPos = Utilities.getRowEnd(doc, dotPos);
                            int wsPos = Utilities.getNextWord(target, dotPos);
                            wsPos = dotPos == eolPos ? wsPos : Math.min(eolPos, wsPos);
                            doc.remove(dotPos, wsPos - dotPos);
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class RemoveWordPreviousAction
    extends LocalBaseAction {
        public RemoveWordPreviousAction() {
            super("remove-word-previous", 30);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            int dotPos = caret.getDot();
                            int bolPos = Utilities.getRowStart(doc, dotPos);
                            int wsPos = Utilities.getPreviousWord(target, dotPos);
                            wsPos = dotPos == bolPos ? wsPos : Math.max(bolPos, wsPos);
                            doc.remove(wsPos, dotPos - wsPos);
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class RemoveTabAction
    extends LocalBaseAction {
        static final long serialVersionUID = -1537748600593395706L;

        public RemoveTabAction() {
            super("remove-tab", 22);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block11: {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                if (Utilities.isSelectionShowing(caret)) {
                                    try {
                                        BaseKit.changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), -1);
                                    }
                                    catch (GuardedException e) {
                                        target.getToolkit().beep();
                                    }
                                    catch (BadLocationException e) {
                                        e.printStackTrace();
                                    }
                                    break block11;
                                }
                                try {
                                    int startOffset = Utilities.getRowStart(doc, caret.getDot());
                                    int firstNW = Utilities.getRowFirstNonWhite(doc, caret.getDot());
                                    int endOffset = Utilities.getRowEnd(doc, caret.getDot());
                                    if (firstNW == -1 || firstNW >= caret.getDot()) {
                                        BaseKit.changeBlockIndent(doc, startOffset, endOffset, -1);
                                    }
                                }
                                catch (GuardedException e) {
                                    target.getToolkit().beep();
                                }
                                catch (BadLocationException e) {
                                    e.printStackTrace();
                                }
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }
}

