/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.modules.db.explorer.DriverExtendedDeleteImpl;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.netbeans.modules.db.explorer.node.ProcedureNode;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.explorer.node.ViewNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExtendedDelete;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DbExtendedDelete
implements ExtendedDelete {
    private static final Class[] GUARDED_OBJECTS = new Class[]{DriverNode.class, TableNode.class, ViewNode.class, ColumnNode.class, ProcedureNode.class};

    public final boolean delete(Node[] nodes) throws IOException {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        ArrayList<DriverNode> drivers = new ArrayList<DriverNode>();
        for (Node n : nodes) {
            for (Class c : GUARDED_OBJECTS) {
                BaseNode bn = (BaseNode)((Object)n.getLookup().lookup(c));
                if (bn instanceof TableNode) {
                    tables.add(bn.getDisplayName());
                    continue;
                }
                if (bn instanceof ColumnNode) {
                    columns.add(bn.getDisplayName());
                    continue;
                }
                if (bn instanceof DriverNode) {
                    drivers.add((DriverNode)bn);
                    continue;
                }
                if (bn == null) continue;
                others.add(bn.getDisplayName());
            }
        }
        if (!tables.isEmpty()) {
            return this.delete(tables, NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationMessage_Tables", (Object)tables.size()), NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationTitle_Tables", (Object)tables.size()));
        }
        if (!columns.isEmpty()) {
            return this.delete(columns, NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationMessage_Columns", (Object)columns.size()), NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationTitle_Columns", (Object)columns.size()));
        }
        if (!others.isEmpty()) {
            return this.delete(others, NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationMessage_Others", (Object)others.size()), NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationTitle_Others", (Object)others.size()));
        }
        if (!drivers.isEmpty()) {
            DriverExtendedDeleteImpl.delete(nodes);
        }
        return false;
    }

    private boolean delete(List<String> objects, String type, String title) {
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationMessage_DeleteObjects", (Object)type, (Object)DbExtendedDelete.formatNames(objects)), NbBundle.getMessage(DbExtendedDelete.class, (String)"DbExtendedDelete_ConfirmationTitle_DeleteObjects", (Object)title), 0)) != NotifyDescriptor.YES_OPTION;
    }

    private static String formatNames(List<String> names) {
        StringBuilder sb = new StringBuilder();
        for (String s : names) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

