/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SelectAppServerPanel;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.customizer.ModelHandleUtils;
import org.netbeans.modules.maven.spi.debug.MavenDebugger;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public class ExecutionChecker
implements ExecutionResultChecker,
PrerequisitesChecker {
    private final Project project;
    public static final String DEV_NULL = "DEV-NULL";
    public static final String MODULEURI = "netbeans.deploy.clientModuleUri";
    public static final String CLIENTURLPART = "netbeans.deploy.clientUrlPart";
    private static final String NB_COS = ".netbeans_automatic_build";

    ExecutionChecker(Project prj) {
        this.project = prj;
    }

    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        boolean depl = Boolean.parseBoolean(config.getProperties().getProperty("netbeans.deploy"));
        if (depl && resultCode == 0) {
            if (RunUtils.hasApplicationCompileOnSaveEnabled((RunConfig)config)) {
                this.touchCoSTimeStamp(config, System.currentTimeMillis());
            }
            String moduleUri = config.getProperties().getProperty(MODULEURI);
            String clientUrl = config.getProperties().getProperty(CLIENTURLPART, "");
            boolean redeploy = Boolean.parseBoolean(config.getProperties().getProperty("netbeans.deploy.forceRedeploy", "true"));
            boolean debugmode = Boolean.parseBoolean(config.getProperties().getProperty("netbeans.deploy.debugmode"));
            boolean profilemode = Boolean.parseBoolean(config.getProperties().getProperty("netbeans.deploy.profilemode"));
            this.performDeploy(res, debugmode, profilemode, moduleUri, clientUrl, redeploy);
        }
    }

    private void performDeploy(ExecutionContext res, boolean debugmode, boolean profilemode, String clientModuleUri, String clientUrlPart, boolean forceRedeploy) {
        FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)this.project.getProjectDirectory())});
        OutputWriter err = res.getInputOutput().getErr();
        OutputWriter out = res.getInputOutput().getOut();
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (jmp == null) {
            err.println();
            err.println();
            err.println("NetBeans: Application Server deployment not available for Maven project '" + ProjectUtils.getInformation((Project)this.project).getDisplayName() + "'");
            return;
        }
        String serverInstanceID = jmp.getServerInstanceID();
        if (DEV_NULL.equals(serverInstanceID)) {
            err.println();
            err.println();
            err.println("NetBeans: No suitable Deployment Server is defined for the project or globally.");
            return;
        }
        ServerInstance si = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            out.println("NetBeans: Deploying on " + (si != null ? si.getDisplayName() : serverInstanceID));
        }
        catch (InstanceRemovedException ex) {
            out.println("NetBeans: Deploying on " + serverInstanceID);
        }
        try {
            ServerDebugInfo sdi;
            out.println("    profile mode: " + profilemode);
            out.println("    debug mode: " + debugmode);
            out.println("    force redeploy: " + forceRedeploy);
            Deployment.Mode mode = Deployment.Mode.RUN;
            if (debugmode) {
                mode = Deployment.Mode.DEBUG;
            } else if (profilemode) {
                mode = Deployment.Mode.PROFILE;
            }
            String clientUrl = Deployment.getDefault().deploy(jmp, mode, clientModuleUri, clientUrlPart, forceRedeploy, (Deployment.Logger)new DLogger(out));
            if (clientUrl != null) {
                FileObject fo = this.project.getProjectDirectory();
                boolean show = true;
                if (fo != null) {
                    String browser = (String)fo.getAttribute("netbeans.deploy.showBrowser");
                    boolean bl = show = browser != null ? Boolean.parseBoolean(browser) : true;
                }
                if (show) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(clientUrl));
                }
            }
            if (debugmode && (sdi = jmp.getServerDebugInfo()) != null) {
                String h = sdi.getHost();
                String transport = sdi.getTransport();
                String address = "";
                address = transport.equals("dt_shmem") ? sdi.getShmemName() : Integer.toString(sdi.getPort());
                MavenDebugger deb = (MavenDebugger)this.project.getLookup().lookup(MavenDebugger.class);
                deb.attachDebugger(res.getInputOutput(), "Debug Deployed app", transport, h, address);
            }
        }
        catch (Deployment.DeploymentException ex) {
            ex.printStackTrace((PrintWriter)err);
            Logger.getLogger(ExecutionChecker.class.getName()).log(Level.FINE, "Exception occured wile deploying to Application Server.", ex);
        }
        catch (Exception ex) {
            Logger.getLogger(ExecutionChecker.class.getName()).log(Level.FINE, "Exception occured wile deploying to Application Server.", ex);
        }
    }

    public static boolean showServerSelectionDialog(Project project, J2eeModuleProvider provider, RunConfig config) {
        if (DEV_NULL.equals(provider.getServerInstanceID())) {
            boolean isDefaultGoal = config == null ? true : ExecutionChecker.neitherJettyNorCargo(config.getGoals());
            SelectAppServerPanel panel = new SelectAppServerPanel(!isDefaultGoal, project);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ExecutionChecker.class, (String)"TIT_Select"));
            panel.setNLS(dd.createNotificationLineSupport());
            Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (obj == NotifyDescriptor.OK_OPTION) {
                String instanceId = panel.getSelectedServerInstance();
                String serverId = panel.getSelectedServerType();
                if (!DEV_NULL.equals(instanceId)) {
                    boolean permanent = panel.isPermanent();
                    if (permanent) {
                        ExecutionChecker.persistServer(project, instanceId, serverId, panel.getChosenProject());
                    } else {
                        SessionContent sc = (SessionContent)project.getLookup().lookup(SessionContent.class);
                        sc.setServerInstanceId(instanceId);
                        WebModuleProviderImpl prv = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
                        POHImpl poh = (POHImpl)project.getLookup().lookup(POHImpl.class);
                        if (prv != null) {
                            poh.setContextPath(prv.getWebModuleImplementation().getContextPath());
                        }
                        poh.hackModuleServerChange();
                        provider = null;
                    }
                    LogRecord record = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
                    record.setLoggerName("org.netbeans.ui.metrics.maven");
                    record.setParameters(new Object[]{POHImpl.obtainServerName(project)});
                    POHImpl.USG_LOGGER.log(record);
                    return true;
                }
                if (panel.isIgnored() && config != null) {
                    ExecutionChecker.removeNetbeansDeployFromActionMappings(project, config.getActionName());
                    return true;
                }
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExecutionChecker.class, (String)"ERR_Action_without_deployment_server"));
            return false;
        }
        return true;
    }

    public boolean checkRunConfig(RunConfig config) {
        J2eeModuleProvider provider;
        boolean depl = Boolean.parseBoolean(config.getProperties().getProperty("netbeans.deploy"));
        if (depl && (provider = (J2eeModuleProvider)config.getProject().getLookup().lookup(J2eeModuleProvider.class)) != null) {
            return ExecutionChecker.showServerSelectionDialog(this.project, provider, config);
        }
        return true;
    }

    private boolean touchCoSTimeStamp(RunConfig rc, long stamp) {
        if (rc.getProject() == null) {
            return false;
        }
        Build build = rc.getMavenProject().getBuild();
        if (build == null || build.getOutputDirectory() == null) {
            return false;
        }
        File fl = new File(build.getOutputDirectory());
        if (!(fl = FileUtil.normalizeFile((File)fl)).exists()) {
            return false;
        }
        File check = new File(fl, NB_COS);
        if (!check.exists()) {
            try {
                return check.createNewFile();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return check.setLastModified(stamp);
    }

    public static boolean hasCoSTimeStamp(Project prj) {
        NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (nbprj == null) {
            return false;
        }
        return new File(nbprj.getOutputDirectory(false), NB_COS).exists();
    }

    private static void removeNetbeansDeployFromActionMappings(Project project, String actionName) {
        try {
            Properties props;
            ModelHandle handle = ModelHandleUtils.createModelHandle((Project)project);
            NetbeansActionMapping mapp = ModelHandle.getActiveMapping((String)actionName, (Project)project);
            if (mapp != null && (props = mapp.getProperties()) != null) {
                props.remove("netbeans.deploy");
                ModelHandle.setUserActionMapping((NetbeansActionMapping)mapp, (ActionToGoalMapping)handle.getActionMappings());
                handle.markAsModified((Object)handle.getActionMappings());
                ModelHandleUtils.writeModelHandle((ModelHandle)handle, (Project)project);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (XmlPullParserException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean neitherJettyNorCargo(List<String> goals) {
        for (String goal : goals) {
            if (!goal.contains("jetty") && !goal.contains("cargo")) continue;
            return false;
        }
        return true;
    }

    private static void persistServer(Project project, String iID, final String sID, Project targetPrj) {
        ((AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class)).put("netbeans.deployment.server.id", iID, false);
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                org.netbeans.modules.maven.model.pom.Properties props = model.getProject().getProperties();
                if (props == null) {
                    props = model.getFactory().createProperties();
                    model.getProject().setProperties(props);
                }
                props.setProperty("netbeans.hint.deploy.server", sID);
            }
        };
        FileObject projDir = targetPrj.getProjectDirectory();
        final FileObject fo = projDir.getFileObject("pom.xml");
        try {
            fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction((ModelOperation)operation){
                final /* synthetic */ ModelOperation val$operation;
                {
                    this.val$operation = modelOperation;
                }

                public void run() throws IOException {
                    Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(this.val$operation));
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        POHImpl poh = (POHImpl)project.getLookup().lookup(POHImpl.class);
        poh.hackModuleServerChange();
        SubprojectProvider spp = (SubprojectProvider)targetPrj.getLookup().lookup(SubprojectProvider.class);
        Set childrenProjs = spp.getSubprojects();
        if (!childrenProjs.contains(project)) {
            NbMavenProject.fireMavenProjectReload((Project)project);
        }
        for (Project curPrj : childrenProjs) {
            NbMavenProject.fireMavenProjectReload((Project)curPrj);
        }
    }

    static class DLogger
    implements Deployment.Logger {
        private OutputWriter logger;

        public DLogger(OutputWriter log) {
            this.logger = log;
        }

        public void log(String string) {
            this.logger.println(string);
        }
    }
}

