/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api.indexing;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.event.EventSupport;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class IndexingManager {
    private static IndexingManager instance;

    public static synchronized IndexingManager getDefault() {
        if (instance == null) {
            instance = new IndexingManager();
        }
        return instance;
    }

    public boolean isIndexing() {
        return Utilities.isScanInProgress();
    }

    public void refreshIndex(URL root, Collection<? extends URL> files) {
        this.refreshIndex(root, files, true, false);
    }

    public void refreshIndex(URL root, Collection<? extends URL> files, boolean fullRescan) {
        this.refreshIndex(root, files, fullRescan, false);
    }

    public void refreshIndex(@NonNull URL root, @NullAllowed Collection<? extends URL> files, boolean fullRescan, boolean checkEditor) {
        RepositoryUpdater.getDefault().addIndexingJob(root, files, false, checkEditor, false, fullRescan, true);
    }

    public void refreshIndexAndWait(URL root, Collection<? extends URL> files) {
        this.refreshIndexAndWait(root, files, true);
    }

    public void refreshIndexAndWait(URL root, Collection<? extends URL> files, boolean fullRescan) {
        if (SwingUtilities.isEventDispatchThread()) {
            EventSupport.releaseCompletionCondition();
        }
        if (!RepositoryUpdater.getDefault().isIndexer()) {
            RepositoryUpdater.getDefault().addIndexingJob(root, files, false, false, true, fullRescan, false);
        }
    }

    public void refreshAllIndices(String indexerName) {
        if (indexerName != null) {
            RepositoryUpdater.getDefault().addIndexingJob(indexerName);
        } else {
            RepositoryUpdater.getDefault().refreshAll(true, false, false, new Object[0]);
        }
    }

    public void refreshAllIndices(FileObject ... filesOrFolders) {
        this.refreshAllIndices(true, false, filesOrFolders);
    }

    public void refreshAllIndices(boolean fullRescan, boolean wait, FileObject ... filesOrFolders) {
        RepositoryUpdater.getDefault().refreshAll(fullRescan, wait, false, filesOrFolders);
    }

    public void refreshAllIndices(boolean fullRescan, boolean wait, File ... filesOrFolders) {
        boolean ae = false;
        if (!$assertionsDisabled) {
            ae = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (ae) {
            for (File file : filesOrFolders) {
                assert (file.equals(FileUtil.normalizeFile((File)file))) : String.format("File: %s is not normalized.", file.toString());
            }
        }
        RepositoryUpdater.getDefault().refreshAll(fullRescan, wait, false, filesOrFolders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runProtected(Callable<T> operation) throws Exception {
        IndexingController.getDefault().enterProtectedMode();
        try {
            T t = operation.call();
            return t;
        }
        finally {
            IndexingController.getDefault().exitProtectedMode(null);
        }
    }

    private IndexingManager() {
        RepositoryUpdater.getDefault().start(false);
    }
}

