/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationValue;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javadoc.AnnotationDescImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.TypeMaker;

public class AnnotationValueImpl
implements AnnotationValue {
    private final DocEnv env;
    private final Attribute attr;

    AnnotationValueImpl(DocEnv env, Attribute attr) {
        this.env = env;
        this.attr = attr;
    }

    public Object value() {
        ValueVisitor vv = new ValueVisitor();
        this.attr.accept(vv);
        return vv.value;
    }

    public String toString() {
        ToStringVisitor tv = new ToStringVisitor();
        this.attr.accept(tv);
        return tv.toString();
    }

    private class ToStringVisitor
    implements Attribute.Visitor {
        private final StringBuffer sb = new StringBuffer();

        private ToStringVisitor() {
        }

        public String toString() {
            return this.sb.toString();
        }

        public void visitConstant(Attribute.Constant c) {
            if (c.type.tag == 8) {
                this.sb.append((Integer)c.value != 0);
            } else {
                this.sb.append(FieldDocImpl.constantValueExpression(c.value));
            }
        }

        public void visitClass(Attribute.Class c) {
            this.sb.append(c);
        }

        public void visitEnum(Attribute.Enum e) {
            this.sb.append(e);
        }

        public void visitCompound(Attribute.Compound c) {
            this.sb.append(new AnnotationDescImpl(AnnotationValueImpl.this.env, c));
        }

        public void visitArray(Attribute.Array a) {
            if (a.values.length != 1) {
                this.sb.append('{');
            }
            boolean first = true;
            for (Attribute elem : a.values) {
                if (first) {
                    first = false;
                } else {
                    this.sb.append(", ");
                }
                elem.accept(this);
            }
            if (a.values.length != 1) {
                this.sb.append('}');
            }
        }

        public void visitError(Attribute.Error e) {
            this.sb.append("<error>");
        }
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        public Object value;

        private ValueVisitor() {
        }

        public void visitConstant(Attribute.Constant c) {
            this.value = c.type.tag == 8 ? Boolean.valueOf((Integer)c.value != 0) : c.value;
        }

        public void visitClass(Attribute.Class c) {
            this.value = TypeMaker.getType(AnnotationValueImpl.this.env, ((AnnotationValueImpl)AnnotationValueImpl.this).env.types.erasure(c.type));
        }

        public void visitEnum(Attribute.Enum e) {
            this.value = AnnotationValueImpl.this.env.getFieldDoc(e.value);
        }

        public void visitCompound(Attribute.Compound c) {
            this.value = new AnnotationDescImpl(AnnotationValueImpl.this.env, c);
        }

        public void visitArray(Attribute.Array a) {
            AnnotationValue[] vals = new AnnotationValue[a.values.length];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = new AnnotationValueImpl(AnnotationValueImpl.this.env, a.values[i]);
            }
            this.value = vals;
        }

        public void visitError(Attribute.Error e) {
            this.value = "<error>";
        }
    }
}

