/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.beanvalidation;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.javaee.beanvalidation.ConstraintPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintIterator
implements TemplateWizard.Iterator {
    private transient WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private int index;
    private final String VALIDATOR_TEMPLATE = "Validator.java";

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        FileObject validatorTemplate;
        DataObject validatorDataObject;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        ArrayList targetElements = (ArrayList)wizard.getProperty("targetElements");
        if (targetElements == null) {
            targetElements = new ArrayList();
        }
        String validatorClassName = (String)wizard.getProperty("validator");
        String validatorType = (String)wizard.getProperty("validatorType");
        boolean generateValidator = validatorClassName != null;
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        templateProperties.put("targetElements", targetElements);
        if (generateValidator) {
            templateProperties.put("validator", validatorClassName);
            templateProperties.put("validatorType", validatorType);
        }
        DataObject dobj = null;
        String constraintClass = wizard.getTargetName();
        dobj = dTemplate.createFromTemplate(df, constraintClass, templateProperties);
        if (generateValidator && (validatorDataObject = ConstraintIterator.createValidator(df, validatorTemplate = template.getParent().getFileObject("Validator.java"), validatorClassName, validatorType, constraintClass)) != null) {
            return new HashSet<DataObject>(Arrays.asList(dobj, validatorDataObject));
        }
        return Collections.singleton(dobj);
    }

    public void initialize(TemplateWizard wizard) {
        WizardDescriptor.Panel javaPanel;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        ConstraintPanel constraintPanel = new ConstraintPanel(wizard);
        SourceGroup[] sourceGroup = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroup.length == 0) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConstraintIterator.class, (String)"MSG_No_Sources_found"));
            javaPanel = constraintPanel;
        } else {
            javaPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroup, (WizardDescriptor.Panel)constraintPanel, (boolean)true);
            javaPanel.addChangeListener((ChangeListener)constraintPanel);
        }
        this.panels = new WizardDescriptor.Panel[]{javaPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(ConstraintIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static DataObject createValidator(DataFolder df, FileObject template, String className, String type, String constraintClass) {
        try {
            DataObject dTemplate = DataObject.find((FileObject)template);
            HashMap<String, String> templateProperties = new HashMap<String, String>();
            templateProperties.put("validatorType", type);
            templateProperties.put("constraint", constraintClass);
            return dTemplate.createFromTemplate(df, className, templateProperties);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    static class WizardProperties {
        public static final String CONSTRAINT_CLASS_NAME = "constraint";
        public static final String VALIDATOR_CLASS_NAME = "validator";
        public static final String VALIDATOR_TYPE = "validatorType";
        public static final String TARGET_ELEMENTS = "targetElements";

        WizardProperties() {
        }
    }
}

