/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.remotecommand;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.remotecommand.RemoteCommand;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        RemoteCommand command = (RemoteCommand)component;
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(command.getClientId(facesContext))) {
            command.queueEvent((FacesEvent)new ActionEvent((UIComponent)command));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        RemoteCommand command = (RemoteCommand)component;
        String clientId = command.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)command);
        if (form == null) {
            throw new FacesException("Remote Command '" + command.getName() + "' must be enclosed inside a form component.");
        }
        String formClientId = form.getClientId(facesContext);
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(command.getName() + " = function() {");
        writer.write(this.buildAjaxRequest(facesContext, command, formClientId, clientId));
        writer.write("}");
        writer.endElement("script");
    }
}

