/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubar;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menubar.Menubar;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;

public class MenubarRenderer
extends BaseMenuRenderer {
    private static final Logger logger = Logger.getLogger(MenubarRenderer.class.getName());

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menubar menubar = (Menubar)abstractMenu;
        String clientId = menubar.getClientId(context);
        String widgetVar = menubar.resolveWidgetVar();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.Menubar('" + clientId + "',{");
        writer.write("autoSubmenuDisplay:" + menubar.isAutoSubmenuDisplay());
        writer.write(",animated:'" + menubar.getEffect() + "'");
        if (menubar.getEffectDuration() != 400) {
            writer.write(",showDuration:" + menubar.getEffectDuration());
            writer.write(",hideDuration:" + menubar.getEffectDuration());
        }
        if (menubar.getStyleClass() != null) {
            writer.write(",styleClass:'" + menubar.getStyleClass() + "'");
        }
        if (menubar.getStyle() != null) {
            writer.write(",style:'" + menubar.getStyle() + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menubar menubar = (Menubar)abstractMenu;
        String clientId = menubar.getClientId(context);
        writer.startElement("div", (UIComponent)menubar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        this.encodeMenuContent(context, (UIComponent)menubar);
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", null);
            if (child instanceof MenuItem) {
                this.encodeMenuItem(context, (MenuItem)child);
            } else if (child instanceof Submenu) {
                this.encodeSubmenu(context, (Submenu)child);
            }
            writer.endElement("li");
        }
    }

    protected void encodeSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent labelFacet = submenu.getFacet("label");
        String icon = submenu.getIcon();
        if (labelFacet == null) {
            String label = submenu.getLabel();
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"javascript:void(0)", null);
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
                writer.endElement("span");
            }
            if (label != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"wijmo-wijmenu-text", null);
                writer.write(submenu.getLabel());
                writer.endElement("span");
            }
            writer.endElement("a");
        } else {
            logger.info("label facet of a menubar item is deprecated, use a menuitem instead instead of a submenu.");
            this.encodeMenuItem(context, (MenuItem)labelFacet);
        }
        if (submenu.getChildCount() > 0) {
            writer.startElement("ul", null);
            this.encodeMenuContent(context, (UIComponent)submenu);
            writer.endElement("ul");
        }
    }
}

