/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.props;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cnd.debugger.common2.utils.props.Property;
import org.netbeans.modules.cnd.debugger.common2.utils.props.PropertyOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyOwnerSupport
implements PropertyOwner {
    private List<Property> props = new LinkedList<Property>();
    private boolean dirty;

    @Override
    public void register(Property p) {
        this.props.add(p);
    }

    @Override
    public Property propertyByName(String name) {
        for (Property p : this.props) {
            if (!p.name().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Property propertyByKey(String key) {
        for (Property p : this.props) {
            if (p.key() != key) continue;
            return p;
        }
        return null;
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.props.iterator();
    }

    void setDirty() {
        this.dirty = true;
        this.propagateDirty();
    }

    protected void propagateDirty() {
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean equals(PropertyOwner that, PropertyOwner.Comparator comparator) {
        Iterator<Property> thisIter = this.iterator();
        Iterator thatIter = that.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            Property thatP;
            Property thisP = thisIter.next();
            if (comparator.equals(thisP, thatP = (Property)thatIter.next())) continue;
            return false;
        }
        return !thisIter.hasNext() && !thatIter.hasNext();
    }

    public void assign(PropertyOwner that) {
        for (Property thatProp : that) {
            String thatName = thatProp.name();
            Object thatObject = thatProp.getAsObject();
            for (Property thisProp : this) {
                String thisName = thisProp.name();
                if (thisName == null || !thisName.equals(thatName) || !thatProp.isDirty()) continue;
                thisProp.setFromObject(thatObject);
            }
        }
    }
}

