/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

public final class ItemSelectorResult {
    private final int[] selected_indices;
    private final boolean cancelled;
    private int routingToken;

    public static ItemSelectorResult selectAll(int nitems) {
        int[] selected = new int[nitems];
        for (int i = 0; i < nitems; ++i) {
            selected[i] = i;
        }
        return new ItemSelectorResult(false, selected);
    }

    static ItemSelectorResult select(int[] selected) {
        return new ItemSelectorResult(false, selected);
    }

    static ItemSelectorResult cancelled() {
        return new ItemSelectorResult(true, null);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int nSelected() {
        if (this.cancelled) {
            return 0;
        }
        return this.selected_indices.length;
    }

    public int[] selections() {
        return this.selected_indices;
    }

    public void setRoutingToken(int routingToken) {
        this.routingToken = routingToken;
    }

    public int getRoutingToken() {
        return this.routingToken;
    }

    private ItemSelectorResult(boolean cancelled, int[] selected_indices) {
        this.cancelled = cancelled;
        this.selected_indices = selected_indices;
        if (cancelled ? !$assertionsDisabled && selected_indices != null : !$assertionsDisabled && selected_indices == null) {
            throw new AssertionError();
        }
    }
}

