/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.ExecutorCND;
import org.netbeans.modules.cnd.debugger.common2.utils.Log;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.ErrorManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Executor {
    private final String name;
    private final Host host;
    private boolean destroyedByHand;
    public static final int NOPTY = 1;

    protected Executor(String name, Host host) {
        this.name = name;
        this.host = host;
    }

    public final String name() {
        return this.name;
    }

    public Host host() {
        return this.host;
    }

    public boolean isRemote() {
        return this.host.isRemote();
    }

    public abstract ExecutionEnvironment getExecutionEnvironment();

    public abstract boolean isAlive();

    public abstract void terminate() throws IOException;

    public abstract void interrupt(int var1) throws IOException;

    public abstract void interruptGroup() throws IOException;

    public abstract void sigqueue(int var1, int var2) throws IOException;

    public abstract String readlink(long var1);

    public abstract boolean is_64(String var1);

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    public abstract int startShellCmd(String[] var1);

    public abstract int startEngine(String var1, String[] var2, Map<String, String> var3, String var4, TermComponent var5, boolean var6, boolean var7);

    public abstract String getStartError();

    protected abstract int waitForEngine() throws InterruptedException;

    protected void destroyEngine() {
        this.destroyedByHand = true;
    }

    public abstract void reap();

    public boolean destroyedByHand() {
        return this.destroyedByHand;
    }

    public static Executor getDefault(String name, Host host, int flags) {
        return new ExecutorCND(name, host);
    }

    protected final void startMonitor() {
        InputOutput io = InputOutput.NULL;
        ExecutorTask task = ExecutionEngine.getDefault().execute(this.name(), (Runnable)new Tracker(this), io);
    }

    protected static class InputMonitor
    extends Thread {
        private final Reader reader;
        private final Writer writer;
        private static int nextSerial = 0;
        private int serial = nextSerial++;
        private static final int BUFSZ = 1024;
        private final char[] buf = new char[1024];

        InputMonitor(Reader reader, Writer writer) {
            super("ExecutorUnix.InputMonitor");
            this.reader = reader;
            this.writer = writer;
            this.setPriority(1);
        }

        public void run() {
            try {
                int nread;
                while ((nread = this.reader.read(this.buf, 0, 1024)) != -1) {
                    if (Log.Executor.debug) {
                        System.out.printf("InputMonitor-%d: %s\n", this.serial, new String(this.buf, 0, nread));
                    }
                    this.writer.write(this.buf, 0, nread);
                    this.writer.flush();
                }
                this.writer.close();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            if (Log.Executor.debug) {
                System.out.printf("InputMonitor done.\n", new Object[0]);
            }
        }
    }

    protected static class OutputMonitor
    extends Thread {
        private final InputStreamReader reader;
        private final Writer writer;
        private static int nextSerial = 0;
        private int serial = nextSerial++;
        private static final int BUFSZ = 1024;
        private final char[] buf = new char[1024];

        OutputMonitor(InputStreamReader reader, Writer writer) {
            super("ExecutorUnix.OutputMonitor");
            this.reader = reader;
            this.writer = writer;
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int nread;
                while ((nread = this.reader.read(this.buf, 0, 1024)) != -1) {
                    if (Log.Executor.debug) {
                        System.out.printf("OutputMonitor-%d: %s\n", this.serial, new String(this.buf, 0, nread));
                    }
                    this.writer.write(this.buf, 0, nread);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
    }

    private static class Tracker
    implements Runnable {
        private final Executor executor;

        public Tracker(Executor executor) {
            this.executor = executor;
        }

        private void safeNotify(String msg, Throwable t) {
        }

        private void print(final String msg) {
            if (!Log.Executor.debug) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    System.out.printf(msg, new Object[0]);
                }
            });
        }

        public void run() {
            try {
                if (Log.Executor.debug) {
                    System.out.printf("Tracker running ...\n", new Object[0]);
                }
                boolean done = false;
                while (!done) {
                    try {
                        this.executor.waitForEngine();
                        System.out.printf("Tracker done.\n", new Object[0]);
                        done = true;
                    }
                    catch (InterruptedException e) {
                        this.print("Task.run(): InterruptedException\n");
                        this.safeNotify("Task.runHelp(): ", e);
                    }
                }
            }
            catch (ThreadDeath e) {
                this.safeNotify("Task.runHelp(): ", e);
                this.print("Task.run(): ThreadDeath\n");
                this.executor.destroyEngine();
                throw e;
            }
        }
    }
}

