/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelListenerSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.values.VariableValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public abstract class VariableModel
extends ModelListenerSupport
implements TreeModel,
ExtendedNodeModelFilter,
TableModel,
TreeExpansionModel,
AsynchronousModelFilter {
    protected NativeDebugger debugger;
    private static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/common2/icons/";
    private static final String ICON_FIELD = "org/netbeans/modules/cnd/debugger/common2/icons/field";
    private static final String ICON_FIELD_STATIC = "org/netbeans/modules/cnd/debugger/common2/icons/field_static";
    private static final String ICON_FIELD_STATIC_PTR = "org/netbeans/modules/cnd/debugger/common2/icons/field_static_pointer";
    private static final String ICON_FIELD_PTR = "org/netbeans/modules/cnd/debugger/common2/icons/field_pointer";
    private static final String ICON_LOCAL = "org/netbeans/modules/cnd/debugger/common2/icons/local";
    private static final String ICON_LOCAL_STATIC = "org/netbeans/modules/cnd/debugger/common2/icons/local_static";
    private static final String ICON_LOCAL_STATIC_PTR = "org/netbeans/modules/cnd/debugger/common2/icons/local_static_pointer";
    private static final String ICON_LOCAL_PTR = "org/netbeans/modules/cnd/debugger/common2/icons/local_pointer";
    public static final Action Action_DYNAMIC_TYPE = new DynamicTypeAction();
    public static final Action Action_INHERITED_MEMBERS = new InheritedMembersAction();
    public static final Action Action_STATIC_MEMBERS = new StaticMembersAction();
    public static final Action Action_OUTPUT_FORMAT = new OutputFormatAction();

    public Executor asynchronous(Executor original, AsynchronousModelFilter.CALL asynchCall, Object node) {
        return AsynchronousModelFilter.CURRENT_THREAD;
    }

    protected VariableModel(ContextProvider ctx) {
        super("variable");
        this.debugger = (NativeDebugger)ctx.lookupFirst(null, NativeDebugger.class);
    }

    protected VariableModel() {
        super("variable");
    }

    protected abstract boolean isLocal();

    public Object getRoot() {
        return "Root";
    }

    public abstract Object[] getChildren(Object var1, int var2, int var3) throws UnknownTypeException;

    public abstract int getChildrenCount(Object var1) throws UnknownTypeException;

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            return v.isLeaf();
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Catalog.get("PROP_name");
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            return v.getVariableName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            if (v.isRoot()) {
                if (v.isStatic() && v.isPtr()) {
                    return ICON_LOCAL_STATIC_PTR;
                }
                if (v.isStatic()) {
                    return ICON_LOCAL_STATIC;
                }
                if (v.isPtr()) {
                    return ICON_LOCAL_PTR;
                }
                return ICON_LOCAL;
            }
            if (v.isStatic() && v.isPtr()) {
                return ICON_FIELD_STATIC_PTR;
            }
            if (v.isStatic()) {
                return ICON_FIELD_STATIC;
            }
            if (v.isPtr()) {
                return ICON_FIELD_PTR;
            }
            return ICON_FIELD;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Catalog.get("PROP_name");
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            if (Log.Variable.tipdebug) {
                String info = v.getDebugInfo();
                info = "<html>" + info + "</html>";
                return info;
            }
            return v.getType();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Variable) {
            return false;
        }
        if (node instanceof WatchVariable || node instanceof Watch) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException, IOException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Variable) {
            throw new IOException();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Variable) {
            return false;
        }
        if (node instanceof WatchVariable || node instanceof Watch) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws UnknownTypeException, IOException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Variable) {
            throw new IOException();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof WatchModel.EmptyWatch) {
            return true;
        }
        if (node instanceof WatchVariable || node instanceof Watch) {
            return true;
        }
        if (node instanceof Variable) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof WatchModel.EmptyWatch) {
            ((WatchModel.EmptyWatch)node).setExpression(name);
            return;
        }
        if (node instanceof WatchVariable || node instanceof Watch) {
            WatchVariable w = (WatchVariable)node;
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            debugger.replaceWatch(w.getNativeWatch(), name);
            return;
        }
        if (node instanceof Variable) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        if (node == "Root") {
            return new PasteType[0];
        }
        if (node instanceof Variable) {
            return new PasteType[0];
        }
        if (node instanceof WatchVariable || node instanceof Watch) {
            return new PasteType[0];
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return this.getIconBase((NodeModel)original, node) + ".gif";
        }
        if (node instanceof WatchModel.EmptyWatch) {
            return null;
        }
        if (node instanceof WatchVariable || node instanceof Watch) {
            WatchVariable w = (WatchVariable)node;
            return this.getIconBase((NodeModel)original, node) + ".gif";
        }
        if (node instanceof Variable) {
            return this.getIconBase((NodeModel)original, node) + ".gif";
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            if (columnID == "LocalsType" || columnID == "WatchType") {
                return v.getType();
            }
            if (columnID == "LocalsValue" || columnID == "WatchValue" || columnID == "LocalsToString" || columnID == "WatchToString") {
                VariableValue value = new VariableValue(v.getAsText(), v.getDelta());
                return value.toString();
            }
            return null;
        }
        if (node instanceof WatchModel.EmptyWatch) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Variable) {
            Variable v = (Variable)node;
            if (columnID == "LocalsValue" || columnID == "WatchValue") {
                return !v.isEditable();
            }
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if (node != "Root") {
            if (node instanceof Variable) {
                Variable v = (Variable)node;
                if (columnID == "LocalsValue" || columnID == "WatchValue") {
                    v.setVariableValue((String)value);
                }
            } else {
                throw new UnknownTypeException(node);
            }
        }
    }

    public synchronized boolean isExpanded(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            if (Log.Variable.expansion) {
                System.out.printf("isExpanded(%s) -> %s\n", var.getVariableName(), var.isExpanded());
            }
            return var.isExpanded();
        }
        throw new UnknownTypeException(node);
    }

    public synchronized void nodeCollapsed(Object node) {
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            if (Log.Variable.expansion) {
                System.out.printf("nodeCollapsed(%s) was %s\n", var.getVariableName(), var.isExpanded());
            }
            var.noteCollapsed(!this.isLocal());
        }
    }

    public synchronized void nodeExpanded(Object node) {
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            if (Log.Variable.expansion) {
                System.out.printf("nodeExpanded(%s) was %s\n", var.getVariableName(), var.isExpanded());
            }
            var.noteExpanded(!this.isLocal());
        }
    }

    public static class OutputFormatAction
    extends SystemAction
    implements Presenter.Popup {
        private Variable var;

        public void setVar(Variable v) {
            this.var = v;
        }

        public String getName() {
            return Catalog.get("ACT_Output_Format");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("output_format");
        }

        public void actionPerformed(ActionEvent ev) {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
        }

        public JMenuItem getPopupPresenter() {
            JMenu mi = new JMenu();
            Actions.connect((JMenuItem)mi, (Action)((Object)this), (boolean)false);
            mi.addMenuListener(new FormatItemListener());
            return mi;
        }

        private class FormatItemListener
        implements MenuListener {
            private FormatItemListener() {
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                menu.removeAll();
            }

            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
                String[] format_array = debugger.formatChoices();
                if (debugger != null) {
                    for (int vx = 0; vx < format_array.length; ++vx) {
                        boolean status = OutputFormatAction.this.var != null && format_array[vx].equals(OutputFormatAction.this.var.getFormat());
                        JRadioButtonMenuItem formatItem = new JRadioButtonMenuItem(format_array[vx], status);
                        menu.add(formatItem);
                        formatItem.setHorizontalTextPosition(2);
                        formatItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                FormatItemListener.this.updateFormat(actionEvent.getActionCommand());
                            }
                        });
                    }
                }
            }

            private void updateFormat(String format) {
                OutputFormatAction.this.var.postFormat(format);
            }
        }
    }

    private static class StaticMembersAction
    extends BooleanStateAction {
        StaticMembersAction() {
        }

        public boolean getBooleanState() {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            if (debugger instanceof NativeDebugger) {
                this.setEnabled(true);
                return debugger.isStaticMembers();
            }
            this.setEnabled(false);
            return false;
        }

        public String getName() {
            return Catalog.get("ACT_Static");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("show_static_members");
        }

        public void actionPerformed(ActionEvent e) {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            debugger.setStaticMembers(!this.getBooleanState());
        }
    }

    private static class InheritedMembersAction
    extends BooleanStateAction {
        InheritedMembersAction() {
        }

        public boolean getBooleanState() {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            if (debugger instanceof NativeDebugger) {
                this.setEnabled(true);
                return debugger.isInheritedMembers();
            }
            this.setEnabled(false);
            return false;
        }

        public String getName() {
            return Catalog.get("ACT_Inherited");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("output_inherited_members");
        }

        public void actionPerformed(ActionEvent e) {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            debugger.setInheritedMembers(!this.getBooleanState());
        }
    }

    private static class DynamicTypeAction
    extends BooleanStateAction {
        DynamicTypeAction() {
        }

        public boolean getBooleanState() {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            if (debugger instanceof NativeDebugger) {
                this.setEnabled(true);
                return debugger.isDynamicType();
            }
            this.setEnabled(false);
            return false;
        }

        public String getName() {
            return Catalog.get("ACT_Dynamic");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("output_dynamic_type");
        }

        public void actionPerformed(ActionEvent e) {
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            debugger.setDynamicType(!this.getBooleanState());
        }
    }

    public static class BrowseArrayAction
    extends AbstractAction {
        private Object node = null;

        public BrowseArrayAction(Object node) {
            super("Browse Array");
            this.node = node;
            if (node instanceof Variable) {
                Variable v = (Variable)node;
                this.setEnabled(v.isArrayBrowsable());
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            Variable v;
            NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
            if (!(this.node instanceof Variable) || (v = (Variable)this.node).isArrayBrowsable()) {
                // empty if block
            }
        }
    }
}

