/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import java.io.File;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.fs.Locker;
import org.apache.maven.index.updater.ResourceFetcher;

public class IndexUpdateRequest {
    private final IndexingContext context;
    private final ResourceFetcher resourceFetcher;
    private DocumentFilter documentFilter;
    private boolean forceFullUpdate;
    private File localIndexCacheDir;
    private Locker locker;
    private boolean offline;
    private boolean cacheOnly;

    public IndexUpdateRequest(IndexingContext context, ResourceFetcher resourceFetcher) {
        assert (context != null) : "Context to be updated cannot be null!";
        assert (resourceFetcher != null) : "ResourceFetcher has to be provided!";
        this.context = context;
        this.resourceFetcher = resourceFetcher;
        this.forceFullUpdate = false;
    }

    public IndexingContext getIndexingContext() {
        return this.context;
    }

    public ResourceFetcher getResourceFetcher() {
        return this.resourceFetcher;
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        this.documentFilter = documentFilter;
    }

    public void setForceFullUpdate(boolean forceFullUpdate) {
        this.forceFullUpdate = forceFullUpdate;
    }

    public boolean isForceFullUpdate() {
        return this.forceFullUpdate;
    }

    public File getLocalIndexCacheDir() {
        return this.localIndexCacheDir;
    }

    public void setLocalIndexCacheDir(File dir) {
        this.localIndexCacheDir = dir;
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void setLocker(Locker locker) {
        this.locker = locker;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setCacheOnly(boolean cacheOnly) {
        this.cacheOnly = cacheOnly;
    }

    public boolean isCacheOnly() {
        return this.cacheOnly;
    }
}

