/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Image;
import java.net.URL;
import java.text.MessageFormat;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class DeployOnSaveUtils {
    private static final String COS_MARK = ".netbeans_automatic_build";
    private static final String DEPLOY_ON_SAVE_DISABLED_BADGE_PATH = "org/netbeans/modules/j2ee/common/ui/resources/compileOnSaveDisabledBadge.gif";
    private static final Image DEPLOY_ON_SAVE_DISABLED_BADGE;

    private DeployOnSaveUtils() {
    }

    public static Image badgeDisabledDeployOnSave(Image icon) {
        return ImageUtilities.mergeImages((Image)icon, (Image)DEPLOY_ON_SAVE_DISABLED_BADGE, (int)8, (int)0);
    }

    public static boolean containsIdeArtifacts(PropertyEvaluator evaluator, UpdateHelper updateHelper, String classesPropertyName) {
        FileObject buildClasses;
        String propertyValue;
        FileObject mark = null;
        String string = propertyValue = classesPropertyName != null ? evaluator.getProperty(classesPropertyName) : null;
        if (propertyValue != null && (buildClasses = updateHelper.getAntProjectHelper().resolveFileObject(propertyValue)) != null) {
            mark = buildClasses.getFileObject(COS_MARK);
        }
        return mark != null;
    }

    public static boolean showBuildActionWarning(Project project, CustomizerPresenter presenter) {
        String text = NbBundle.getMessage(DeployOnSaveUtils.class, (String)"LBL_ProjectBuiltAutomatically");
        String projectProperties = NbBundle.getMessage(DeployOnSaveUtils.class, (String)"BTN_ProjectProperties");
        String cleanAndBuild = NbBundle.getMessage(DeployOnSaveUtils.class, (String)"BTN_CleanAndBuild");
        String ok = NbBundle.getMessage(DeployOnSaveUtils.class, (String)"BTN_OK");
        String titleFormat = NbBundle.getMessage(DeployOnSaveUtils.class, (String)"TITLE_BuildProjectWarning");
        String title = MessageFormat.format(titleFormat, ProjectUtils.getInformation((Project)project).getDisplayName());
        DialogDescriptor dd = new DialogDescriptor((Object)text, title, true, new Object[]{projectProperties, cleanAndBuild, ok}, (Object)ok, 0, null, null);
        dd.setMessageType(2);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == projectProperties) {
            if (presenter != null) {
                presenter.showCustomizer("Run");
            }
            return false;
        }
        return result == cleanAndBuild;
    }

    public static void performCleanup(Project project, PropertyEvaluator evaluator, UpdateHelper updateHelper, String classesPropertyName, boolean forceCleanup) {
        FileObject buildClasses;
        String propertyValue;
        FileObject mark = null;
        String string = propertyValue = classesPropertyName != null ? evaluator.getProperty(classesPropertyName) : null;
        if (propertyValue != null && (buildClasses = updateHelper.getAntProjectHelper().resolveFileObject(propertyValue)) != null) {
            mark = buildClasses.getFileObject(COS_MARK);
        }
        if (mark != null || forceCleanup) {
            ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
            assert (ap != null);
            ap.invokeAction("clean", Lookups.fixed((Object[])new Object[]{project}));
        }
    }

    public static String isDeployOnSaveSupported(String serverInstanceID) {
        boolean deployOnSaveEnabled = false;
        try {
            deployOnSaveEnabled = Deployment.getDefault().getServerInstance(serverInstanceID).isDeployOnSaveSupported();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return Boolean.toString(deployOnSaveEnabled);
    }

    static {
        URL errorBadgeIconURL = DeployOnSaveUtils.class.getClassLoader().getResource(DEPLOY_ON_SAVE_DISABLED_BADGE_PATH);
        String compileOnSaveDisabledTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(DeployOnSaveUtils.class, (String)"TP_DeployOnSaveDisabled");
        DEPLOY_ON_SAVE_DISABLED_BADGE = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)DEPLOY_ON_SAVE_DISABLED_BADGE_PATH), (String)compileOnSaveDisabledTP);
    }

    public static interface CustomizerPresenter {
        public void showCustomizer(String var1);
    }
}

