/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.archive.project.ArchiveProject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class ProvidesJ2eeModule
extends J2eeModuleProvider {
    private J2eeModuleProvider inner;
    private J2eeModule innerModule;
    private AntProjectHelper helper;
    private ArchiveProject project;
    private static final String CONF = "conf";
    private static final String SRC_LIT = "src";

    ProvidesJ2eeModule(AntProjectHelper helper, ArchiveProject proj) {
        this.helper = helper;
        this.inner = null;
        this.project = proj;
    }

    public void setInner(J2eeModuleProvider inner) {
        this.inner = inner;
        this.innerModule = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)new InnerModule(inner.getJ2eeModule()));
    }

    public String getDeploymentName() {
        return this.project.getName();
    }

    public J2eeModule getJ2eeModule() {
        return this.innerModule;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        ModuleChangeReporter retVal = null;
        if (null != this.inner) {
            retVal = this.inner.getModuleChangeReporter();
        }
        return retVal;
    }

    public File getDeploymentConfigurationFile(String name) {
        String dir = (String)this.project.getArchiveProjectProperties().get("proxy.project.dir");
        File proxyProjectDir = FileUtil.toFile((FileObject)this.helper.getProjectDirectory().getFileObject(dir));
        File retVal = new File(proxyProjectDir, SRC_LIT + File.separator + CONF + File.separator + name);
        return retVal;
    }

    public FileObject findDeploymentConfigurationFile(String name) {
        FileObject retVal = null;
        String dir = (String)this.project.getArchiveProjectProperties().get("proxy.project.dir");
        try {
            FileObject parent;
            if ("sun-application.xml".equals(name) && (retVal = this.helper.getProjectDirectory().getFileObject(dir).getFileObject(SRC_LIT).getFileObject(CONF).getFileObject(name)) == null) {
                parent = this.helper.getProjectDirectory().getFileObject(dir).getFileObject(SRC_LIT).getFileObject(CONF);
                retVal = this.makeDescriptorFromTemplate(parent, name);
            }
            if ("sun-ra.xml".equals(name)) {
                retVal = this.helper.getProjectDirectory().getFileObject(dir).getFileObject(SRC_LIT).getFileObject(CONF).getFileObject(name);
                if (null == retVal) {
                    retVal = this.helper.getProjectDirectory().getFileObject(dir).getFileObject(SRC_LIT).getFileObject(name);
                }
                if (retVal == null) {
                    parent = this.helper.getProjectDirectory().getFileObject(dir).getFileObject(SRC_LIT);
                    retVal = this.makeDescriptorFromTemplate(parent, name);
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject makeDescriptorFromTemplate(FileObject parent, String name) throws IOException {
        FileObject retVal;
        InputStream is = ProvidesJ2eeModule.class.getResourceAsStream("template-" + name);
        try {
            FileSystem fs = parent.getFileSystem();
            fs.runAtomicAction((FileSystem.AtomicAction)new AtomicCreate(is, parent, name));
            retVal = parent.getFileObject(name);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        }
        return retVal;
    }

    public void setServerInstanceID(String severInstanceID) {
        if (null != this.inner) {
            this.inner.setServerInstanceID(severInstanceID);
        }
    }

    public String getServerInstanceID() {
        String retVal = null != this.inner ? this.inner.getServerInstanceID() : this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        return retVal;
    }

    public String getServerID() {
        String inst = this.getServerInstanceID();
        String retVal = null;
        if (inst != null) {
            String id = null;
            try {
                id = Deployment.getDefault().getServerInstance(inst).getServerID();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger("global").log(Level.INFO, inst, ex);
            }
            if (id != null) {
                retVal = id;
            }
        }
        return null != retVal ? retVal : this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        FileObject retVal = null;
        if (prop != null) {
            retVal = this.helper.resolveFileObject(prop);
        }
        return retVal;
    }

    public File getEnterpriseResourceDirectory() {
        File retValue = null;
        try {
            FileObject fo = FileUtil.createFolder((FileObject)this.helper.getProjectDirectory(), (String)"setup");
            retValue = FileUtil.toFile((FileObject)fo);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(this.helper.getProjectDirectory().getPath());
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return retValue;
    }

    void setJ2eeModule(J2eeModule j2eeModule) {
        this.innerModule = j2eeModule;
    }

    private class InnerModule
    implements J2eeModuleImplementation2 {
        private J2eeModule inner;

        InnerModule(J2eeModule inner) {
            this.inner = inner;
        }

        public String getModuleVersion() {
            return this.inner.getModuleVersion();
        }

        public J2eeModule.Type getModuleType() {
            return this.inner.getType();
        }

        public String getUrl() {
            return this.inner.getUrl();
        }

        public FileObject getArchive() throws IOException {
            return ProvidesJ2eeModule.this.getFileObject("dist.archive");
        }

        public Iterator getArchiveContents() throws IOException {
            return this.inner.getArchiveContents();
        }

        public FileObject getContentDirectory() throws IOException {
            return null;
        }

        public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
            return this.inner.getMetadataModel(type);
        }

        public File getResourceDirectory() {
            return this.inner.getResourceDirectory();
        }

        public File getDeploymentConfigurationFile(String name) {
            return this.inner.getDeploymentConfigurationFile(name);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.inner.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.inner.removePropertyChangeListener(listener);
        }
    }

    private static class AtomicCreate
    implements FileSystem.AtomicAction {
        private InputStream is;
        private String name;
        private FileObject parent;

        AtomicCreate(InputStream is, FileObject parent, String name) {
            this.is = is;
            this.name = name;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock flock = null;
            OutputStream os = null;
            FileObject retVal = null;
            try {
                retVal = this.parent.createData(this.name);
                flock = retVal.lock();
                os = retVal.getOutputStream(flock);
                FileUtil.copy((InputStream)this.is, (OutputStream)os);
            }
            finally {
                if (null != flock) {
                    flock.releaseLock();
                }
                if ((this.is == null || os == null) && null != retVal) {
                    try {
                        retVal.delete();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                if (null != os) {
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                }
            }
        }
    }
}

