/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.ui.customizer.RunAsWebAdvanced;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RunAsLocalWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -53489817846332331L;
    private final PhpProjectProperties properties;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    final ProjectCustomizer.Category category;
    private JButton advancedButton;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JTextArea hintLabel;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JComboBox runAsCombo;
    private JLabel runAsLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsLocalWeb(PhpProjectProperties properties, ConfigManager manager, ProjectCustomizer.Category category) {
        super(manager);
        this.properties = properties;
        this.category = category;
        this.project = properties.getProject();
        this.displayName = NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_ConfigLocalWeb");
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.indexFileLabel, this.argsLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.indexFileTextField, this.argsTextField};
        this.propertyNames = new String[]{"url", "index.file", "script.arguments"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
    }

    @Override
    protected boolean isDefault() {
        return true;
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.LOCAL;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    public JComboBox getRunAsCombo() {
        return this.runAsCombo;
    }

    @Override
    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
    }

    @Override
    protected void validateFields() {
        String url = this.urlTextField.getText();
        String indexFile = this.indexFileTextField.getText();
        String args = this.argsTextField.getText();
        if (!StringUtils.hasText((String)indexFile)) {
            indexFile = null;
        }
        String err = RunAsValidator.validateWebFields(url, this.getWebRoot(), indexFile, args);
        this.category.setErrorMessage(err);
        this.category.setValid(true);
    }

    private FileObject getWebRoot() {
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, this.properties.getWebRoot());
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.hintLabel = new JTextArea();
        this.advancedButton = new JButton();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return RunAsLocalWeb.this.advancedButton;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return RunAsLocalWeb.this.advancedButton;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return RunAsLocalWeb.this.advancedButton;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (aComponent == RunAsLocalWeb.this.runAsCombo) {
                    return RunAsLocalWeb.this.urlTextField;
                }
                if (aComponent == RunAsLocalWeb.this.indexFileTextField) {
                    return RunAsLocalWeb.this.indexFileBrowseButton;
                }
                if (aComponent == RunAsLocalWeb.this.indexFileBrowseButton) {
                    return RunAsLocalWeb.this.argsTextField;
                }
                if (aComponent == RunAsLocalWeb.this.urlTextField) {
                    return RunAsLocalWeb.this.indexFileTextField;
                }
                if (aComponent == RunAsLocalWeb.this.argsTextField) {
                    return RunAsLocalWeb.this.advancedButton;
                }
                return RunAsLocalWeb.this.advancedButton;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (aComponent == RunAsLocalWeb.this.urlTextField) {
                    return RunAsLocalWeb.this.runAsCombo;
                }
                if (aComponent == RunAsLocalWeb.this.indexFileBrowseButton) {
                    return RunAsLocalWeb.this.indexFileTextField;
                }
                if (aComponent == RunAsLocalWeb.this.argsTextField) {
                    return RunAsLocalWeb.this.indexFileBrowseButton;
                }
                if (aComponent == RunAsLocalWeb.this.indexFileTextField) {
                    return RunAsLocalWeb.this.urlTextField;
                }
                if (aComponent == RunAsLocalWeb.this.advancedButton) {
                    return RunAsLocalWeb.this.argsTextField;
                }
                return RunAsLocalWeb.this.advancedButton;
            }
        });
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_ProjectUrl"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_IndexFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsLocalWeb.this.indexFileBrowseButtonActionPerformed(evt);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_Arguments"));
        this.hintLabel.setEditable(false);
        this.hintLabel.setLineWrap(true);
        this.hintLabel.setRows(2);
        this.hintLabel.setWrapStyleWord(true);
        this.hintLabel.setBorder(null);
        this.hintLabel.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.advancedButton.text"));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsLocalWeb.this.advancedButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.advancedButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.argsLabel).addComponent(this.urlLabel).addComponent(this.indexFileLabel).addComponent(this.runAsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hintLabel, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.argsTextField, GroupLayout.Alignment.TRAILING, -1, 220, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.indexFileTextField, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexFileBrowseButton)).addComponent(this.runAsCombo, GroupLayout.Alignment.TRAILING, 0, 220, Short.MAX_VALUE).addComponent(this.urlTextField, GroupLayout.Alignment.TRAILING, -1, 220, Short.MAX_VALUE)))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsCombo, -2, -1, -2).addComponent(this.runAsLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.indexFileBrowseButton).addComponent(this.indexFileTextField, -2, -1, -2).addComponent(this.indexFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.argsLabel).addComponent(this.argsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsCombo.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsTextField.AccessibleContext.accessibleDescription"));
        this.hintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.hintLabel.AccessibleContext.accessibleName"));
        this.hintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.hintLabel.AccessibleContext.accessibleDescription"));
        this.advancedButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.advancedButton.AccessibleContext.accessibleName"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.advancedButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.AccessibleContext.accessibleDescription"));
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent evt) {
        Utils.browseFolderFile(PhpVisibilityQuery.forProject(this.project), this.getWebRoot(), this.indexFileTextField);
    }

    private void advancedButtonActionPerformed(ActionEvent evt) {
        RunAsWebAdvanced.Properties props = new RunAsWebAdvanced.Properties(this.getValue("debug.url"), this.hintLabel.getText(), this.getValue("debug.path.mapping.remote"), this.getValue("debug.path.mapping.local"), this.getValue("debug.proxy.host"), this.getValue("debug.proxy.port"));
        RunAsWebAdvanced advanced = new RunAsWebAdvanced(this.project, props);
        if (advanced.open()) {
            Pair<String, String> pathMapping = advanced.getPathMapping();
            Pair<String, String> debugProxy = advanced.getDebugProxy();
            this.putValue("debug.url", advanced.getDebugUrl().name());
            this.putValue("debug.path.mapping.remote", (String)pathMapping.first);
            this.putValue("debug.path.mapping.local", (String)pathMapping.second);
            this.putValue("debug.proxy.host", (String)debugProxy.first);
            this.putValue("debug.proxy.port", (String)debugProxy.second);
        }
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(RunAsLocalWeb.this, propName, label, field);
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsLocalWeb.this.getDefaultValue(this.getPropName());
        }

        @Override
        protected void processUpdate() {
            super.processUpdate();
            String hint = "";
            try {
                hint = RunAsValidator.composeUrlHint(RunAsLocalWeb.this.urlTextField.getText(), RunAsLocalWeb.this.indexFileTextField.getText(), RunAsLocalWeb.this.argsTextField.getText());
            }
            catch (RunAsValidator.InvalidUrlException ex) {
                RunAsLocalWeb.this.category.setErrorMessage(ex.getMessage());
                RunAsLocalWeb.this.category.setValid(false);
            }
            RunAsLocalWeb.this.hintLabel.setText(hint);
        }
    }
}

