/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class ElementDeclaration {
    private static Logger log = Logger.getLogger(ElementDeclaration.class.getName());

    private ElementDeclaration() {
    }

    public static DeclarationFinder.DeclarationLocation getDeclarationLocation(ClasspathInfo cpInfo, Element el) {
        ElementHandle handle = ElementHandle.create((Element)el);
        FileObject fo = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)cpInfo);
        if (fo != null) {
            return ElementDeclaration.getDeclarationLocation(fo, (ElementHandle<? extends Element>)handle);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static DeclarationFinder.DeclarationLocation getDeclarationLocation(FileObject fo, ElementHandle<? extends Element> handle) {
        assert (fo != null);
        try {
            int offset = ElementDeclaration.getOffset(fo, handle);
            return new DeclarationFinder.DeclarationLocation(fo, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    private static int getOffset(FileObject fo, final ElementHandle<? extends Element> handle) throws IOException {
        if (IndexingManager.getDefault().isIndexing()) {
            log.info("Skipping location of element offset within file, Scannig in progress");
            return 0;
        }
        final int[] result = new int[]{-1};
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) {
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    Element el = handle.resolve((CompilationInfo)info);
                    if (el == null) {
                        log.severe("Cannot resolve " + handle + ". " + info.getClasspathInfo());
                        return;
                    }
                    FindDeclarationVisitor v = new FindDeclarationVisitor(el, (CompilationInfo)info);
                    CompilationUnitTree cu = info.getCompilationUnit();
                    v.scan(cu, null);
                    Tree elTree = v.declTree;
                    if (elTree != null) {
                        result[0] = (int)info.getTrees().getSourcePositions().getStartPosition(cu, elTree);
                    }
                }
            }, true);
        }
        return result[0];
    }

    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo info) {
            this.element = element;
            this.info = info;
        }

        @Override
        public Void visitClass(ClassTree tree, Void d) {
            this.handleDeclaration();
            super.visitClass(tree, d);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void d) {
            this.handleDeclaration();
            super.visitMethod(tree, d);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree tree, Void d) {
            this.handleDeclaration();
            super.visitVariable(tree, d);
            return null;
        }

        public void handleDeclaration() {
            Element found = this.info.getTrees().getElement(this.getCurrentPath());
            if (((Object)this.element).equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

