/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.JoinColumn;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.PrimaryKeyJoinColumn;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.IdClassImpl;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.JoinColumnImpl;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.PrimaryKeyJoinColumnImpl;

public class EntityMappingsUtilities {
    private static final Set<String> ORM_ANNOTATIONS = new HashSet<String>();

    public static boolean isTransient(Map<String, ? extends AnnotationMirror> annByType, Set<Modifier> modifiers) {
        return annByType.containsKey("javax.persistence.Transient") || modifiers.contains((Object)Modifier.TRANSIENT);
    }

    public static boolean hasFieldAccess(AnnotationModelHelper helper, List<? extends Element> elements) {
        for (ExecutableElement element : ElementFilter.methodsIn(elements)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                String annTypeName = helper.getAnnotationTypeName(annotationMirror.getAnnotationType());
                if (annTypeName == null || !ORM_ANNOTATIONS.contains(annTypeName)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getterNameToPropertyName(String getterName) {
        if (getterName.length() > 3 && getterName.startsWith("get")) {
            return EntityMappingsUtilities.toLowerCaseFirst(getterName.substring(3));
        }
        if (getterName.length() > 2 && getterName.startsWith("is")) {
            return EntityMappingsUtilities.toLowerCaseFirst(getterName.substring(2));
        }
        return null;
    }

    public static String toUpperCase(String value) {
        return value.toUpperCase();
    }

    public static String getElementTypeName(Element element) {
        TypeMirror elementType = element.asType();
        if (TypeKind.DECLARED.equals((Object)elementType.getKind())) {
            return ((TypeElement)((DeclaredType)elementType).asElement()).getQualifiedName().toString();
        }
        return Void.TYPE.getName();
    }

    public static String getCollectionArgumentTypeName(AnnotationModelHelper helper, Element element) {
        TypeElement argTypeElement;
        TypeMirror elementType = element.asType();
        if (EntityMappingsUtilities.isCollectionType(helper, elementType) && (argTypeElement = EntityMappingsUtilities.getFirstTypeArgument(elementType)) != null) {
            return argTypeElement.getQualifiedName().toString();
        }
        return Void.TYPE.getName();
    }

    public static List<JoinColumn> getJoinColumns(final AnnotationModelHelper helper, Map<String, ? extends AnnotationMirror> annByType) {
        final ArrayList<JoinColumn> result = new ArrayList<JoinColumn>();
        AnnotationMirror joinColumnAnn = annByType.get("javax.persistence.JoinColumn");
        if (joinColumnAnn != null) {
            result.add(new JoinColumnImpl(helper, joinColumnAnn));
        } else {
            AnnotationMirror joinColumnsAnnotation = annByType.get("javax.persistence.JoinColumns");
            if (joinColumnsAnnotation != null) {
                AnnotationParser jcParser = AnnotationParser.create((AnnotationModelHelper)helper);
                jcParser.expectAnnotationArray("value", helper.resolveType("javax.persistence.JoinColumn"), new ArrayValueHandler(){

                    public Object handleArray(List<AnnotationValue> arrayMembers) {
                        for (AnnotationValue arrayMember : arrayMembers) {
                            AnnotationMirror joinColumnAnnotation = (AnnotationMirror)arrayMember.getValue();
                            result.add(new JoinColumnImpl(helper, joinColumnAnnotation));
                        }
                        return null;
                    }
                }, null);
                jcParser.parse(joinColumnsAnnotation);
            }
        }
        return result;
    }

    public static List<PrimaryKeyJoinColumn> getPrimaryKeyJoinColumns(final AnnotationModelHelper helper, Map<String, ? extends AnnotationMirror> annByType) {
        final ArrayList<PrimaryKeyJoinColumn> result = new ArrayList<PrimaryKeyJoinColumn>();
        AnnotationMirror pkJoinColumnAnn = annByType.get("javax.persistence.PrimaryKeyJoinColumn");
        if (pkJoinColumnAnn != null) {
            result.add(new PrimaryKeyJoinColumnImpl(helper, pkJoinColumnAnn));
        } else {
            AnnotationMirror pkJoinColumnsAnnotation = annByType.get("javax.persistence.PrimaryKeyJoinColumns");
            if (pkJoinColumnsAnnotation != null) {
                AnnotationParser pkjcParser = AnnotationParser.create((AnnotationModelHelper)helper);
                pkjcParser.expectAnnotationArray("value", helper.resolveType("javax.persistence.PrimaryKeyJoinColumn"), new ArrayValueHandler(){

                    public Object handleArray(List<AnnotationValue> arrayMembers) {
                        for (AnnotationValue arrayMember : arrayMembers) {
                            AnnotationMirror joinColumnAnnotation = (AnnotationMirror)arrayMember.getValue();
                            result.add(new PrimaryKeyJoinColumnImpl(helper, joinColumnAnnotation));
                        }
                        return null;
                    }
                }, null);
                pkjcParser.parse(pkJoinColumnsAnnotation);
            }
        }
        return result;
    }

    public static String getTemporalType(AnnotationModelHelper helper, AnnotationMirror temporalAnnotation) {
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectEnumConstant("value", helper.resolveType("javax.persistence.TemporalType"), null);
        return (String)parser.parse(temporalAnnotation).get("value", String.class);
    }

    public static IdClassImpl getIdClass(AnnotationModelHelper helper, TypeElement typeElement) {
        AnnotationMirror idClassAnn = (AnnotationMirror)helper.getAnnotationsByType(typeElement.getAnnotationMirrors()).get("javax.persistence.IdClass");
        if (idClassAnn == null) {
            return null;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectClass("value", null);
        String class2 = (String)parser.parse(idClassAnn).get("value", String.class);
        return new IdClassImpl(class2);
    }

    static TypeElement getFirstTypeArgument(TypeMirror type) {
        if (TypeKind.DECLARED != type.getKind()) {
            return null;
        }
        List<? extends TypeMirror> typeArgs = ((DeclaredType)type).getTypeArguments();
        if (typeArgs.size() != 1) {
            return null;
        }
        TypeMirror typeArg = typeArgs.iterator().next();
        if (TypeKind.DECLARED != typeArg.getKind()) {
            return null;
        }
        Element typeArgElement = ((DeclaredType)typeArg).asElement();
        if (ElementKind.CLASS != typeArgElement.getKind()) {
            return null;
        }
        return (TypeElement)typeArgElement;
    }

    static boolean isCollectionType(AnnotationModelHelper helper, TypeMirror type) {
        return helper.isSameRawType(type, "java.util.Collection") || helper.isSameRawType(type, "java.util.Set") || helper.isSameRawType(type, "java.util.List") || helper.isSameRawType(type, "java.util.Map");
    }

    private static String toLowerCaseFirst(String value) {
        if (value.length() > 0) {
            char[] characters = value.toCharArray();
            characters[0] = Character.toLowerCase(characters[0]);
            return new String(characters);
        }
        return value;
    }

    static {
        ORM_ANNOTATIONS.add("javax.persistence.AssociationOverride");
        ORM_ANNOTATIONS.add("javax.persistence.AssociationOverrides");
        ORM_ANNOTATIONS.add("javax.persistence.AttributeOverride");
        ORM_ANNOTATIONS.add("javax.persistence.AttributeOverrides");
        ORM_ANNOTATIONS.add("javax.persistence.Basic");
        ORM_ANNOTATIONS.add("javax.persistence.Column");
        ORM_ANNOTATIONS.add("javax.persistence.DiscriminatorColumn");
        ORM_ANNOTATIONS.add("javax.persistence.DiscriminatorValue");
        ORM_ANNOTATIONS.add("javax.persistence.Embeddable");
        ORM_ANNOTATIONS.add("javax.persistence.Embedded");
        ORM_ANNOTATIONS.add("javax.persistence.EmbeddedId");
        ORM_ANNOTATIONS.add("javax.persistence.Enumerated");
        ORM_ANNOTATIONS.add("javax.persistence.GeneratedValue");
        ORM_ANNOTATIONS.add("javax.persistence.Id");
        ORM_ANNOTATIONS.add("javax.persistence.IdClass");
        ORM_ANNOTATIONS.add("javax.persistence.Inheritance");
        ORM_ANNOTATIONS.add("javax.persistence.JoinColumn");
        ORM_ANNOTATIONS.add("javax.persistence.JoinColumns");
        ORM_ANNOTATIONS.add("javax.persistence.JoinTable");
        ORM_ANNOTATIONS.add("javax.persistence.Lob");
        ORM_ANNOTATIONS.add("javax.persistence.ManyToMany");
        ORM_ANNOTATIONS.add("javax.persistence.ManyToOne");
        ORM_ANNOTATIONS.add("javax.persistence.MapKey");
        ORM_ANNOTATIONS.add("javax.persistence.MappedSuperclass");
        ORM_ANNOTATIONS.add("javax.persistence.OneToMany");
        ORM_ANNOTATIONS.add("javax.persistence.OneToOne");
        ORM_ANNOTATIONS.add("javax.persistence.OrderBy");
        ORM_ANNOTATIONS.add("javax.persistence.PrimaryKeyJoinColumn");
        ORM_ANNOTATIONS.add("javax.persistence.PrimaryKeyJoinColumns");
        ORM_ANNOTATIONS.add("javax.persistence.SecondaryTable");
        ORM_ANNOTATIONS.add("javax.persistence.SecondaryTables");
        ORM_ANNOTATIONS.add("javax.persistence.SequenceGenerator");
        ORM_ANNOTATIONS.add("javax.persistence.Table");
        ORM_ANNOTATIONS.add("javax.persistence.TableGenerator");
        ORM_ANNOTATIONS.add("javax.persistence.Temporal");
        ORM_ANNOTATIONS.add("javax.persistence.Transient");
        ORM_ANNOTATIONS.add("javax.persistence.UniqueConstraint");
        ORM_ANNOTATIONS.add("javax.persistence.Version");
    }
}

