/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class JSFPaletteUtilities {
    private static final String ENCODING_PROPERTY_NAME = "encoding";

    public static FileObject getFileObject(JTextComponent target) {
        BaseDocument doc = (BaseDocument)target.getDocument();
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fobj = dobj != null ? NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile() : null;
        return fobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String s, final JTextComponent target) throws BadLocationException {
        Document doc = target.getDocument();
        if (doc != null && doc instanceof BaseDocument) {
            final String str = s == null ? "" : s;
            final BaseDocument baseDoc = (BaseDocument)doc;
            final Reformat formatter = Reformat.get((Document)baseDoc);
            Runnable edit = new Runnable(){

                @Override
                public void run() {
                    try {
                        int start = JSFPaletteUtilities.insert(str, target, (Document)baseDoc);
                        if (start >= 0) {
                            int end = start + str.length();
                            formatter.reformat(start, end);
                        }
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            };
            formatter.lock();
            try {
                baseDoc.runAtomic(edit);
            }
            finally {
                formatter.unlock();
            }
        }
    }

    private static int insert(String s, JTextComponent target, Document doc) throws BadLocationException {
        int start = -1;
        try {
            Caret caret = target.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            doc.remove(p0, p1 - p0);
            start = caret.getDot();
            doc.insertString(start, s, null);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandJSFTemplate(FileObject template, Map<String, Object> values, FileObject target) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(target.getOutputStream());
        try {
            JSFPaletteUtilities.expandJSFTemplate(template, values, FileEncodingQuery.getEncoding((FileObject)template), w);
        }
        finally {
            ((Writer)w).close();
        }
        DataObject dob = DataObject.find((FileObject)target);
        if (dob != null) {
            JSFPaletteUtilities.reformat(dob);
        }
    }

    public static void expandJSFTemplate(FileObject template, Map<String, Object> values, Charset targetEncoding, Writer w) throws IOException {
        Charset sourceEnc = FileEncodingQuery.getEncoding((FileObject)template);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine eng = manager.getEngineByName("freemarker");
        Bindings bind = eng.getContext().getBindings(100);
        bind.putAll((Map<? extends String, ? extends Object>)values);
        bind.put(ENCODING_PROPERTY_NAME, (Object)targetEncoding.name());
        Reader is = null;
        try {
            eng.getContext().setWriter(w);
            is = new InputStreamReader(template.getInputStream(), sourceEnc);
            eng.eval(is);
        }
        catch (ScriptException ex) {
            throw new IOException(ex);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformat(DataObject dob) {
        try {
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return;
            }
            final StyledDocument doc = ec.openDocument();
            final Reformat reformat = Reformat.get((Document)doc);
            reformat.lock();
            try {
                NbDocument.runAtomicAsUser((StyledDocument)doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            reformat.reformat(0, doc.getLength());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                reformat.unlock();
                ec.saveDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

