/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.api;

import java.net.URL;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class NBBugzillaUtils {
    private static final String NB_BUGZILLA_PASSWORD = "nbbugzilla.password";
    private static final String NB_BUGZILLA_USERNAME = "nbbugzilla.username";
    private static Pattern netbeansUrlPattern = Pattern.compile("(https|http)://(([a-z]|\\d)+\\.)*([a-z]|\\d)*netbeans([a-z]|\\d)*(([a-z]|\\d)*\\.)+org(.*)");
    private static Preferences preferences;

    public static void openIssue(String issueID) {
        BugzillaRepository nbRepo = NBRepositorySupport.findNbRepository();
        assert (nbRepo != null);
        if (nbRepo == null) {
            Bugzilla.LOG.warning("No bugzilla repository available for netbeans.org");
            return;
        }
        Issue.open((Repository)nbRepo, (String)issueID);
    }

    public static String getNBUsername() {
        String user = NBBugzillaUtils.getPreferences().get(NB_BUGZILLA_USERNAME, "");
        return user.equals("") ? null : user;
    }

    public static char[] getNBPassword() {
        return Keyring.read((String)NB_BUGZILLA_PASSWORD);
    }

    public static void saveNBUsername(String username) {
        NBBugzillaUtils.getPreferences().put(NB_BUGZILLA_USERNAME, username);
    }

    public static void saveNBPassword(char[] password) {
        if (password == null) {
            Keyring.delete((String)NB_BUGZILLA_PASSWORD);
        } else {
            Keyring.save((String)NB_BUGZILLA_PASSWORD, (char[])password, (String)NbBundle.getMessage(NBBugzillaUtils.class, (String)"NBRepositorySupport.password_keyring_description"));
        }
    }

    public static boolean isNbRepository(URL url) {
        assert (url != null);
        boolean ret = netbeansUrlPattern.matcher(url.toString()).matches();
        if (ret) {
            return true;
        }
        String nbUrl = System.getProperty("netbeans.bugzilla.url");
        if (nbUrl == null || nbUrl.equals("")) {
            return false;
        }
        return url.toString().startsWith(nbUrl);
    }

    private static Preferences getPreferences() {
        if (preferences == null) {
            preferences = NbPreferences.forModule(NBBugzillaUtils.class);
        }
        return preferences;
    }
}

