/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.openide.filesystems.FileObject;

class PackagingFilter {
    private WebBeansModelImplementation myModel;

    PackagingFilter(WebBeansModelImplementation model) {
        this.myModel = model;
    }

    void filter(Collection<? extends Element> collection) {
        Iterator<? extends Element> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            if (!this.remove(element)) continue;
            iterator.remove();
        }
    }

    void filterTypes(Collection<? extends DeclaredType> collection) {
        Iterator<? extends DeclaredType> iterator = collection.iterator();
        while (iterator.hasNext()) {
            DeclaredType type = iterator.next();
            Element element = this.getModel().getHelper().getCompilationController().getTypes().asElement(type);
            if (element == null || !this.remove(element)) continue;
            iterator.remove();
        }
    }

    private boolean remove(Element element) {
        TypeElement typeElement = element instanceof TypeElement ? (TypeElement)element : this.getModel().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
        if (typeElement == null) {
            return false;
        }
        PackageElement pack = this.getModel().getHelper().getCompilationController().getElements().getPackageOf(typeElement);
        if (pack == null) {
            return false;
        }
        String packageName = pack.getQualifiedName().toString();
        String fqn = typeElement.getQualifiedName().toString();
        String className = fqn.substring(packageName.length());
        if (className.length() <= 0 || className.charAt(0) != '.') {
            return false;
        }
        className = className.substring(1);
        int dotIndex = className.indexOf(46);
        if (dotIndex != -1) {
            className = className.substring(0, dotIndex);
        }
        String path = packageName.replace('.', '/') + '/' + className + ".class";
        ClassPath classPath = this.getModel().getModelUnit().getCompilePath();
        FileObject resource = classPath.findResource(path);
        if (resource != null) {
            FileObject root = classPath.findOwnerRoot(resource);
            if (root == null) {
                return false;
            }
            if (root.getFileObject("META-INF/beans.xml") == null) {
                return true;
            }
        }
        return false;
    }

    private WebBeansModelImplementation getModel() {
        return this.myModel;
    }
}

