/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.PullUpTransformer;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PullUpRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PullUpRefactoring refactoring;
    private TreePathHandle treePathHandle;

    PullUpRefactoringPlugin(PullUpRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = refactoring.getSourceType();
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController cc) throws IOException {
        this.fireProgressListenerStart(1, 4);
        try {
            Problem problem;
            cc.toPhase(JavaSource.Phase.RESOLVED);
            Problem problem2 = PullUpRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)cc);
            if (problem2 != null) {
                Problem problem3 = problem2;
                return problem3;
            }
            this.fireProgressListenerStep();
            Element elm = this.treePathHandle.resolveElement((CompilationInfo)cc);
            problem2 = JavaPluginUtils.isSourceElement(elm, (CompilationInfo)cc);
            if (problem2 != null) {
                Problem problem4 = problem2;
                return problem4;
            }
            if (!(elm instanceof TypeElement)) {
                Problem problem5 = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_InvalidSource", (Object)this.treePathHandle, (Object)elm));
                return problem5;
            }
            TypeElement e = (TypeElement)elm;
            if (RetoucheUtils.getSuperTypes(e, (CompilationInfo)cc, true).isEmpty()) {
                Problem problem6 = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoSuperTypes"));
                return problem6;
            }
            this.fireProgressListenerStep();
            for (Element element : e.getEnclosedElements()) {
                if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                Problem problem7 = null;
                return problem7;
            }
            if (!e.getInterfaces().isEmpty()) {
                problem = null;
                return problem;
            }
            problem2 = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembers"));
            this.fireProgressListenerStep();
            problem = problem2;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        MemberInfo<ElementHandle<? extends Element>>[] info = this.refactoring.getMembers();
        if (info.length == 0) {
            return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembersSelected"));
        }
        if (info.length > 1) {
            for (int i = 0; i < info.length - 1; ++i) {
                for (int j = i + 1; j < info.length; ++j) {
                    if (!info[i].equals(info[j])) continue;
                    return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_CannotPullupDuplicateMembers"));
                }
            }
        }
        if (this.refactoring.getTargetType() == null) {
            return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoTargetType"));
        }
        Problem p = null;
        if (this.refactoring.getTargetType().getKind().isInterface()) {
            for (MemberInfo<ElementHandle<? extends Element>> i : info) {
                if (i.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                p = PullUpRefactoringPlugin.createProblem(p, false, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullupNonPublicToInterface", (Object)i.getName()));
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem checkParameters(CompilationController cc) throws IOException {
        this.fireProgressListenerStart(1, 4);
        try {
            cc.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)cc);
            Collection<TypeElement> supers = RetoucheUtils.getSuperTypes(sourceType, (CompilationInfo)cc);
            TypeElement targetType = (TypeElement)this.refactoring.getTargetType().resolve((CompilationInfo)cc);
            MemberInfo<ElementHandle<? extends Element>>[] members = this.refactoring.getMembers();
            this.fireProgressListenerStart(2, members.length + 1);
            if (!supers.contains(targetType)) {
                Problem problem = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalTargetType"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problems = null;
            for (int i = 0; i < members.length; ++i) {
                Element member = members[i].getElementHandle().resolve((CompilationInfo)cc);
                if (members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) continue;
                if (RetoucheUtils.elementExistsIn(targetType, member, (CompilationInfo)cc)) {
                    Problem problem = PullUpRefactoringPlugin.createProblem(problems, true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_MemberAlreadyExists", (Object)member.getSimpleName()));
                    return problem;
                }
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> a = new HashSet<FileObject>();
        a.addAll(RetoucheUtils.getSuperTypesFiles(this.refactoring.getSourceType()));
        a.add(RetoucheUtils.getFileObject(this.treePathHandle));
        this.fireProgressListenerStart(1, a.size());
        JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, new PullUpTransformer(this.refactoring), this.treePathHandle);
        Problem problem = this.createAndAddElements(a, task, refactoringElements, this.refactoring, cpInfo);
        this.fireProgressListenerStop();
        return problem;
    }

    protected FileObject getFileObject() {
        return this.treePathHandle.getFileObject();
    }
}

