/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class InnerToOuterTransformer
extends RefactoringVisitor {
    private Element inner;
    private Element outer;
    private InnerToOuterRefactoring refactoring;
    private boolean isInInnerClass = false;
    private Set<Element> referencedPrivateElement;
    private Problem problem;

    private Element getCurrentElement() {
        return this.workingCopy.getTrees().getElement(this.getCurrentPath());
    }

    public InnerToOuterTransformer(InnerToOuterRefactoring re) {
        this.refactoring = re;
    }

    @Override
    public void setWorkingCopy(WorkingCopy wc) throws ToPhaseException {
        super.setWorkingCopy(wc);
        this.inner = this.refactoring.getSourceType().resolveElement((CompilationInfo)wc);
        this.outer = wc.getElementUtilities().enclosingTypeElement(this.inner);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return null;
        }
        Element current = this.getCurrentElement();
        if (((Object)this.inner).equals(current)) {
            Tree newTree = this.make.setLabel((Tree)node, (CharSequence)this.refactoring.getClassName());
            this.rewrite(node, newTree);
        } else if (this.isThisReferenceToOuter() && this.isThisInInner()) {
            if (current.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.referencedPrivateElement.add(current);
            }
            if (!this.workingCopy.getTypes().isSubtype(this.inner.asType(), this.workingCopy.getElementUtilities().enclosingTypeElement(current).asType())) {
                IdentifierTree m = this.refactoring.getReferenceName() == null || current.getModifiers().contains((Object)Modifier.STATIC) ? this.make.Identifier((CharSequence)(this.outer.getSimpleName().toString() + "." + node.getName().toString())) : this.make.Identifier((CharSequence)(this.refactoring.getReferenceName() + "." + node.getName().toString()));
                this.rewrite(node, m);
            }
        } else if (this.isInInnerClass) {
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            Tree newTree = genUtils.importFQNs((Tree)node);
            this.rewrite(node, newTree);
        }
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitNewClass(NewClassTree arg0, Element arg1) {
        Element currentElement = this.getCurrentElement();
        if (this.refactoring.getReferenceName() != null && currentElement != null && this.workingCopy.getTypes().isSubtype(this.workingCopy.getElementUtilities().enclosingTypeElement(currentElement).asType(), this.inner.asType())) {
            TypeElement thisOuter;
            String thisString = this.getCurrentClass() == this.inner ? this.refactoring.getReferenceName() : (this.workingCopy.getTypes().isSubtype(this.getCurrentClass().asType(), this.outer.asType()) ? "this" : ((thisOuter = this.getOuter(this.getCurrentClass())) != null ? this.getOuter(this.getCurrentClass()).getQualifiedName().toString() + ".this" : "this"));
            if (thisString != null && currentElement instanceof ExecutableElement) {
                ExecutableElement constr = (ExecutableElement)currentElement;
                if (constr.isVarArgs()) {
                    int index = constr.getParameters().size() - 1;
                    this.rewrite(arg0, this.make.insertNewClassArgument(arg0, index, (ExpressionTree)this.make.Identifier((CharSequence)thisString)));
                } else {
                    this.rewrite(arg0, this.make.addNewClassArgument(arg0, (ExpressionTree)this.make.Identifier((CharSequence)thisString)));
                }
            }
        } else if (this.refactoring.getReferenceName() != null && currentElement != null && this.outer != null && ((TypeElement)this.outer).getNestingKind() == NestingKind.TOP_LEVEL) {
            Element enclElm = currentElement.getEnclosingElement();
            ExpressionTree primary = arg0.getEnclosingExpression();
            Element primaryElm = null;
            if (primary != null) {
                primaryElm = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), primary));
                Element element = primaryElm = primary != null ? this.workingCopy.getTypes().asElement(primaryElm.asType()) : null;
            }
            if (enclElm != null && enclElm.getKind() == ElementKind.CLASS && enclElm != this.inner && this.isInInnerClass && !enclElm.getModifiers().contains((Object)Modifier.STATIC) && ((TypeElement)enclElm).getNestingKind() == NestingKind.MEMBER && (primaryElm == null && primary == null || primaryElm == this.outer)) {
                NewClassTree nju = this.make.NewClass((ExpressionTree)this.make.Identifier((CharSequence)this.refactoring.getReferenceName()), arg0.getTypeArguments(), (ExpressionTree)this.make.Identifier((CharSequence)enclElm.getSimpleName()), arg0.getArguments(), arg0.getClassBody());
                this.rewrite(arg0, nju);
            }
        }
        return (Tree)super.visitNewClass(arg0, arg1);
    }

    private TypeElement getOuter(TypeElement element) {
        while (element != null && !this.workingCopy.getTypes().isSubtype(element.asType(), this.outer.asType())) {
            element = this.workingCopy.getElementUtilities().enclosingTypeElement((Element)element);
        }
        return element;
    }

    @Override
    public Tree visitMethod(MethodTree constructor, Element element) {
        if (constructor.getReturnType() == null && this.refactoring.getReferenceName() != null && !((Object)this.inner).equals(this.getCurrentClass()) && this.workingCopy.getTypes().isSubtype(this.getCurrentElement().getEnclosingElement().asType(), this.inner.asType())) {
            MemberSelectTree arg = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.getCurrentClass().getEnclosingElement().getSimpleName()), (CharSequence)"this");
            MethodInvocationTree superCall = (MethodInvocationTree)((ExpressionStatementTree)constructor.getBody().getStatements().get(0)).getExpression();
            int index = this.hasVarArgs(constructor) ? constructor.getParameters().size() - 1 : 0;
            MethodInvocationTree newSuperCall = this.make.insertMethodInvocationArgument(superCall, index, (ExpressionTree)arg);
            this.rewrite(superCall, newSuperCall);
        }
        return (Tree)super.visitMethod(constructor, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree visitClass(ClassTree classTree, Element element) {
        Element currentElement = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        if (currentElement != null && currentElement == this.outer) {
            ClassTree innerClass;
            Element outerouter = this.outer.getEnclosingElement();
            Tree superVisit = (Tree)super.visitClass(classTree, element);
            TreePath treePath = this.workingCopy.getTrees().getPath(this.inner);
            if (treePath == null) {
                return superVisit;
            }
            ClassTree newInnerClass = innerClass = (ClassTree)treePath.getLeaf();
            newInnerClass = (ClassTree)genUtils.importComments((Tree)newInnerClass, this.workingCopy.getCompilationUnit());
            newInnerClass = (ClassTree)this.make.setLabel((Tree)newInnerClass, (CharSequence)this.refactoring.getClassName());
            newInnerClass = this.refactorInnerClass(newInnerClass);
            RetoucheUtils.copyJavadoc(this.inner, newInnerClass, this.workingCopy);
            if (outerouter.getKind() == ElementKind.PACKAGE) {
                FileObject sourceRoot = ClassPath.getClassPath((FileObject)this.workingCopy.getFileObject(), (String)"classpath/source").findOwnerRoot(this.workingCopy.getFileObject());
                ClassTree outerTree = (ClassTree)this.workingCopy.getTrees().getTree(this.outer);
                ClassTree newOuter = this.make.removeClassMember(outerTree, (Tree)innerClass);
                this.workingCopy.rewrite((Tree)outerTree, (Tree)newOuter);
                JavaRefactoringUtils.cacheTreePathInfo(this.workingCopy.getTrees().getPath(this.outer), (CompilationInfo)this.workingCopy);
                CompilationUnitTree compilationUnit = treePath.getCompilationUnit();
                String relativePath = RetoucheUtils.getPackageName(compilationUnit).replace('.', '/') + '/' + this.refactoring.getClassName() + ".java";
                CompilationUnitTree newCompilation = this.make.CompilationUnit(sourceRoot, relativePath, null, Collections.singletonList(newInnerClass));
                this.workingCopy.rewrite(null, (Tree)newCompilation);
                return newOuter;
            }
            ClassTree outerTree = (ClassTree)this.workingCopy.getTrees().getTree(this.outer);
            ClassTree outerouterTree = (ClassTree)this.workingCopy.getTrees().getTree(outerouter);
            ClassTree newOuter = this.make.removeClassMember(outerTree, (Tree)innerClass);
            ClassTree newOuterOuter = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(outerouterTree, (Tree)newInnerClass);
            this.workingCopy.rewrite((Tree)outerTree, (Tree)newOuter);
            JavaRefactoringUtils.cacheTreePathInfo(this.workingCopy.getTrees().getPath(this.outer), (CompilationInfo)this.workingCopy);
            this.workingCopy.rewrite((Tree)outerouterTree, (Tree)newOuterOuter);
            return newOuterOuter;
        }
        if (this.refactoring.getReferenceName() != null && currentElement != null && this.workingCopy.getTypes().isSubtype(currentElement.asType(), this.inner.asType()) && currentElement != this.inner) {
            VariableTree variable = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)this.refactoring.getReferenceName(), this.make.Type(this.outer.asType()), null);
            for (Tree tree : classTree.getMembers()) {
                MethodTree m;
                if (tree.getKind() != Tree.Kind.METHOD || (m = (MethodTree)tree).getReturnType() != null) continue;
                MethodInvocationTree superCall = (MethodInvocationTree)((ExpressionStatementTree)m.getBody().getStatements().get(0)).getExpression();
                ArrayList<? extends ExpressionTree> newArgs = new ArrayList<ExpressionTree>(superCall.getArguments());
                MethodTree newConstructor = null;
                IdentifierTree exprTree = this.make.Identifier((CharSequence)variable.getName().toString());
                if (this.hasVarArgs(m)) {
                    int index = m.getParameters().size() - 1;
                    newArgs.add(index, exprTree);
                    newConstructor = this.make.insertMethodParameter(m, index, variable);
                } else {
                    newArgs.add(exprTree);
                    newConstructor = this.make.addMethodParameter(m, variable);
                }
                MethodInvocationTree method = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.Identifier((CharSequence)"super"), newArgs);
                BlockTree block = this.make.insertBlockStatement(m.getBody(), 0, (StatementTree)this.make.ExpressionStatement((ExpressionTree)method));
                block = this.make.removeBlockStatement(block, 1);
                newConstructor = this.make.Constructor(this.make.Modifiers(newConstructor.getModifiers().getFlags(), newConstructor.getModifiers().getAnnotations()), newConstructor.getTypeParameters(), newConstructor.getParameters(), newConstructor.getThrows(), block);
                this.rewrite(m, newConstructor);
            }
        }
        if (currentElement == this.inner) {
            try {
                this.isInInnerClass = true;
                Tree tree = (Tree)super.visitClass(classTree, element);
                return tree;
            }
            finally {
                this.isInInnerClass = false;
            }
        }
        return (Tree)super.visitClass(classTree, element);
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        this.referencedPrivateElement = new HashSet<Element>();
        Tree result = (Tree)super.visitCompilationUnit(node, p);
        for (Element privEl : this.referencedPrivateElement) {
            this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"WRN_InnerToOuterRefToPrivate", (Object)privEl));
        }
        return result;
    }

    public Problem getProblem() {
        return this.problem;
    }

    private boolean containsImport(String imp) {
        for (ImportTree importTree : this.workingCopy.getCompilationUnit().getImports()) {
            if (!importTree.getQualifiedIdentifier().toString().equals(imp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memberSelect, Element element) {
        Element current = this.getCurrentElement();
        if (((Object)this.inner).equals(current)) {
            ExpressionTree ex = memberSelect.getExpression();
            if (ex.getKind() == Tree.Kind.IDENTIFIER) {
                IdentifierTree newTree = this.make.Identifier((CharSequence)this.refactoring.getClassName());
                this.rewrite(memberSelect, newTree);
                TreePath tp = this.workingCopy.getTrees().getPath(this.inner);
                String innerPackageName = RetoucheUtils.getPackageName(tp.getCompilationUnit());
                if (!innerPackageName.equals(RetoucheUtils.getPackageName(this.workingCopy.getCompilationUnit())) && !this.containsImport(innerPackageName + ".*")) {
                    String import1 = innerPackageName + "." + this.refactoring.getClassName();
                    try {
                        CompilationUnitTree cut = RetoucheUtils.addImports(this.workingCopy.getCompilationUnit(), Collections.singletonList(import1), this.make);
                        this.workingCopy.rewrite((Tree)this.workingCopy.getCompilationUnit(), (Tree)cut);
                    }
                    catch (IOException ex1) {
                        Exceptions.printStackTrace((Throwable)ex1);
                    }
                }
            } else if (ex.getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree m = this.make.MemberSelect(((MemberSelectTree)ex).getExpression(), (CharSequence)this.refactoring.getClassName());
                this.rewrite(memberSelect, m);
            }
        } else if (this.isThisReferenceToOuter()) {
            if (current.getModifiers().contains((Object)Modifier.PRIVATE) && this.isThisInInner()) {
                this.referencedPrivateElement.add(this.getCurrentElement());
            }
            if (!"class".equals(memberSelect.getIdentifier().toString()) && !current.getModifiers().contains((Object)Modifier.STATIC)) {
                if (this.refactoring.getReferenceName() != null) {
                    IdentifierTree m = "this".equals(memberSelect.getIdentifier().toString()) ? this.make.Identifier((CharSequence)this.refactoring.getReferenceName()) : this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.refactoring.getReferenceName()), (CharSequence)memberSelect.getIdentifier());
                    this.rewrite(memberSelect, m);
                } else if (this.inner.getKind() != ElementKind.INTERFACE && !this.inner.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.problem = MoveTransformer.createProblem(this.problem, true, NbBundle.getMessage(InnerToOuterTransformer.class, (String)"ERR_InnerToOuter_UseDeclareField", (Object)memberSelect));
                }
            }
        } else if (this.isThisReferenceToInner()) {
            VariableTree variable;
            Tree tree = this.workingCopy.getTrees().getTree(current);
            if (tree != null && tree.getKind() == Tree.Kind.METHOD) {
                MethodTree method = (MethodTree)tree;
                if (method.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                    this.workingCopy.rewrite((Tree)method.getModifiers(), (Tree)this.make.removeModifiersModifier(method.getModifiers(), Modifier.PRIVATE));
                }
            } else if (tree != null && tree.getKind() == Tree.Kind.VARIABLE && (variable = (VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                this.workingCopy.rewrite((Tree)variable.getModifiers(), (Tree)this.make.removeModifiersModifier(variable.getModifiers(), Modifier.PRIVATE));
            }
        }
        return (Tree)super.visitMemberSelect(memberSelect, element);
    }

    private boolean isThisReferenceToInner() {
        Element cur = this.getCurrentElement();
        if (cur == null || cur.getKind() == ElementKind.PACKAGE) {
            return false;
        }
        Tree innerTree = this.workingCopy.getTrees().getTree(this.inner);
        for (TreePath path = this.getCurrentPath(); path != null; path = path.getParentPath()) {
            Tree t = path.getLeaf();
            if (t != innerTree) continue;
            return false;
        }
        TypeElement encl = this.workingCopy.getElementUtilities().enclosingTypeElement(cur);
        return encl != null && this.workingCopy.getTypes().isSubtype(encl.asType(), this.inner.asType());
    }

    private boolean isThisReferenceToOuter() {
        Element cur = this.getCurrentElement();
        if (cur == null || cur.getKind() == ElementKind.PACKAGE) {
            return false;
        }
        TypeElement encl = this.workingCopy.getElementUtilities().enclosingTypeElement(cur);
        if (((Object)this.outer).equals(encl)) {
            TypeElement currentClass = this.getCurrentClass();
            if (currentClass == null) {
                return false;
            }
            if (this.workingCopy.getTypes().isSubtype(currentClass.asType(), this.inner.asType())) {
                return true;
            }
            return ((Object)this.outer).equals(cur.getEnclosingElement());
        }
        return false;
    }

    private TypeElement getCurrentClass() {
        for (TreePath treePath = this.getCurrentPath(); treePath != null; treePath = treePath.getParentPath()) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
                return (TypeElement)this.workingCopy.getTrees().getElement(treePath);
            }
            if (treePath.getLeaf().getKind() != Tree.Kind.IMPORT) continue;
            return (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
        }
        return null;
    }

    private boolean isIn(Element el) {
        if (el == null) {
            return false;
        }
        Element current = el;
        while (current.getKind() != ElementKind.PACKAGE) {
            if (((Object)current).equals(this.inner)) {
                return true;
            }
            current = current.getEnclosingElement();
        }
        return false;
    }

    private boolean hasVarArgs(MethodTree mt) {
        List<? extends VariableTree> list = mt.getParameters();
        if (list.isEmpty()) {
            return false;
        }
        VariableTree vt = list.get(list.size() - 1);
        return vt.toString().indexOf("...") != -1;
    }

    private ClassTree refactorInnerClass(ClassTree newInnerClass) {
        MethodTree m;
        String referenceName = this.refactoring.getReferenceName();
        VariableTree variable = null;
        if (referenceName != null) {
            variable = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)this.refactoring.getReferenceName(), this.make.Type(this.outer.asType()), null);
            newInnerClass = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(newInnerClass, (Tree)variable);
        }
        ModifiersTree modifiersTree = newInnerClass.getModifiers();
        ModifiersTree newModifiersTree = this.make.removeModifiersModifier(modifiersTree, Modifier.PRIVATE);
        newModifiersTree = this.make.removeModifiersModifier(newModifiersTree, Modifier.STATIC);
        newModifiersTree = this.make.removeModifiersModifier(newModifiersTree, Modifier.PROTECTED);
        if (!this.outer.getModifiers().contains((Object)Modifier.PUBLIC)) {
            newModifiersTree = this.make.removeModifiersModifier(newModifiersTree, Modifier.PUBLIC);
        }
        this.rewrite(modifiersTree, newModifiersTree);
        if (referenceName != null) {
            for (Tree tree : newInnerClass.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD || (m = (MethodTree)tree).getReturnType() != null) continue;
                MethodTree newConstructor = this.hasVarArgs(m) ? this.make.insertMethodParameter(m, m.getParameters().size() - 1, variable) : this.make.addMethodParameter(m, variable);
                AssignmentTree assign = this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)("this." + referenceName)), (ExpressionTree)this.make.Identifier((CharSequence)referenceName));
                BlockTree block = this.make.insertBlockStatement(newConstructor.getBody(), 1, (StatementTree)this.make.ExpressionStatement((ExpressionTree)assign));
                HashSet<Modifier> modifiers = new HashSet<Modifier>(newConstructor.getModifiers().getFlags());
                modifiers.remove((Object)Modifier.PRIVATE);
                newConstructor = this.make.Constructor(this.make.Modifiers(modifiers, newConstructor.getModifiers().getAnnotations()), newConstructor.getTypeParameters(), newConstructor.getParameters(), newConstructor.getThrows(), block);
                newInnerClass = this.make.removeClassMember(newInnerClass, (Tree)m);
                newInnerClass = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(newInnerClass, (Tree)newConstructor);
            }
        }
        if (this.inner.getKind() == ElementKind.ENUM) {
            for (Tree tree : newInnerClass.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD || (m = (MethodTree)tree).getReturnType() != null) continue;
                this.rewrite(m.getBody(), this.make.removeBlockStatement(m.getBody(), 0));
            }
        }
        return newInnerClass;
    }

    private boolean isThisInInner() {
        Tree innerTree = this.workingCopy.getTrees().getTree(this.inner);
        for (TreePath t = this.getCurrentPath(); t != null; t = t.getParentPath()) {
            if (!t.getLeaf().equals(innerTree)) continue;
            return true;
        }
        return false;
    }
}

