/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.util.Exceptions;

final class CopyHandler
implements OperationListener {
    private static final CopyHandler INSTANCE = new CopyHandler();

    public static CopyHandler getInstance() {
        return INSTANCE;
    }

    public void register() {
        DataLoaderPool.getDefault().addOperationListener((OperationListener)this);
    }

    private static void renameFO(JavaSource javaSource, final String packageName, final String newName, final String originalName) throws IOException {
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                CompilationUnitTree cutCopy = make.CompilationUnit(compilationUnitTree.getPackageAnnotations(), (ExpressionTree)("".equals(packageName) ? null : make.Identifier((CharSequence)packageName)), compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
                workingCopy.rewrite((Tree)compilationUnitTree, (Tree)cutCopy);
                if (originalName != null && !originalName.equals(newName)) {
                    for (Tree tree : compilationUnitTree.getTypeDecls()) {
                        ClassTree clazz;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !originalName.contentEquals((clazz = (ClassTree)tree).getSimpleName())) continue;
                        Tree copy = make.setLabel(tree, (CharSequence)newName);
                        workingCopy.rewrite(tree, copy);
                    }
                }
            }
        };
        javaSource.runModificationTask((Task)task).commit();
    }

    private CopyHandler() {
    }

    public void operationCopy(OperationEvent.Copy ev) {
        FileObject copyFO = ev.getObject().getPrimaryFile();
        FileObject origFO = ev.getOriginalDataObject().getPrimaryFile();
        JavaSource js = JavaSource.forFileObject((FileObject)copyFO);
        if (js == null) {
            return;
        }
        if (!"text/x-java".equals(FileUtil.getMIMEType((FileObject)copyFO)) && !"java".equals(copyFO.getExt())) {
            return;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)copyFO, (String)"classpath/source");
        if (cp == null) {
            return;
        }
        String pkgName = cp.getResourceName(copyFO.getParent(), '.', false);
        try {
            CopyHandler.renameFO(js, pkgName, copyFO.getName(), origFO.getName());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void operationPostCreate(OperationEvent ev) {
    }

    public void operationMove(OperationEvent.Move ev) {
    }

    public void operationDelete(OperationEvent ev) {
    }

    public void operationRename(OperationEvent.Rename ev) {
    }

    public void operationCreateShadow(OperationEvent.Copy ev) {
    }

    public void operationCreateFromTemplate(OperationEvent.Copy ev) {
    }
}

