/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class Utils {
    public static String toClasspathString(File[] classpathEntries) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpath.append(classpathEntries[i].getAbsolutePath());
            if (i + 1 >= classpathEntries.length) continue;
            classpath.append(':');
        }
        return classpath.toString();
    }

    public static void notifyError(Exception exception) {
        NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
    }

    public static boolean areInSameJ2EEApp(Project project1, Project project2) {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            List<J2eeModuleProvider> childModules;
            J2eeApplicationProvider j2eeApp;
            J2eeModuleProvider[] j2eeModules;
            Project project = openProjects[i];
            Object j2eeAppProvider = project.getLookup().lookup(J2eeApplicationProvider.class);
            if (j2eeAppProvider == null || (j2eeModules = (j2eeApp = (J2eeApplicationProvider)j2eeAppProvider).getChildModuleProviders()) == null || j2eeModules.length <= 0) continue;
            J2eeModuleProvider affectedPrjProvider1 = (J2eeModuleProvider)project1.getLookup().lookup(J2eeModuleProvider.class);
            J2eeModuleProvider affectedPrjProvider2 = (J2eeModuleProvider)project2.getLookup().lookup(J2eeModuleProvider.class);
            if (affectedPrjProvider1 == null || affectedPrjProvider2 == null || !(childModules = Arrays.asList(j2eeModules)).contains(affectedPrjProvider1) || !childModules.contains(affectedPrjProvider2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartOfJ2eeApp(J2eeModuleProvider j2eeModuleProvider) {
        for (Project openProject : OpenProjects.getDefault().getOpenProjects()) {
            J2eeApplicationProvider j2eeAppProvider = (J2eeApplicationProvider)openProject.getLookup().lookup(J2eeApplicationProvider.class);
            if (j2eeAppProvider == null || !Arrays.asList(j2eeAppProvider.getChildModuleProviders()).contains(j2eeModuleProvider)) continue;
            return true;
        }
        return false;
    }

    public static Project getNestingJ2eeApp(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        for (Project openProject : OpenProjects.getDefault().getOpenProjects()) {
            J2eeApplicationProvider j2eeAppProvider = (J2eeApplicationProvider)openProject.getLookup().lookup(J2eeApplicationProvider.class);
            if (j2eeAppProvider == null || !Arrays.asList(j2eeAppProvider.getChildModuleProviders()).contains(j2eeModuleProvider)) continue;
            return openProject;
        }
        return null;
    }

    public static boolean canExposeInLocal(FileObject ejbClassFO, final ElementHandle<ExecutableElement> methodHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)ejbClassFO);
        final String[] ejbClassName = new String[1];
        final MethodModel[] methodModel = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                boolean signatureOk;
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = (ExecutableElement)methodHandle.resolve((CompilationInfo)workingCopy);
                Set<Modifier> modifiers = executableElement.getModifiers();
                boolean bl = signatureOk = modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC);
                if (signatureOk) {
                    Element enclosingElement = executableElement.getEnclosingElement();
                    ejbClassName[0] = ((TypeElement)enclosingElement).getQualifiedName().toString();
                    methodModel[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)executableElement);
                }
            }
        });
        if (methodModel[0] != null) {
            EjbMethodController ejbMethodController = EjbMethodController.createFromClass(ejbClassFO, ejbClassName[0]);
            return ejbMethodController != null && ejbMethodController.hasLocal() && !ejbMethodController.hasMethodInInterface(methodModel[0], ejbMethodController.getMethodTypeFromImpl(methodModel[0]), true);
        }
        return false;
    }

    public static void exposeInLocal(FileObject ejbClassFO, final ElementHandle<ExecutableElement> methodHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)ejbClassFO);
        final String[] ejbClassName = new String[1];
        final MethodModel[] methodModel = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement method = (ExecutableElement)methodHandle.resolve((CompilationInfo)workingCopy);
                Element enclosingElement = method.getEnclosingElement();
                ejbClassName[0] = ((TypeElement)enclosingElement).getQualifiedName().toString();
                methodModel[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)method);
            }
        });
        if (methodModel[0] != null) {
            EjbMethodController ejbMethodController = EjbMethodController.createFromClass(ejbClassFO, ejbClassName[0]);
            ejbMethodController.createAndAddInterface(methodModel[0], true);
        }
    }

    public static boolean canExposeInRemote(FileObject ejbClassFO, final ElementHandle<ExecutableElement> methodHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)ejbClassFO);
        final String[] ejbClassName = new String[1];
        final MethodModel[] methodModel = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                boolean signatureOk;
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = (ExecutableElement)methodHandle.resolve((CompilationInfo)workingCopy);
                Set<Modifier> modifiers = executableElement.getModifiers();
                boolean bl = signatureOk = modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC);
                if (signatureOk) {
                    Element enclosingElement = executableElement.getEnclosingElement();
                    ejbClassName[0] = ((TypeElement)enclosingElement).getQualifiedName().toString();
                    methodModel[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)executableElement);
                }
            }
        });
        if (methodModel[0] != null) {
            EjbMethodController ejbMethodController = EjbMethodController.createFromClass(ejbClassFO, ejbClassName[0]);
            return ejbMethodController != null && ejbMethodController.hasRemote() && !ejbMethodController.hasMethodInInterface(methodModel[0], ejbMethodController.getMethodTypeFromImpl(methodModel[0]), true);
        }
        return false;
    }

    public static void exposeInRemote(FileObject ejbClassFO, final ElementHandle<ExecutableElement> methodHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)ejbClassFO);
        final String[] ejbClassName = new String[1];
        final MethodModel[] methodModel = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement method = (ExecutableElement)methodHandle.resolve((CompilationInfo)workingCopy);
                Element enclosingElement = method.getEnclosingElement();
                ejbClassName[0] = ((TypeElement)enclosingElement).getQualifiedName().toString();
                methodModel[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)method);
            }
        });
        if (methodModel[0] != null) {
            EjbMethodController ejbMethodController = EjbMethodController.createFromClass(ejbClassFO, ejbClassName[0]);
            ejbMethodController.createAndAddInterface(methodModel[0], false);
        }
    }

    public static Project[] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        boolean isCallerEE6WebProject = Utils.isEE6WebProject(enterpriseProject);
        ArrayList<Project> filteredResults = new ArrayList<Project>(allProjects.length);
        for (int i = 0; i < allProjects.length; ++i) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null) {
                Profile profile;
                J2eeModule.Type type = j2eeModuleProvider.getJ2eeModule().getType();
                EjbJar[] ejbJars = EjbJar.getEjbJars((Project)allProjects[i]);
                Profile profile2 = profile = ejbJars.length > 0 ? ejbJars[0].getJ2eeProfile() : null;
                if (J2eeModule.Type.EJB.equals(type) || J2eeModule.Type.WAR.equals(type) && (Profile.JAVA_EE_6_WEB.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile))) {
                    isEJBModule = true;
                }
            }
            if ((!isEJBModule || isCallerFreeform) && (!enterpriseProject.equals(allProjects[i]) || !isCallerFreeform && !isCallerEE6WebProject)) continue;
            filteredResults.add(allProjects[i]);
        }
        return filteredResults.toArray(new Project[filteredResults.size()]);
    }

    public static boolean isEE6WebProject(Project enterpriseProject) {
        return J2eeProjectCapabilities.forProject((Project)enterpriseProject).isEjb31LiteSupported();
    }

    public static boolean isAppClient(Project project) {
        J2eeModuleProvider module = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return module != null ? module.getJ2eeModule().getType().equals(J2eeModule.Type.CAR) : false;
    }

    public static boolean isTargetJavaSE(FileObject fileObject, final String className) throws IOException {
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner.getLookup().lookup(J2eeModuleProvider.class) == null) {
            return true;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                TypeElement junitTestCase = controller.getElements().getTypeElement("junit.framework.TestCase");
                if (junitTestCase != null) {
                    result[0] = controller.getTypes().isSubtype(typeElement.asType(), junitTestCase.asType());
                }
            }
        }, true);
        return result[0];
    }

    public static String jndiNameToCamelCase(String jndiName, boolean lowerCaseFirstChar, String prefixToStrip) {
        String strippedJndiName = jndiName;
        if (prefixToStrip != null && jndiName.startsWith(prefixToStrip)) {
            strippedJndiName = jndiName.substring(jndiName.indexOf(prefixToStrip) + prefixToStrip.length());
        }
        StringBuilder result = new StringBuilder();
        for (String token : strippedJndiName.split("/")) {
            if (token.length() == 0) continue;
            char firstChar = token.charAt(0);
            firstChar = lowerCaseFirstChar && result.length() == 0 && !Utils.isAllUpperCase(token) ? Character.toLowerCase(firstChar) : Character.toUpperCase(firstChar);
            result.append(firstChar);
            result.append(token.substring(1));
        }
        return result.toString();
    }

    public static String makeJavaIdentifierPart(String identifier) {
        StringBuilder result = new StringBuilder(identifier.length());
        for (int i = 0; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart(identifier.charAt(i))) {
                result.append(identifier.charAt(i));
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    public static Project getProject(EjbReference ejbReference, EjbReference.EjbRefIType refIType) throws IOException {
        FileObject ejbReferenceEjbClassFO = ejbReference.getComponentFO(refIType);
        return ejbReferenceEjbClassFO != null ? FileOwnerQuery.getOwner((FileObject)ejbReferenceEjbClassFO) : null;
    }

    public static String toResourceName(String className) {
        assert (className != null) : "cannot find null className";
        return className.replace('.', '/') + ".java";
    }

    private static boolean isAllUpperCase(String str) {
        if (str.length() <= 1) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String getBeanType(final EjbReference ref) throws IOException {
        String type = (String)ref.getEjbModule().getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                Session[] sessionEJBs;
                for (Session session : sessionEJBs = metadata.getRoot().getEnterpriseBeans().getSession()) {
                    if (!session.getEjbClass().equals(ref.getEjbClass())) continue;
                    return session.getSessionType();
                }
                return null;
            }
        });
        return type;
    }

    public static boolean isServlet(FileObject fileObject, final String className) {
        final boolean[] result = new boolean[]{false};
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)fileObject);
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = cc.getElements().getTypeElement(className);
                    result[0] = cc.getTypes().isSubtype(typeElement.asType(), cc.getElements().getTypeElement("javax.servlet.Servlet").asType());
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result[0];
    }
}

