/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.ReturnVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesFormatterFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesNodeModel
implements ExtendedNodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field.gif";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch.gif";
    public static final String STATIC_FIELD = "org/netbeans/modules/debugger/resources/watchesView/StaticField.gif";
    public static final String SUPER = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    public static final String STATIC = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    public static final String RETURN = "org/netbeans/modules/debugger/jpda/resources/Filter.gif";
    public static final String NO_DEBUG_INFO = "org/netbeans/modules/debugger/jpda/resources/wrong_pass.png";
    public static final String EXPR_ARGUMENTS = "org/netbeans/modules/debugger/jpda/resources/ExprArguments.gif";
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private JPDADebugger debugger;
    private RequestProcessor evaluationRP;
    private final Collection modelListeners = new HashSet();
    private final Map shortDescriptionMap = new HashMap();

    public VariablesNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.evaluationRP = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Name");
        }
        if (o instanceof Field) {
            return ((Field)o).getName();
        }
        if (o instanceof LocalVariable) {
            return ((LocalVariable)o).getName();
        }
        if (o instanceof Super) {
            return "super";
        }
        if (o instanceof This) {
            return "this";
        }
        if (o == "NoInfo") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info");
        }
        if (o == "No current thread") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        if (o instanceof JPDAClassType) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_StaticNode");
        }
        if (o instanceof ClassVariable) {
            return "class";
        }
        if (o instanceof ReturnVariable) {
            return "return " + ((ReturnVariable)o).methodName() + "()";
        }
        if (o instanceof EditorContext.Operation) {
            boolean isDone;
            List lastOperations;
            EditorContext.Operation op = (EditorContext.Operation)o;
            EditorContext.Operation lastOperation = null;
            JPDAThread t = this.debugger.getCurrentThread();
            if (t != null && (lastOperations = t.getLastOperations()) != null && lastOperations.size() > 0) {
                lastOperation = (EditorContext.Operation)lastOperations.get(lastOperations.size() - 1);
            }
            boolean bl = isDone = op == lastOperation;
            if (isDone) {
                return NbBundle.getMessage(VariablesNodeModel.class, (String)"afterOperation", (Object)op.getMethodName());
            }
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"beforeOperation", (Object)op.getMethodName());
        }
        if (o == "lastOperations") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"lastOperationsNode");
        }
        if (o instanceof String && ((String)o).startsWith("operationArguments ")) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"operationArgumentsNode", (Object)((String)o).substring("operationArguments ".length()));
        }
        if (o == "NativeMethodException") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NativeMethod");
        }
        if (o == "noDebugInfoWarning") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"noDebugInfoWarning");
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            int index = str.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        String name = VariablesFormatterFilter.FORMATTED_CHILDREN_VARS.get(o);
        if (name != null) {
            return name;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Desc");
        }
        if (o == "NoInfo") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info_descr");
        }
        if (o == "No current thread") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        if (o instanceof JPDAClassType) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_StaticNode_descr");
        }
        if (o instanceof ClassVariable) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_Class_descr");
        }
        if (o instanceof ReturnVariable) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_Return_descr", (Object)(((ReturnVariable)o).methodName() + "()"));
        }
        if (o instanceof EditorContext.Operation) {
            boolean isDone;
            EditorContext.Operation op = (EditorContext.Operation)o;
            boolean bl = isDone = op.getReturnValue() != null;
            if (isDone) {
                return NbBundle.getMessage(VariablesNodeModel.class, (String)"afterOperation_descr", (Object)op.getMethodName());
            }
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"beforeOperation_descr", (Object)op.getMethodName());
        }
        if (o == "lastOperations") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_LastOperations_descr");
        }
        if (o instanceof String && ((String)o).startsWith("operationArguments ")) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"operationArgumentsNode_descr", (Object)((String)o).substring("operationArguments ".length()));
        }
        if (o == "NativeMethodException") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NativeMethod_descr");
        }
        if (o == "noDebugInfoWarning") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"noDebugInfoWarning_descr");
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            int index = str.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return (String)shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)shortDescription);
            }
        }
        this.testKnown(o);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String shortDescription = VariablesNodeModel.this.getShortDescriptionSynch(o);
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, o, 4));
                }
            }
        });
        return "";
    }

    protected String getShortDescriptionSynch(Object o) {
        if (o instanceof Field) {
            if (o instanceof ObjectVariable) {
                String declaredType;
                String type = ((ObjectVariable)o).getType();
                if (type.equals(declaredType = ((Field)o).getDeclaredType())) {
                    try {
                        return "(" + type + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)o);
                    }
                    catch (InvalidExpressionException ex) {
                        return ex.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + declaredType + ") " + "(" + type + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)o);
                }
                catch (InvalidExpressionException ex) {
                    return ex.getLocalizedMessage();
                }
            }
            return "(" + ((Field)o).getDeclaredType() + ") " + ((Field)o).getValue();
        }
        if (o instanceof LocalVariable) {
            if (o instanceof ObjectVariable) {
                String declaredType;
                String type = ((ObjectVariable)o).getType();
                if (type.equals(declaredType = ((LocalVariable)o).getDeclaredType())) {
                    try {
                        return "(" + type + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)o);
                    }
                    catch (InvalidExpressionException ex) {
                        return ex.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + declaredType + ") " + "(" + type + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)o);
                }
                catch (InvalidExpressionException ex) {
                    return ex.getLocalizedMessage();
                }
            }
            return "(" + ((LocalVariable)o).getDeclaredType() + ") " + ((LocalVariable)o).getValue();
        }
        if (o instanceof Super) {
            return ((Super)o).getType();
        }
        if (o instanceof This) {
            try {
                return "(" + ((This)o).getType() + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)((This)o));
            }
            catch (InvalidExpressionException ex) {
                return ex.getLocalizedMessage();
            }
        }
        return null;
    }

    private static String getLimitedToString(ObjectVariable v) throws InvalidExpressionException {
        String toString = null;
        try {
            Method toStringMethod = v.getClass().getMethod("getToStringValue", Integer.TYPE);
            toStringMethod.setAccessible(true);
            toString = (String)toStringMethod.invoke((Object)v, 10000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (toString == null) {
            toString = v.getToStringValue();
        }
        return toString;
    }

    protected void testKnown(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return;
        }
        if (o instanceof Field) {
            return;
        }
        if (o instanceof LocalVariable) {
            return;
        }
        if (o instanceof Super) {
            return;
        }
        if (o instanceof This) {
            return;
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            return;
        }
        if (o == "NoInfo") {
            return;
        }
        if (o == "No current thread") {
            return;
        }
        if (o == "lastOperations") {
            return;
        }
        if (o instanceof String && ((String)o).startsWith("operationArguments ")) {
            return;
        }
        if (o == "NativeMethodException") {
            return;
        }
        if (o == "noDebugInfoWarning") {
            return;
        }
        if (o instanceof JPDAClassType) {
            return;
        }
        if (o instanceof ClassVariable) {
            return;
        }
        if (o instanceof ReturnVariable) {
            return;
        }
        if (o instanceof EditorContext.Operation) {
            return;
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return FIELD;
        }
        if (node instanceof Field) {
            if (((Field)node).isStatic()) {
                return STATIC_FIELD;
            }
            return FIELD;
        }
        if (node instanceof LocalVariable) {
            return LOCAL;
        }
        if (node instanceof Super) {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
        }
        if (node instanceof This) {
            return FIELD;
        }
        if (node instanceof JPDAClassType) {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
        }
        if (node instanceof ClassVariable) {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
        }
        if (node instanceof EditorContext.Operation) {
            return EXPR_ARGUMENTS;
        }
        if (node instanceof ReturnVariable || node == "lastOperations") {
            return RETURN;
        }
        if (node == "noDebugInfoWarning") {
            return NO_DEBUG_INFO;
        }
        if (node instanceof String && ((String)node).startsWith("operationArguments ")) {
            return EXPR_ARGUMENTS;
        }
        if (node.toString().startsWith("SubArray")) {
            return LOCAL;
        }
        if (node == "NoInfo" || node == "No current thread" || node == "NativeMethodException") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }
}

