/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ui.DebuggerOutput;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
JPDABreakpointListener,
PropertyChangeListener {
    private static final Pattern dollarEscapePattern = Pattern.compile("\\$");
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final String threadNamePattern = "{threadName}";
    private static final String classNamePattern = "{className}";
    private static final Pattern methodNamePattern = Pattern.compile("\\{methodName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final String exceptionClassNamePattern = "{exceptionClassName}";
    private static final String exceptionMessagePattern = "{exceptionMessage}";
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private static final String threadStartedCondition = "{? threadStarted}";
    private IOManager ioManager;
    private JPDADebugger debugger;
    private ContextProvider contextProvider;
    private final Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.ioManager = null;
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getDebugger() != this.debugger) {
                return;
            }
        }
        if (event.getConditionResult() == 2) {
            return;
        }
        JPDABreakpoint breakpoint = (JPDABreakpoint)event.getSource();
        if (breakpoint.getSuspend() != 0) {
            this.getBreakpointsNodeModel().setCurrentBreakpoint(breakpoint);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ioManager == null) {
                this.lookupIOManager();
                if (this.ioManager == null) {
                    return;
                }
            }
        }
        String printText = breakpoint.getPrintText();
        if (printText == null || printText.length() == 0) {
            return;
        }
        printText = this.substitute(printText, event);
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.ioManager != null) {
                this.ioManager.println(printText, null);
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("validity".equals(evt.getPropertyName())) {
            JPDABreakpoint bp = (JPDABreakpoint)evt.getSource();
            if (bp.isHidden()) {
                return;
            }
            if (Breakpoint.VALIDITY.INVALID.equals(evt.getNewValue())) {
                String msg = bp.getValidityMessage();
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager == null) {
                        this.lookupIOManager();
                        if (this.ioManager == null) {
                            return;
                        }
                    }
                    String printText = msg != null ? NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpointWithReason", (Object)bp.toString(), (Object)msg) : NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpoint", (Object)bp.toString());
                    IOManager.Line line = null;
                    if (bp instanceof LineBreakpoint) {
                        line = new IOManager.Line(((LineBreakpoint)bp).getURL(), ((LineBreakpoint)bp).getLineNumber(), this.debugger);
                    }
                    this.ioManager.println(printText, null, true);
                    if (line != null) {
                        this.ioManager.println(NbBundle.getMessage(BreakpointOutput.class, (String)"Link_InvalidBreakpoint", (Object)bp.toString()), line, true);
                    }
                }
            }
            if (Breakpoint.VALIDITY.VALID.equals(evt.getNewValue())) {
                Object object = this.lock;
                synchronized (object) {
                    String msg;
                    if (this.ioManager == null) {
                        this.lookupIOManager();
                        if (this.ioManager == null) {
                            return;
                        }
                    }
                    String printText = (msg = bp.getValidityMessage()) != null && msg.trim().length() > 0 ? NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_ValidBreakpointWithReason", (Object)bp.toString(), (Object)msg) : NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_ValidBreakpoint", (Object)bp.toString());
                    IOManager.Line line = null;
                    if (bp instanceof LineBreakpoint) {
                        line = new IOManager.Line(((LineBreakpoint)bp).getURL(), ((LineBreakpoint)bp).getLineNumber(), this.debugger);
                    }
                    this.ioManager.println(printText, line, false);
                }
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.debugger == null || !"state".equals(evt.getPropertyName()) || this.debugger.getState() == 3) {
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substitute(String printText, JPDABreakpointEvent event) {
        Matcher m;
        Variable exception;
        JPDAThread t = event.getThread();
        printText = t != null ? printText.replace(threadNamePattern, t.getName()) : printText.replace(threadNamePattern, "?");
        printText = event.getReferenceType() != null ? printText.replace(classNamePattern, event.getReferenceType().name()) : printText.replace(classNamePattern, "?");
        Session session = null;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].lookupFirst(null, JPDADebugger.class) != this.debugger) continue;
            session = sessions[i];
            break;
        }
        String language = session != null ? session.getCurrentLanguage() : null;
        String methodName = t.getMethodName();
        if ("".equals(methodName)) {
            methodName = "?";
        }
        methodName = dollarEscapePattern.matcher(methodName).replaceAll("\\\\\\$");
        printText = methodNamePattern.matcher(printText).replaceAll(methodName);
        int lineNumber = t.getLineNumber(language);
        printText = lineNumber < 0 ? lineNumberPattern.matcher(printText).replaceAll("?") : lineNumberPattern.matcher(printText).replaceAll(String.valueOf(lineNumber));
        if (event.getSource() instanceof ExceptionBreakpoint && (exception = event.getVariable()) != null) {
            String exceptionClassName = exception.getType();
            printText = printText.replace(exceptionClassNamePattern, exceptionClassName);
            String exceptionMessage = "";
            try {
                Variable var = ((ObjectVariable)exception).invokeMethod("getLocalizedMessage", null, new Variable[0]);
                if (var != null) {
                    exceptionMessage = var.getValue();
                }
            }
            catch (NoSuchMethodException ex) {
                exceptionMessage = "<" + ex.getLocalizedMessage() + ">";
            }
            catch (InvalidExpressionException ex) {
                exceptionMessage = "<" + ex.getLocalizedMessage() + ">";
            }
            printText = printText.replace(exceptionMessagePattern, exceptionMessage);
        }
        if (event.getSource() instanceof ThreadBreakpoint) {
            Variable startedThread = event.getVariable();
            printText = startedThread instanceof ObjectVariable ? BreakpointOutput.selectCondition(printText, threadStartedCondition, true) : BreakpointOutput.selectCondition(printText, threadStartedCondition, false);
        }
        while ((m = expressionPattern.matcher(printText)).find()) {
            String expression = m.group(1);
            String value = "";
            try {
                JPDADebugger theDebugger;
                Object object = this.lock;
                synchronized (object) {
                    if (this.debugger == null) {
                        return value;
                    }
                    theDebugger = this.debugger;
                }
                CallStackFrame csf = null;
                try {
                    CallStackFrame[] topFramePtr = t.getCallStack(0, 1);
                    if (topFramePtr.length > 0) {
                        csf = topFramePtr[0];
                    }
                }
                catch (AbsentInformationException aiex) {
                    // empty catch block
                }
                try {
                    value = ((Variable)theDebugger.getClass().getMethod("evaluate", String.class, CallStackFrame.class).invoke((Object)theDebugger, expression, csf)).getValue();
                }
                catch (InvocationTargetException itex) {
                    if (itex.getTargetException() instanceof InvalidExpressionException) {
                        throw (InvalidExpressionException)itex.getTargetException();
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                value = backslashEscapePattern.matcher(value).replaceAll("\\\\\\\\");
                value = dollarEscapePattern.matcher(value).replaceAll("\\\\\\$");
            }
            catch (InvalidExpressionException e) {
                String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager != null) {
                        this.ioManager.println("Cannot evaluate expression '" + expression + "' : " + msg, null);
                    }
                }
            }
            printText = m.replaceFirst(value);
        }
        Throwable thr = event.getConditionException();
        if (thr != null) {
            printText = printText + "\n***\n" + thr.getLocalizedMessage() + "\n***\n";
        }
        return printText;
    }

    private static String selectCondition(String printText, String condition, boolean isTrue) {
        int index = printText.indexOf(condition);
        if (index >= 0) {
            int index2;
            index += condition.length();
            int l = printText.length();
            while (index < l && printText.charAt(index) != '{') {
                ++index;
            }
            if (index < l && (index2 = BreakpointOutput.findPair(printText, index + 1, '{', '}')) > 0) {
                if (isTrue) {
                    return printText.substring(index + 1, index2).trim();
                }
                for (index = index2 + 1; index < l && printText.charAt(index) != '{'; ++index) {
                }
                if (index < l && (index2 = BreakpointOutput.findPair(printText, index + 1, '{', '}')) > 0) {
                    return printText.substring(index + 1, index2).trim();
                }
            }
        }
        return printText;
    }

    private static int findPair(String printText, int index, char co, char cc) {
        int l = printText.length();
        int ci = 1;
        while (index < l) {
            char c = printText.charAt(index);
            if (c == co) {
                ++ci;
            }
            if (c == cc) {
                --ci;
            }
            if (ci == 0) break;
            ++index;
        }
        if (index < l) {
            return index;
        }
        return -1;
    }

    private void lookupIOManager() {
        List lamls = this.contextProvider.lookup(null, LazyActionsManagerListener.class);
        for (Object o : lamls) {
            if (!(o instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)o).getIOManager();
            break;
        }
    }

    private void hookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.hookBreakpoint(bpt);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.unhookBreakpoint(bpt);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jpdaBreakpoint = (JPDABreakpoint)breakpoint;
            jpdaBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this);
            jpdaBreakpoint.addPropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jpdaBreakpoint = (JPDABreakpoint)breakpoint;
            jpdaBreakpoint.removeJPDABreakpointListener((JPDABreakpointListener)this);
            jpdaBreakpoint.removePropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List l = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nm : l) {
                if (!(nm instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nm;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

