/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.tool.ContextAwareDLightToolConfigurationProvider;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

final class ToolsConfiguration {
    private static final String ENABLE_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String DETAILS_ENABLED = "detailsEnabled";
    static final String KNOWN_TOOLS_SET = "KnownToolsConfigurationProviders";
    private final FileObject rootFolder;
    private boolean useRootFolder = false;
    private List<DLightTool> cachedList = null;
    private final HashMap<String, FileObject> toolsProviders = new HashMap();

    static ToolsConfiguration create(FileObject fileObject) {
        return new ToolsConfiguration(fileObject, false);
    }

    static ToolsConfiguration createDefault(FileObject fileObject) {
        return new ToolsConfiguration(fileObject, true);
    }

    private ToolsConfiguration(FileObject fileObject, boolean useRootFolder) {
        this.rootFolder = fileObject;
        this.useRootFolder = useRootFolder;
    }

    final List<DLightTool> getToolsSet(boolean cached) {
        if (!cached || this.cachedList == null) {
            return this.getToolsSet();
        }
        return this.cachedList;
    }

    FileObject getFileObject(String toolID) {
        if (this.toolsProviders.isEmpty()) {
            this.getToolsSet();
        }
        return this.toolsProviders.get(toolID);
    }

    boolean remove(String toolID) {
        FileObject fo;
        if (this.toolsProviders.isEmpty()) {
            this.getToolsSet();
        }
        if ((fo = this.toolsProviders.get(toolID)) == null) {
            return false;
        }
        try {
            fo.delete();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    boolean register(FileObject fileObject, boolean isEnabled) {
        FileObject configurationsFolder;
        FileObject fileObject2 = configurationsFolder = this.useRootFolder ? this.rootFolder : this.rootFolder.getFileObject(KNOWN_TOOLS_SET);
        if (configurationsFolder == null) {
            return false;
        }
        String fname = fileObject.getName();
        String shadowExt = "shadow";
        if (configurationsFolder.getFileObject(fileObject.getNameExt()) != null) {
            try {
                fileObject.setAttribute(ENABLE_BY_DEFAULT_ATTRIBUTE, (Object)isEnabled);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        if (configurationsFolder.getFileObject(fname, "shadow") == null) {
            try {
                FileObject fo = configurationsFolder.createData(fname, "shadow");
                fo.setAttribute("originalFile", (Object)fileObject.getPath());
                fo.setAttribute(ENABLE_BY_DEFAULT_ATTRIBUTE, (Object)isEnabled);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        FileObject fo = configurationsFolder.getFileObject(fname, "shadow");
        try {
            fo.setAttribute(ENABLE_BY_DEFAULT_ATTRIBUTE, (Object)isEnabled);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<DLightTool> getToolsSet(ExecutionEnvironment env) {
        ToolsConfiguration toolsConfiguration = this;
        synchronized (toolsConfiguration) {
            FileObject configurationsFolder;
            ArrayList<DLightTool> result = new ArrayList<DLightTool>();
            FileObject fileObject = configurationsFolder = this.useRootFolder ? this.rootFolder : this.rootFolder.getFileObject(KNOWN_TOOLS_SET);
            if (configurationsFolder == null) {
                return result;
            }
            FileObject[] children = configurationsFolder.getChildren();
            if (children == null || children.length == 0) {
                return result;
            }
            for (FileObject child : children) {
                Enumeration attrs = child.getAttributes();
                DataObject dobj = null;
                try {
                    dobj = DataObject.find((FileObject)child);
                }
                catch (DataObjectNotFoundException ex) {
                    Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, null, ex);
                }
                InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
                if (ic == null) {
                    String message = "D-Light tool configuration " + child.getName() + " not found";
                    Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, message, new Exception(message));
                    continue;
                }
                try {
                    DLightToolConfigurationProvider configurationProvider = (DLightToolConfigurationProvider)ic.instanceCreate();
                    if (env != null && configurationProvider instanceof ContextAwareDLightToolConfigurationProvider) {
                        ((ContextAwareDLightToolConfigurationProvider)configurationProvider).setExecutionEnvironment(env);
                    }
                    DLightTool tool = DLightToolAccessor.getDefault().newDLightTool(configurationProvider.create());
                    this.toolsProviders.put(tool.getID(), child);
                    boolean enabledByDefault = true;
                    boolean detailsEnabled = true;
                    while (attrs.hasMoreElements()) {
                        String an = (String)attrs.nextElement();
                        if (ENABLE_BY_DEFAULT_ATTRIBUTE.equals(an)) {
                            enabledByDefault = (Boolean)child.getAttribute(an);
                        }
                        if (!DETAILS_ENABLED.equals(an)) continue;
                        detailsEnabled = (Boolean)child.getAttribute(an);
                    }
                    if (enabledByDefault) {
                        tool.enable();
                    } else {
                        tool.disable();
                    }
                    DLightToolAccessor.getDefault().setDetailsEnabled(tool, detailsEnabled);
                    result.add(tool);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.cachedList == null) {
                this.cachedList = result;
            }
            return result;
        }
    }

    final List<DLightTool> getToolsSet() {
        return this.getToolsSet(null);
    }
}

