/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProjectCustomizerPanel;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ProjectCustomizerProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_NAME = "AppFramework";
    private static final String KEY_VENDOR_ID = "Application.vendorId";
    private static final String KEY_APP_ID = "Application.id";
    private static final String KEY_LOOK_AND_FEEL = "Application.lookAndFeel";
    private static final String[][] APP_PROPERTIES = new String[][]{{"application.title", "Application.title"}, {"application.vendor", "Application.vendor"}, {"application.desc", "Application.description"}, {"application.homepage", "Application.homepage"}};

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ProjectCustomizer.Category cat;
        Project project = (Project)context.lookup(Project.class);
        if (AppFrameworkSupport.isApplicationProject(project)) {
            cat = ProjectCustomizer.Category.create((String)CAT_NAME, (String)NbBundle.getMessage(ProjectCustomizerProvider.class, (String)"CTL_ProjectCustomizerCategoryTitle"), null, (ProjectCustomizer.Category[])null);
            J2SEPropertyEvaluator propEval = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
            if (propEval != null) {
                propEval.evaluator().addPropertyChangeListener((PropertyChangeListener)new ApplicationPropertyChangeListener(project));
            }
        } else {
            cat = null;
        }
        return cat;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        DesignResourceMap resMap;
        ProjectCustomizerPanel panel = new ProjectCustomizerPanel();
        Project project = (Project)context.lookup(Project.class);
        SaveListener listener = new SaveListener(project);
        listener.panel = panel;
        category.setOkButtonListener((ActionListener)listener);
        if (ProjectCustomizerPanel.fileChooserDir == null) {
            File projDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
            ProjectCustomizerPanel.fileChooserDir = projDir.getPath();
        }
        if ((resMap = ResourceUtils.getAppDesignResourceMap(project)) != null) {
            panel.setVendorId(resMap.getString(KEY_VENDOR_ID, new Object[0]));
            panel.setApplicationId(resMap.getString(KEY_APP_ID, new Object[0]));
            panel.setLookAndFeel(resMap.getString(KEY_LOOK_AND_FEEL, new Object[0]));
        } else {
            panel.setReadOnly();
        }
        return panel;
    }

    static void storeValue(String key, String value, DesignResourceMap resMap) {
        ResourceValueImpl resValue = resMap.getResourceValue(key, String.class);
        if (resValue != null) {
            if (value != null) {
                resValue.setValue(value);
                resValue.setStringValue(value);
                resMap.addResourceValue(resValue);
            } else {
                resMap.removeResourceValue(resValue);
            }
        } else if (value != null) {
            resValue = new ResourceValueImpl(key, String.class, value, null, value, false, 0, null);
            resMap.addResourceValue(resValue);
        }
    }

    private static class SaveListener
    implements ActionListener,
    Runnable {
        private Project project;
        private ProjectCustomizerPanel panel;

        SaveListener(Project project) {
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            DesignResourceMap resMap = ResourceUtils.getAppDesignResourceMap(this.project);
            if (resMap == null) {
                return;
            }
            if (this.panel != null) {
                ProjectCustomizerProvider.storeValue(ProjectCustomizerProvider.KEY_VENDOR_ID, this.panel.getVendorId(), resMap);
                ProjectCustomizerProvider.storeValue(ProjectCustomizerProvider.KEY_APP_ID, this.panel.getApplicationId(), resMap);
                ProjectCustomizerProvider.storeValue(ProjectCustomizerProvider.KEY_LOOK_AND_FEEL, this.panel.getLookAndFeel(), resMap);
                resMap.save();
                FileObject jarRoot = this.panel.getLookAndFeelJAR();
                if (jarRoot != null) {
                    try {
                        ProjectClassPathModifier.addRoots((URL[])new URL[]{jarRoot.getURL()}, (FileObject)resMap.getSourceFile(), (String)"classpath/execute");
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private static class ApplicationPropertyChangeListener
    implements PropertyChangeListener {
        private Project project;

        ApplicationPropertyChangeListener(Project project) {
            this.project = project;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            for (String[] propNames : APP_PROPERTIES) {
                J2SEPropertyEvaluator propEval;
                PropertyEvaluator props;
                if (!propNames[0].equals(propName) || (props = (propEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class)).evaluator()) == null) continue;
                DesignResourceMap resMap = ResourceUtils.getAppDesignResourceMap(this.project);
                if (resMap == null) {
                    return;
                }
                String value = props.getProperty(propNames[0]);
                ProjectCustomizerProvider.storeValue(propNames[1], value, resMap);
                resMap.save();
            }
        }
    }
}

