/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdesktop.application.ResourceMap;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;

final class DesignResourceMap
extends ResourceMap {
    static final int APP_LEVEL = 0;
    static final int CLASS_LEVEL = 2;
    private static final String NOI18N_COMMENT = "NOI18N";
    private FileObject sourceFile;
    private BundleStructure[] bundles;
    private String locale;
    private String[] localeBundleNames;
    private int storageLevel;
    private Map<String, ChangeInfo> changes = new HashMap<String, ChangeInfo>();
    private static final String EVALUATING_KEY = "#EVALUATING_KEY#";
    private String evaluateStringValue;

    DesignResourceMap(ResourceMap parent, ClassLoader classLoader, FileObject srcFile, String[] bundleNames, int level) {
        super(parent, classLoader, bundleNames);
        this.sourceFile = srcFile;
        this.bundles = new BundleStructure[bundleNames.length];
        this.locale = "";
        this.localeBundleNames = new String[bundleNames.length];
        for (int i = 0; i < bundleNames.length; ++i) {
            this.localeBundleNames[i] = DesignResourceMap.getShortBundleName(bundleNames[i]);
        }
        this.storageLevel = level;
    }

    public DesignResourceMap getDesignParent() {
        ResourceMap parent = super.getParent();
        return parent instanceof DesignResourceMap ? (DesignResourceMap)parent : null;
    }

    DesignResourceMap getLevel(int level) {
        if (level == this.storageLevel) {
            return this;
        }
        DesignResourceMap parent = this.getDesignParent();
        if (parent != null) {
            return parent.getLevel(level);
        }
        return null;
    }

    FileObject getSourceFile() {
        return this.sourceFile;
    }

    void setLocalization(String locale) {
        if (this.locale.equals(locale)) {
            return;
        }
        this.locale = locale;
        List<String> bundleNames = this.getBundleNames();
        for (int i = 0; i < bundleNames.size(); ++i) {
            String shortName = DesignResourceMap.getShortBundleName(bundleNames.get(i));
            this.localeBundleNames[i] = locale != null && !locale.equals("") ? shortName + locale : shortName;
        }
        DesignResourceMap parent = this.getDesignParent();
        if (parent != null) {
            parent.setLocalization(locale);
        }
    }

    private static String getShortBundleName(String bundleName) {
        int idx = bundleName.lastIndexOf(46);
        return idx < 0 ? bundleName : bundleName.substring(idx + 1);
    }

    private BundleStructure[] getBundles() {
        List<String> bundleNames = null;
        for (int i = 0; i < this.bundles.length; ++i) {
            if (this.bundles[i] != null) continue;
            if (bundleNames == null) {
                bundleNames = this.getBundleNames();
            }
            this.bundles[i] = ResourceUtils.getBundleStructure(this.sourceFile, bundleNames.get(i));
        }
        return this.bundles;
    }

    PropertiesDataObject getRepresentativeDataObject() {
        for (String bundleName : this.getBundleNames()) {
            PropertiesDataObject dobj = ResourceUtils.getPropertiesDataObject(this.sourceFile, bundleName, false);
            if (dobj == null) continue;
            return dobj;
        }
        DesignResourceMap parent = this.getDesignParent();
        return parent != null ? parent.getRepresentativeDataObject() : null;
    }

    ResourceValueImpl getResourceValue(String key, Class type) {
        BundleStructure[] bundles = this.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Object value;
            Element.ItemElem item;
            BundleStructure b = bundles[i];
            if (b == null || (item = b.getItem(this.localeBundleNames[i], key)) == null) continue;
            try {
                value = this.getObject(key, type);
            }
            catch (ResourceMap.LookupException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                value = null;
            }
            String stringValue = item.getValue();
            String resName = this.getResourceName(type, stringValue);
            return new ResourceValueImpl(key, type, value, resName, stringValue, !DesignResourceMap.isNoI18nComment(item.getComment()), this.storageLevel, this.sourceFile);
        }
        DesignResourceMap parent = this.getDesignParent();
        return parent != null ? parent.getResourceValue(key, type) : null;
    }

    private static boolean isNoI18nComment(String comment) {
        if (comment != null && comment.length() > 0) {
            comment = comment.trim().toUpperCase();
            return comment.contains(NOI18N_COMMENT);
        }
        return false;
    }

    private String getResourceName(Class valueType, String stringValue) {
        if (Icon.class.isAssignableFrom(valueType)) {
            return this.getResourcesDir() + stringValue;
        }
        return null;
    }

    Object evaluateStringValue(String stringValue, Class type) {
        this.evaluateStringValue = stringValue;
        Object value = this.getObject(EVALUATING_KEY, type);
        this.evaluateStringValue = null;
        return value;
    }

    Collection<String> collectKeys(String regex, boolean wholeChain) {
        Collection<String> col = this.collectKeys(regex, null, wholeChain);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    private Collection<String> collectKeys(String regex, Collection<String> col, boolean wholeChain) {
        DesignResourceMap parent;
        BundleStructure[] bundles = this.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            BundleStructure b = bundles[i];
            if (b == null) continue;
            for (String key : b.getKeys()) {
                if (!key.matches(regex)) continue;
                if (col == null) {
                    col = new LinkedList<String>();
                }
                col.add(key);
            }
        }
        if (wholeChain && (parent = this.getDesignParent()) != null) {
            col = parent.collectKeys(regex, col, wholeChain);
        }
        return col;
    }

    Collection<MultiDataObject.Entry> collectLocaleEntries() {
        Collection<MultiDataObject.Entry> col = this.collectLocaleEntries(null);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    private Collection<MultiDataObject.Entry> collectLocaleEntries(Collection<MultiDataObject.Entry> col) {
        for (String bundleName : this.getBundleNames()) {
            PropertiesDataObject dobj = ResourceUtils.getPropertiesDataObject(this.sourceFile, bundleName, false);
            if (dobj == null) continue;
            if (col == null) {
                col = new LinkedList<MultiDataObject.Entry>();
            }
            col.add(dobj.getPrimaryEntry());
            col.addAll(dobj.secondaryEntries());
            try {
                String baseName = dobj.getName() + "_";
                for (FileObject fo : dobj.getPrimaryFile().getParent().getChildren()) {
                    DataObject dobj2;
                    String fileName = fo.getNameExt();
                    if (!fileName.endsWith(".properties") || !fileName.startsWith(baseName) || !((dobj2 = DataObject.find((FileObject)fo)) instanceof PropertiesDataObject)) continue;
                    col.add(((MultiDataObject)dobj2).getPrimaryEntry());
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        DesignResourceMap parent = this.getDesignParent();
        return parent != null ? parent.collectLocaleEntries(col) : col;
    }

    void removeResourceValue(ResourceValueImpl resValue) {
        block2: {
            block1: {
                if (resValue.getStorageLevel() == this.storageLevel) break block1;
                DesignResourceMap parent = this.getDesignParent();
                if (parent == null) break block2;
                parent.removeResourceValue(resValue);
                break block2;
            }
            String key = resValue.getKey();
            for (BundleStructure b : this.bundles) {
                String[] data;
                if (b == null || (data = b.getAllData(key)) == null) continue;
                b.removeItem(key);
                this.recordChange(key, data, b);
                resValue.setAllData(data);
                break;
            }
        }
    }

    void addResourceValue(ResourceValueImpl resValue) {
        if (resValue.getStorageLevel() != this.storageLevel) {
            DesignResourceMap parent = this.getDesignParent();
            if (parent != null) {
                parent.addResourceValue(resValue);
            }
        } else {
            String[] data;
            Object value;
            Class valueType;
            String stringValue;
            String locName;
            String[] currentData;
            BundleStructure bundle;
            String key;
            block14: {
                key = resValue.getKey();
                int bundleIndex = 0;
                bundle = null;
                currentData = null;
                for (BundleStructure b : this.getBundles()) {
                    if (b != null && (currentData = b.getAllData(key)) != null) {
                        bundle = b;
                        break;
                    }
                    ++bundleIndex;
                }
                if (bundle == null) {
                    bundleIndex = 0;
                    bundle = this.bundles[0];
                }
                String bundleName = this.getBundleNames().get(bundleIndex);
                locName = resValue.isInternationalized() ? this.localeBundleNames[bundleIndex] : DesignResourceMap.getShortBundleName(bundleName);
                PropertiesDataObject dobj = null;
                if (bundle == null) {
                    try {
                        dobj = ResourceUtils.createPropertiesDataObject(this.getSourceFile(), bundleName);
                        bundle = dobj.getBundleStructure();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                        return;
                    }
                }
                if (!bundleName.endsWith(locName)) {
                    String locale = locName.substring(DesignResourceMap.getShortBundleName(bundleName).length() + 1);
                    Util.createLocaleFile((PropertiesDataObject)dobj, (String)locale, (boolean)false);
                }
                stringValue = resValue.getStringValue();
                valueType = resValue.getValueType();
                try {
                    value = this.evaluateStringValue(stringValue, valueType);
                }
                catch (ResourceMap.LookupException ex) {
                    value = resValue.getValue();
                    String strValue = ResourceUtils.getValueAsString(value);
                    if (strValue == null) break block14;
                    resValue.setStringValue(strValue);
                    stringValue = strValue;
                }
            }
            bundle.addItem(locName, key, stringValue, resValue.isInternationalized() ? "" : NOI18N_COMMENT, true);
            this.recordChange(key, currentData, bundle);
            if (currentData == null && (data = resValue.getAllData()) != null) {
                bundle.setAllData(key, data);
                resValue.setAllData(null);
            }
            resValue.setValue(value);
            if (resValue.getClassPathResourceName() == null) {
                resValue.setClassPathResourceName(this.getResourceName(valueType, stringValue));
            }
        }
    }

    private void recordChange(String key, String[] originalData, BundleStructure bundle) {
        if (!this.changes.containsKey(key)) {
            ChangeInfo ch = new ChangeInfo();
            ChangeInfo.access$102(ch, originalData);
            ch.bundle = bundle;
            this.changes.put(key, ch);
        }
    }

    void save() {
        this.save(true);
    }

    private void save(boolean wholeChain) {
        DesignResourceMap parent;
        if (!this.changes.isEmpty()) {
            for (String bundleName : this.getBundleNames()) {
                SaveCookie save;
                PropertiesDataObject dobj = ResourceUtils.getPropertiesDataObject(this.sourceFile, bundleName, false);
                if (dobj == null || (save = (SaveCookie)dobj.getCookie(SaveCookie.class)) == null) continue;
                try {
                    save.save();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            this.changes.clear();
        }
        if (wholeChain && (parent = this.getDesignParent()) != null) {
            parent.save(wholeChain);
        }
    }

    void revertChanges() {
        for (Map.Entry<String, ChangeInfo> entry : this.changes.entrySet()) {
            String key = entry.getKey();
            BundleStructure bundle = entry.getValue().bundle;
            String[] data = entry.getValue().originalData;
            if (data != null) {
                bundle.setAllData(key, data);
                continue;
            }
            bundle.removeItem(key);
        }
        DesignResourceMap parent = this.getDesignParent();
        if (parent != null) {
            parent.revertChanges();
        }
        this.save(false);
    }

    @Override
    protected boolean containsResourceKey(String key) {
        if (key == EVALUATING_KEY && this.evaluateStringValue != null) {
            return true;
        }
        this.getBundles();
        for (int i = 0; i < this.bundles.length; ++i) {
            if (this.bundles[i] == null || this.bundles[i].getItem(this.localeBundleNames[i], key) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object getResource(String key) {
        if (key == EVALUATING_KEY) {
            return this.evaluateStringValue;
        }
        this.getBundles();
        for (int i = 0; i < this.bundles.length; ++i) {
            Element.ItemElem item;
            if (this.bundles[i] == null || (item = this.bundles[i].getItem(this.localeBundleNames[i], key)) == null) continue;
            return item.getValue();
        }
        return null;
    }

    @Override
    protected void putResource(String key, Object value) {
    }

    private static class ChangeInfo {
        private String[] originalData;
        private BundleStructure bundle;

        private ChangeInfo() {
        }

        static /* synthetic */ String[] access$102(ChangeInfo x0, String[] x1) {
            x0.originalData = x1;
            return x1;
        }
    }
}

