/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class ActionRescanJavaSourceTaskFactoryImpl
extends EditorAwareJavaSourceTaskFactory {
    public ActionRescanJavaSourceTaskFactoryImpl() {
        super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
    }

    public CancellableTask<CompilationInfo> createTask(FileObject file) {
        return new RescanTask(file);
    }

    public JavaSource.Priority getPriority() {
        return JavaSource.Priority.LOW;
    }

    public JavaSource.Phase getPhase() {
        return JavaSource.Phase.RESOLVED;
    }

    private static class RescanTask
    implements CancellableTask<CompilationInfo> {
        FileObject file;

        public RescanTask(FileObject file) {
            this.file = file;
        }

        public void cancel() {
        }

        public void run(CompilationInfo info) throws Exception {
            if (ActionManager.anyFormOpened() && AppFrameworkSupport.isFrameworkLibAvailable(this.file) && (RescanTask.isApplicationSourceFile(this.file) || RescanTask.isOpenedForm(this.file))) {
                ActionManager.lazyRescan(this.file);
            }
        }

        private static boolean isApplicationSourceFile(FileObject file) {
            String appClsName = AppFrameworkSupport.getAppClassNameFromProjectConfig(FileOwnerQuery.getOwner((FileObject)file));
            if (appClsName != null) {
                return appClsName.equals(AppFrameworkSupport.getClassNameForFile(file));
            }
            return false;
        }

        private static boolean isOpenedForm(FileObject fo) {
            block4: {
                if (fo.existsExt("form") && fo.hasExt("java")) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)fo);
                        if (dobj instanceof FormDataObject) {
                            FormDataObject formDO = (FormDataObject)dobj;
                            return formDO.getFormEditor().isOpened();
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }
}

