/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.awt.Point;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;

public class SceneListAdapter
implements ListModel,
SceneListener {
    private Scene scene;
    private ArrayList listeners = new ArrayList();

    public SceneListAdapter(Scene layerModel) {
        this.scene = layerModel;
        this.scene.addSceneListener(this);
    }

    @Override
    public int getSize() {
        return this.scene.getLayerCount();
    }

    public Object getElementAt(int index) {
        return this.scene.getLayerAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void layerAdded(Scene sourceScene, Layer layer, int index) {
        ListDataEvent lde = new ListDataEvent(sourceScene, 1, index, index);
        for (ListDataListener listener : this.listeners) {
            listener.intervalAdded(lde);
        }
    }

    @Override
    public void layerRemoved(Scene sourceScene, Layer layer, Scene.LayerInfo info, int index) {
        ListDataEvent lde = new ListDataEvent(sourceScene, 2, index, index);
        for (ListDataListener listener : this.listeners) {
            listener.intervalRemoved(lde);
        }
    }

    public void layerModified(Scene sourceScene, Layer layer) {
        int index = sourceScene.indexOf(layer);
        ListDataEvent lde = new ListDataEvent(sourceScene, 0, index, index);
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(lde);
        }
    }

    @Override
    public void layerMoved(Scene sourceScene, Layer layer, int indexOld, int indexNew) {
        this.layerModified(sourceScene, layer);
    }

    @Override
    public void layerLockChanged(Scene sourceScene, Layer layer, boolean locked) {
        this.layerModified(sourceScene, layer);
    }

    @Override
    public void layerPositionChanged(Scene sourceScene, Layer layer, Point oldPosition, Point newPosition, boolean inTransition) {
        this.layerModified(sourceScene, layer);
    }

    @Override
    public void layerVisibilityChanged(Scene sourceScene, Layer layer, boolean visible) {
        this.layerModified(sourceScene, layer);
    }
}

