/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.dialog.NewSequenceDialog;
import org.netbeans.modules.vmd.game.dialog.RenameAnimatedTileDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerEditor;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerNavigator;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.preview.SequenceContainerPreview;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AnimatedTile
extends Tile
implements SequenceContainer,
Editable,
Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SequenceContainer.SequenceContainerImpl sequenceContainer;
    private SequenceContainerEditor editor;
    private JComponent navigator;
    private String name;

    AnimatedTile(String name, ImageResource imageResource, int index, Sequence sequence, int width, int height) {
        super(imageResource, index, width, height);
        this.sequenceContainer = new SequenceContainer.SequenceContainerImpl(this, null, this.propertyChangeSupport, imageResource, width, height, false);
        this.name = name;
        this.setDefaultSequence(sequence);
    }

    AnimatedTile(String name, ImageResource imageResource, int index, int width, int height) {
        super(imageResource, index, width, height);
        this.sequenceContainer = new SequenceContainer.SequenceContainerImpl(this, null, this.propertyChangeSupport, imageResource, width, height, false);
        this.name = name;
        String seqName = this.getNextSequenceName(this.name + "seq");
        Sequence sequence = this.createSequence(seqName, 1, width, height);
        this.setDefaultSequence(sequence);
    }

    @Override
    public String getNextSequenceName(String prefix) {
        return this.sequenceContainer.getNextSequenceName(prefix);
    }

    @Override
    public GlobalRepository getGameDesign() {
        return this.getImageResource().getGameDesign();
    }

    @Override
    public void addSequenceContainerListener(SequenceContainerListener listener) {
        this.sequenceContainer.addSequenceContainerListener(listener);
    }

    @Override
    public void removeSequenceContainerListener(SequenceContainerListener listener) {
        this.sequenceContainer.removeSequenceContainerListener(listener);
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (!this.getGameDesign().isComponentNameAvailable(name)) {
            throw new IllegalArgumentException("AnimatedTile cannot be renamed because component name '" + name + "' already exists.");
        }
        String oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("editable.prop.name", oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Sequence createSequence(String name, int numberFrames, int frameWidth, int frameHeight) {
        return this.sequenceContainer.createSequence(name, numberFrames, frameWidth, frameHeight);
    }

    @Override
    public Sequence createSequence(String name, Sequence s) {
        return this.sequenceContainer.createSequence(name, s);
    }

    @Override
    public boolean append(Sequence sequence) {
        return this.sequenceContainer.append(sequence);
    }

    @Override
    public boolean insert(Sequence sequence, int index) {
        return this.sequenceContainer.insert(sequence, index);
    }

    @Override
    public boolean remove(Sequence sequence) {
        return this.sequenceContainer.remove(sequence);
    }

    @Override
    public void move(Sequence sequence, int newIndex) {
        this.sequenceContainer.move(sequence, newIndex);
    }

    @Override
    public List<Sequence> getSequences() {
        return this.sequenceContainer.getSequences();
    }

    @Override
    public int getSequenceCount() {
        return this.sequenceContainer.getSequenceCount();
    }

    @Override
    public Sequence getSequenceByName(String name) {
        return this.sequenceContainer.getSequenceByName(name);
    }

    @Override
    public void setDefaultSequence(Sequence defaultSequence) {
        this.sequenceContainer.setDefaultSequence(defaultSequence);
    }

    @Override
    public Sequence getDefaultSequence() {
        return this.sequenceContainer.getDefaultSequence();
    }

    @Override
    public int indexOf(Sequence sequence) {
        return this.sequenceContainer.indexOf(sequence);
    }

    @Override
    public Sequence getSequenceAt(int index) {
        return this.sequenceContainer.getSequenceAt(index);
    }

    @Override
    public List<Action> getActionsForSequence(Sequence sequence) {
        return this.sequenceContainer.getActionsForSequence(sequence);
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new SequenceContainerEditor(this)) : this.editor;
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.getImageResource(), this.getWidth(), this.getHeight(), false);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new RenameAction());
        actions.add(new AddSequenceAction());
        actions.add(new DeleteAction());
        return Collections.unmodifiableList(actions);
    }

    @Override
    public JComponent getPreview() {
        return new SequenceContainerPreview(NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.previewLabel.text"), this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
        this.getDefaultSequence().getFrame(0).paint(g, x, y);
    }

    @Override
    public void paint(Graphics2D g, int x, int y, int scaledWidth, int scaledHeight) {
        this.getDefaultSequence().getFrame(0).paint(g, x, y, scaledWidth, scaledHeight);
    }

    @Override
    public JComponent getNavigator() {
        return this.navigator == null ? (this.navigator = new SequenceContainerNavigator(this)) : this.navigator;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.DeleteAction.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object response = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.DeleteDialog.text", (Object)AnimatedTile.this.getName()), NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.DeleteAnimatedTile.text"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION));
            if (response == NotifyDescriptor.YES_OPTION) {
                AnimatedTile.this.getImageResource().removeAnimatedTile(AnimatedTile.this.getIndex());
            }
        }
    }

    public class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.RenameAction.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameAnimatedTileDialog dialog = new RenameAnimatedTileDialog(AnimatedTile.this);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.RenameAction.name"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class AddSequenceAction
    extends AbstractAction {
        public AddSequenceAction() {
            this.putValue("Name", NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.AddSequenceAction.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewSequenceDialog dialog = new NewSequenceDialog(AnimatedTile.this, AnimatedTile.this.getWidth(), AnimatedTile.this.getHeight());
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.AddSequenceAction.name"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }
}

