/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class BooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer,
TableCellEditor,
ActionListener,
ItemListener {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;
    private ImageIcon iconVisible;
    private ImageIcon iconInvisible;
    private ImageIcon iconLocked;
    private ImageIcon iconUnlocked;
    protected EventListenerList listenerList = new EventListenerList();

    public BooleanTableCellRenderer(int padX, int padY) {
        try {
            this.initIcons();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.addActionListener(this);
        this.addItemListener(this);
        this.setBackground(Color.WHITE);
        Dimension d = new Dimension(this.iconVisible.getIconWidth() + padX, this.iconVisible.getIconHeight() + padY);
        this.setPreferredSize(d);
        this.setHorizontalAlignment(0);
    }

    private void initIcons() throws MalformedURLException {
        this.iconVisible = new ImageIcon(this.getClass().getResource("res/visible.png"));
        this.iconInvisible = new ImageIcon(this.getClass().getResource("res/invisible.png"));
        this.iconLocked = new ImageIcon(this.getClass().getResource("res/lock.png"));
        this.iconUnlocked = new ImageIcon(this.getClass().getResource("res/unlock.png"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Boolean) {
            this.setImages(column);
            this.setSelected((Boolean)value);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
        throw new IllegalArgumentException("Only Boolean can be rendered.");
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Boolean) {
            this.setImages(column);
            this.setSelected((Boolean)value);
            return this;
        }
        throw new IllegalArgumentException("Only Boolean can be edited.");
    }

    private void setImages(int col) {
        if (col == 3) {
            this.setSelectedIcon(this.iconLocked);
            this.setIcon(this.iconUnlocked);
        } else {
            this.setSelectedIcon(this.iconVisible);
            this.setIcon(this.iconInvisible);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireEditingStopped();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }
}

