/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.util;

import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.util.SpinnerTimeEditor;
import org.netbeans.modules.dlight.visualizers.util.SpinnerTimeModel;
import org.openide.util.NbBundle;

public final class TimeIntervalPanel
extends JPanel
implements DataFilterListener {
    private DataFilterManager manager;
    private final ChangeListener startTimeChangeListener = new StartTimeSpinnerListener();
    private final ChangeListener endTimeChangeListener = new EndTimeSpinnerListener();
    private final UILock uiLock = new UILock();
    private JSpinner endTimeSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner startTimeSpinner;

    public TimeIntervalPanel(DataFilterManager manager) {
        this.initComponents();
        this.manager = manager;
        if (manager != null) {
            this.manager.addDataFilterListener((DataFilterListener)this);
            this.update(manager.getDataFilter(TimeIntervalDataFilter.class));
        }
        this.startTimeSpinner.addChangeListener(this.startTimeChangeListener);
        this.endTimeSpinner.addChangeListener(this.endTimeChangeListener);
    }

    public void update(DataFilterManager manager) {
        if (this.manager != null) {
            this.manager.removeDataFilterListener((DataFilterListener)this);
        }
        this.manager = manager;
        if (this.manager != null) {
            this.manager.addDataFilterListener((DataFilterListener)this);
        }
        this.update(manager == null ? null : manager.getDataFilter(TimeIntervalDataFilter.class));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.startTimeSpinner = new JSpinner();
        this.endTimeSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setText(NbBundle.getMessage(TimeIntervalPanel.class, (String)"TimeIntervalPanel.jLabel1.text"));
        this.startTimeSpinner.setModel(new SpinnerTimeModel());
        this.startTimeSpinner.setEditor(new SpinnerTimeEditor(this.startTimeSpinner));
        this.endTimeSpinner.setModel(new SpinnerTimeModel());
        this.endTimeSpinner.setEditor(new SpinnerTimeEditor(this.endTimeSpinner));
        this.endTimeSpinner.setValue(Long.MAX_VALUE);
        this.jLabel2.setText(NbBundle.getMessage(TimeIntervalPanel.class, (String)"TimeIntervalPanel.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(TimeIntervalPanel.class, (String)"TimeIntervalPanel.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startTimeSpinner, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endTimeSpinner, -2, 80, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.endTimeSpinner, -2, -1, -2).addComponent(this.startTimeSpinner, -2, -1, -2)).addContainerGap()));
    }

    public Range<Long> getSelectedInterval() {
        return new Range((Number)((Long)this.startTimeSpinner.getValue()), (Number)((Long)this.endTimeSpinner.getValue()));
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                TimeIntervalPanel.this.update(TimeIntervalPanel.this.manager.getDataFilter(TimeIntervalDataFilter.class));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(Collection<TimeIntervalDataFilter> filters) {
        TimeIntervalDataFilter filter = null;
        if (filters != null && !filters.isEmpty()) {
            filter = filters.iterator().next();
        }
        UILock uILock = this.uiLock;
        synchronized (uILock) {
            this.startTimeSpinner.removeChangeListener(this.startTimeChangeListener);
            this.endTimeSpinner.removeChangeListener(this.endTimeChangeListener);
            this.startTimeSpinner.setValue(filter == null ? 0L : (Long)filter.getInterval().getStart());
            this.endTimeSpinner.setValue(filter == null ? Long.MAX_VALUE : (Long)filter.getInterval().getEnd());
            this.startTimeSpinner.addChangeListener(this.startTimeChangeListener);
            this.endTimeSpinner.addChangeListener(this.endTimeChangeListener);
        }
    }

    private void applyFilter() {
        if (this.manager != null) {
            this.manager.addDataFilter((DataFilter)TimeIntervalDataFilterFactory.create((Range)new Range((Number)((Long)this.startTimeSpinner.getValue()), (Number)((Long)this.endTimeSpinner.getValue()))), false);
        }
    }

    private static final class UILock {
        private UILock() {
        }
    }

    private final class EndTimeSpinnerListener
    implements ChangeListener {
        private EndTimeSpinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if ((Long)TimeIntervalPanel.this.startTimeSpinner.getValue() >= (Long)TimeIntervalPanel.this.endTimeSpinner.getValue()) {
                TimeIntervalPanel.this.startTimeSpinner.setValue((Long)TimeIntervalPanel.this.endTimeSpinner.getValue() - 1L);
            }
            TimeIntervalPanel.this.applyFilter();
        }
    }

    private final class StartTimeSpinnerListener
    implements ChangeListener {
        private StartTimeSpinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if ((Long)TimeIntervalPanel.this.startTimeSpinner.getValue() >= (Long)TimeIntervalPanel.this.endTimeSpinner.getValue()) {
                TimeIntervalPanel.this.endTimeSpinner.setValue((Long)TimeIntervalPanel.this.startTimeSpinner.getValue() + 1L);
            }
            TimeIntervalPanel.this.applyFilter();
        }
    }
}

