/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Component;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.visualizers.GotoSourceActionProvider;
import org.netbeans.modules.dlight.visualizers.TableViewVisualizer;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.FunctionsListViewVisualizerConfigurationAccessor;
import org.netbeans.modules.dlight.visualizers.ui.FunctionCallNodeChildren;
import org.netbeans.modules.dlight.visualizers.ui.FunctionsListViewTable;
import org.netbeans.modules.dlight.visualizers.ui.TableViewNodeChildren;
import org.openide.util.Lookup;

public final class FunctionsListViewVisualizer
extends TableViewVisualizer<FunctionsListViewVisualizerConfiguration, FunctionCallWithMetric> {
    private final DataTableMetadata metadata;
    private final FunctionDatatableDescription functionDatatableDescription;
    private final List<DataTableMetadata.Column> metrics;
    private final FunctionsListDataProvider dataProvider;

    FunctionsListViewVisualizer(FunctionsListDataProvider dataProvider, FunctionsListViewVisualizerConfiguration cfg) {
        super((DataProvider)dataProvider, cfg);
        this.dataProvider = dataProvider;
        this.metadata = cfg.getMetadata();
        FunctionsListViewVisualizerConfigurationAccessor cfgAccess = FunctionsListViewVisualizerConfigurationAccessor.getDefault();
        this.metrics = cfgAccess.getMetricsList(cfg);
        this.functionDatatableDescription = cfgAccess.getFunctionDatatableDescription(cfg);
    }

    @Override
    protected Component initTableView() {
        FunctionsListViewVisualizerConfigurationAccessor cfgAccess = FunctionsListViewVisualizerConfigurationAccessor.getDefault();
        ColumnsUIMapping columnsUIMapping = cfgAccess.getColumnsUIMapping((FunctionsListViewVisualizerConfiguration)this.getVisualizerConfiguration());
        String nodeLabel = columnsUIMapping == null || columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn()) == null ? this.metadata.getColumnByName(this.functionDatatableDescription.getNameColumn()).getColumnUName() : columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn());
        return new FunctionsListViewTable(this.getExplorerManager(), nodeLabel, columnsUIMapping, this.metrics);
    }

    @Override
    protected List<FunctionCallWithMetric> getUpdatedData() {
        List newData = this.dataProvider.getFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        List details = this.dataProvider.getDetailedFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        Collection supports = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        if (supports != null) {
            for (AnnotatedSourceSupport sourceSupport : supports) {
                sourceSupport.updateSource((SourceFileInfoDataProvider)this.dataProvider, this.metrics, newData, details);
            }
        }
        return newData;
    }

    @Override
    protected TableViewNodeChildren<FunctionCallWithMetric> initChildren() {
        GotoSourceActionProvider gotoSourceActionsProvider = new GotoSourceActionProvider((SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class), this.dataProvider);
        return new FunctionCallNodeChildren(gotoSourceActionsProvider, this.metrics);
    }

    @Override
    protected boolean matchesFilter(String filter, FunctionCallWithMetric function) {
        return filter == null || filter.isEmpty() || function.getFunction().getName().contains(filter);
    }
}

