/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.AuxiliaryConfigBasedPreferencesProvider;
import org.netbeans.modules.projectapi.AuxiliaryConfigImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class ProjectUtils {
    private static final Logger LOG = Logger.getLogger(ProjectUtils.class.getName());

    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(Project p) {
        ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
        return new AnnotateIconProxyProjectInformation(pi != null ? pi : new BasicInformation(p));
    }

    public static Sources getSources(Project p) {
        Sources s = (Sources)p.getLookup().lookup(Sources.class);
        if (s != null) {
            return s;
        }
        return GenericSources.genericOnly(p);
    }

    public static boolean hasSubprojectCycles(final Project master, final Project candidate) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return ProjectUtils.visit(new HashMap(), master, master, candidate);
            }
        });
    }

    public static Preferences getPreferences(Project project, Class clazz, boolean shared) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"clazz", (Object)clazz);
        return AuxiliaryConfigBasedPreferencesProvider.getPreferences(project, clazz, shared);
    }

    private static boolean visit(Map<Project, Boolean> encountered, Project curr, Project master, Project candidate) {
        if (encountered.containsKey(curr)) {
            if (encountered.get(curr).booleanValue()) {
                return false;
            }
            LOG.log(Level.FINE, "Encountered cycle in {0} from {1} at {2} via {3}", new Object[]{master, candidate, curr, encountered});
            return true;
        }
        encountered.put(curr, false);
        SubprojectProvider spp = (SubprojectProvider)curr.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            Set<? extends Project> subprojects = spp.getSubprojects();
            LOG.log(Level.FINEST, "Found subprojects {0} from {1}", new Object[]{subprojects, curr});
            for (Project project : subprojects) {
                if (ProjectUtils.visit(encountered, project, master, candidate)) {
                    return true;
                }
                if (candidate != project) continue;
                candidate = null;
            }
        }
        if (candidate != null && curr == master && ProjectUtils.visit(encountered, candidate, master, candidate)) {
            return true;
        }
        assert (!encountered.get(curr).booleanValue());
        encountered.put(curr, true);
        return false;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return new AuxiliaryConfigImpl(project);
    }

    public static FileObject getCacheDirectory(Project project, Class<?> owner) throws IOException {
        CacheDirectoryProvider cdp = (CacheDirectoryProvider)project.getLookup().lookup(CacheDirectoryProvider.class);
        FileObject d = cdp != null ? cdp.getCacheDirectory() : FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)String.format("Projects/extra/%s-%08x", ProjectUtils.getInformation(project).getName().replace('/', '_'), project.getProjectDirectory().getPath().hashCode()));
        return FileUtil.createFolder((FileObject)d, (String)AuxiliaryConfigBasedPreferencesProvider.findCNBForClass(owner));
    }

    private static final class AnnotateIconProxyProjectInformation
    implements ProjectInformation,
    PropertyChangeListener,
    ChangeListener,
    LookupListener {
        private final ProjectInformation pinfo;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Set<ProjectIconAnnotator> annotators = new WeakSet();
        private final Lookup.Result<ProjectIconAnnotator> annotatorResult = Lookup.getDefault().lookupResult(ProjectIconAnnotator.class);
        private Icon icon;

        public AnnotateIconProxyProjectInformation(ProjectInformation pi) {
            this.pinfo = pi;
            this.pinfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pinfo));
            this.annotatorResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.annotatorResult));
            this.annotatorsChanged();
        }

        private void annotatorsChanged() {
            for (ProjectIconAnnotator pa : this.annotatorResult.allInstances()) {
                if (!this.annotators.add(pa)) continue;
                pa.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)pa));
            }
            this.updateIcon();
        }

        public void resultChanged(LookupEvent ev) {
            this.annotatorsChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("icon".equals(evt.getPropertyName())) {
                this.updateIcon();
            } else {
                this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateIcon();
        }

        private void updateIcon() {
            Icon original = this.pinfo.getIcon();
            if (original == null) {
                return;
            }
            Image _icon = ImageUtilities.icon2Image((Icon)original);
            for (ProjectIconAnnotator pa : this.annotatorResult.allInstances()) {
                _icon = pa.annotateIcon(this.getProject(), _icon, false);
            }
            Icon old = this.icon;
            this.icon = ImageUtilities.image2Icon((Image)_icon);
            this.pcs.firePropertyChange("icon", old, this.icon);
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public Project getProject() {
            return this.pinfo.getProject();
        }

        @Override
        public String getName() {
            return this.pinfo.getName();
        }

        @Override
        public String getDisplayName() {
            return this.pinfo.getDisplayName();
        }
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project p) {
            this.p = p;
        }

        @Override
        public String getName() {
            try {
                return this.p.getProjectDirectory().getURL().toExternalForm();
            }
            catch (FileStateInvalidException e) {
                return e.toString();
            }
        }

        @Override
        public String getDisplayName() {
            return this.p.getProjectDirectory().getNameExt();
        }

        @Override
        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/projectapi/resources/empty.gif", (boolean)false);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Project getProject() {
            return this.p;
        }
    }
}

