/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTableModel;
import org.openide.awt.Mnemonics;

public class WebResourceCollectionPanel
extends JPanel {
    private static String GET = "GET";
    private static String POST = "POST";
    private static String HEAD = "HEAD";
    private static String PUT = "PUT";
    private static String OPTIONS = "OPTIONS";
    private static String TRACE = "TRACE";
    private static String DELETE = "DELETE";
    private static String[] allMethods = new String[]{GET, POST, HEAD, PUT, OPTIONS, TRACE, DELETE};
    private JRadioButton allHttpMethodsRB;
    private ButtonGroup buttonGroup1;
    private JCheckBox deleteCB;
    private JLabel descriptionLabel;
    private JTextField descriptionTF;
    private JCheckBox getCB;
    private JCheckBox headCB;
    private JLabel httpMethodLabel;
    private JLabel jLabel5;
    private JCheckBox optionsCB;
    private JCheckBox postCB;
    private JCheckBox putCB;
    private JLabel resourceNameLabel;
    private JTextField resourceNameTF;
    private JRadioButton subsetHttpMethodsRB;
    private JCheckBox traceCB;
    private JLabel urlPatternsLabel;
    private JTextField urlPatternsTF;

    public WebResourceCollectionPanel() {
        this.initComponents();
    }

    public String getResourceName() {
        return this.resourceNameTF.getText();
    }

    public void setResourceName(String name) {
        this.resourceNameTF.setText(name);
    }

    public String[] getUrlPatterns() {
        StringTokenizer tokenizer = new StringTokenizer(this.urlPatternsTF.getText(), ",");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken().trim();
            if (pattern.length() <= 0) continue;
            list.add(pattern);
        }
        String[] result = new String[list.size()];
        return list.toArray(result);
    }

    public void setUrlPatterns(String[] patterns) {
        this.urlPatternsTF.setText(WebResourceCollectionTableModel.getCommaSeparatedString(patterns));
    }

    public String getDescription() {
        return this.descriptionTF.getText();
    }

    public void setDescription(String description) {
        this.descriptionTF.setText(description);
    }

    public void setHttpMethods(String[] methods) {
        String method;
        int i;
        if (methods == null || methods.length == 0) {
            this.allHttpMethodsRB.setSelected(true);
            return;
        }
        for (i = 0; i < allMethods.length; ++i) {
            method = allMethods[i];
            for (int j = 0; j < methods.length && !method.equals(methods[j]); ++j) {
            }
        }
        this.subsetHttpMethodsRB.setSelected(true);
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (method.equals(GET)) {
                this.getCB.setSelected(true);
                continue;
            }
            if (method.equals(PUT)) {
                this.putCB.setSelected(true);
                continue;
            }
            if (method.equals(HEAD)) {
                this.headCB.setSelected(true);
                continue;
            }
            if (method.equals(POST)) {
                this.postCB.setSelected(true);
                continue;
            }
            if (method.equals(TRACE)) {
                this.traceCB.setSelected(true);
                continue;
            }
            if (method.equals(DELETE)) {
                this.deleteCB.setSelected(true);
                continue;
            }
            if (!method.equals(OPTIONS)) continue;
            this.optionsCB.setSelected(true);
        }
        this.updateVisualState();
    }

    public String[] getSelectedHttpMethods() {
        if (this.allHttpMethodsRB.isSelected()) {
            return null;
        }
        if (this.subsetHttpMethodsRB.isSelected()) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.getCB.isSelected()) {
                list.add(GET);
            }
            if (this.putCB.isSelected()) {
                list.add(PUT);
            }
            if (this.headCB.isSelected()) {
                list.add(HEAD);
            }
            if (this.postCB.isSelected()) {
                list.add(POST);
            }
            if (this.optionsCB.isSelected()) {
                list.add(OPTIONS);
            }
            if (this.traceCB.isSelected()) {
                list.add(TRACE);
            }
            if (this.deleteCB.isSelected()) {
                list.add(DELETE);
            }
            String[] results = new String[list.size()];
            return list.toArray(results);
        }
        return new String[0];
    }

    private void updateVisualState() {
        if (this.subsetHttpMethodsRB.isSelected()) {
            this.getCB.setEnabled(true);
            this.putCB.setEnabled(true);
            this.headCB.setEnabled(true);
            this.postCB.setEnabled(true);
            this.optionsCB.setEnabled(true);
            this.traceCB.setEnabled(true);
            this.deleteCB.setEnabled(true);
        } else {
            this.getCB.setEnabled(false);
            this.putCB.setEnabled(false);
            this.headCB.setEnabled(false);
            this.postCB.setEnabled(false);
            this.optionsCB.setEnabled(false);
            this.traceCB.setEnabled(false);
            this.deleteCB.setEnabled(false);
        }
    }

    public JTextField getResourceNameTF() {
        return this.resourceNameTF;
    }

    public JTextField getDescriptionTF() {
        return this.descriptionTF;
    }

    public JTextField getUrlPatternsTF() {
        return this.urlPatternsTF;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.resourceNameLabel = new JLabel();
        this.resourceNameTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTF = new JTextField();
        this.urlPatternsLabel = new JLabel();
        this.urlPatternsTF = new JTextField();
        this.httpMethodLabel = new JLabel();
        this.getCB = new JCheckBox();
        this.postCB = new JCheckBox();
        this.headCB = new JCheckBox();
        this.putCB = new JCheckBox();
        this.optionsCB = new JCheckBox();
        this.traceCB = new JCheckBox();
        this.deleteCB = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.allHttpMethodsRB = new JRadioButton();
        this.subsetHttpMethodsRB = new JRadioButton();
        this.resourceNameLabel.setLabelFor(this.resourceNameTF);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.resourceNameLabel, (String)bundle.getString("LBL_WebResourceCollectionName"));
        this.descriptionLabel.setLabelFor(this.descriptionTF);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)bundle.getString("LBL_WebResourceCollectionDescription"));
        this.urlPatternsLabel.setLabelFor(this.urlPatternsTF);
        Mnemonics.setLocalizedText((JLabel)this.urlPatternsLabel, (String)bundle.getString("LBL_WebResourceCollectionUrlPatterns"));
        Mnemonics.setLocalizedText((JLabel)this.httpMethodLabel, (String)bundle.getString("LBL_WebResourceCollectionHttpMethods"));
        Mnemonics.setLocalizedText((AbstractButton)this.getCB, (String)bundle.getString("LBL_GET"));
        this.getCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getCB.setEnabled(false);
        this.getCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.postCB, (String)bundle.getString("LBL_POST"));
        this.postCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.postCB.setEnabled(false);
        this.postCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.headCB, (String)bundle.getString("LBL_HEAD"));
        this.headCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.headCB.setEnabled(false);
        this.headCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.putCB, (String)bundle.getString("LBL_PUT"));
        this.putCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.putCB.setEnabled(false);
        this.putCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.optionsCB, (String)bundle.getString("LBL_OPTIONS"));
        this.optionsCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optionsCB.setEnabled(false);
        this.optionsCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.traceCB, (String)bundle.getString("LBL_TRACE"));
        this.traceCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.traceCB.setEnabled(false);
        this.traceCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteCB, (String)bundle.getString("LBL_DELETE"));
        this.deleteCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.deleteCB.setEnabled(false);
        this.deleteCB.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)bundle.getString("HINT_urlPatterns"));
        this.buttonGroup1.add(this.allHttpMethodsRB);
        this.allHttpMethodsRB.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.allHttpMethodsRB, (String)bundle.getString("LBL_AllHttpMethods"));
        this.allHttpMethodsRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.allHttpMethodsRB.setMargin(new Insets(0, 0, 0, 0));
        this.allHttpMethodsRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebResourceCollectionPanel.this.allHttpMethodsRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.subsetHttpMethodsRB);
        Mnemonics.setLocalizedText((AbstractButton)this.subsetHttpMethodsRB, (String)bundle.getString("LBL_SubsetOfHttpMethods"));
        this.subsetHttpMethodsRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.subsetHttpMethodsRB.setMargin(new Insets(0, 0, 0, 0));
        this.subsetHttpMethodsRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebResourceCollectionPanel.this.subsetHttpMethodsRBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.resourceNameLabel).add((Component)this.descriptionLabel).add((Component)this.urlPatternsLabel).add((Component)this.httpMethodLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.urlPatternsTF, -1, 366, Short.MAX_VALUE).add((Component)this.descriptionTF, -1, 366, Short.MAX_VALUE).add((Component)this.resourceNameTF, -1, 366, Short.MAX_VALUE).add((Component)this.jLabel5).add((Component)this.allHttpMethodsRB).add((Component)this.subsetHttpMethodsRB).add((GroupLayout.Group)layout.createSequentialGroup().add(25, 25, 25).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.optionsCB).add((Component)this.getCB).add((Component)this.headCB).add((Component)this.deleteCB)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.postCB).add((Component)this.traceCB).add((Component)this.putCB)).add(163, 163, 163))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.resourceNameLabel).add((Component)this.resourceNameTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.descriptionTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.urlPatternsLabel).add((Component)this.urlPatternsTF, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.httpMethodLabel, -2, 14, -2).add((Component)this.allHttpMethodsRB)).addPreferredGap(0).add((Component)this.subsetHttpMethodsRB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.getCB).add((Component)this.postCB)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.headCB).add((Component)this.putCB, -2, 15, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.optionsCB).add((Component)this.traceCB)).addPreferredGap(0).add((Component)this.deleteCB).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void subsetHttpMethodsRBActionPerformed(ActionEvent evt) {
        this.updateVisualState();
    }

    private void allHttpMethodsRBActionPerformed(ActionEvent evt) {
        this.updateVisualState();
    }
}

