/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.util.EnumSet;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;
import org.openide.util.Parameters;

class QueryUtil {
    QueryUtil() {
    }

    static Query createUsagesQuery(@NonNull String resourceName, @NonNull Set<ClassIndexImpl.UsageType> mask, @NonNull BooleanClause.Occur operator) {
        Parameters.notNull((CharSequence)"resourceName", (Object)resourceName);
        Parameters.notNull((CharSequence)"mask", mask);
        Parameters.notNull((CharSequence)"operator", (Object)operator);
        if (operator == BooleanClause.Occur.SHOULD) {
            BooleanQuery query = new BooleanQuery();
            for (ClassIndexImpl.UsageType ut : mask) {
                WildcardQuery subQuery = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, EnumSet.of(ut)));
                query.add((Query)subQuery, operator);
            }
            return query;
        }
        if (operator == BooleanClause.Occur.MUST) {
            return new WildcardQuery(DocumentUtil.referencesTerm(resourceName, mask));
        }
        throw new IllegalArgumentException();
    }

    static Pair<StoppableConvertor<Term, String>, Term> createPackageFilter(@NullAllowed String prefix, boolean directOnly) {
        Term startTerm = new Term("packageName", prefix);
        PackageFilter filter = new PackageFilter(startTerm, directOnly);
        return Pair.of(filter, startTerm);
    }

    private static class PackageFilter
    implements StoppableConvertor<Term, String> {
        private static final StoppableConvertor.Stop STOP = new StoppableConvertor.Stop();
        private final boolean directOnly;
        private final boolean all;
        private final String fieldName;
        private final String value;

        PackageFilter(@NonNull Term startTerm, boolean directOnly) {
            this.fieldName = startTerm.field();
            this.value = startTerm.text();
            this.directOnly = directOnly;
            this.all = this.value.length() == 0;
        }

        public String convert(Term currentTerm) throws StoppableConvertor.Stop {
            if (this.fieldName != currentTerm.field()) {
                throw STOP;
            }
            String currentText = currentTerm.text();
            if (this.all || currentText.startsWith(this.value)) {
                int index;
                if (this.directOnly && (index = currentText.indexOf(46, this.value.length())) > 0) {
                    currentText = currentText.substring(0, index);
                }
                return currentText;
            }
            return null;
        }
    }
}

