/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.project.ui.J2EEProjectProperties;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebProjectUtilities {
    public static final String SRC_STRUCT_BLUEPRINTS = "BluePrints";
    public static final String SRC_STRUCT_JAKARTA = "Jakarta";
    private static final String DEFAULT_DOC_BASE_FOLDER = "web";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String WEB_INF = "WEB-INF";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";
    private static final Logger LOGGER = Logger.getLogger(WebProjectUtilities.class.getName());
    private static String RESOURCE_FOLDER = "/org/netbeans/modules/web/project/ui/resources/";

    private WebProjectUtilities() {
    }

    @Deprecated
    public static AntProjectHelper createProject(File file, String string, String string2, String string3, String string4, String string5) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(string);
        webProjectCreateData.setServerInstanceID(string2);
        webProjectCreateData.setSourceStructure(string3);
        webProjectCreateData.setJavaEEVersion(string4);
        webProjectCreateData.setContextPath(string5);
        return WebProjectUtilities.createProject(webProjectCreateData);
    }

    public static AntProjectHelper createProject(final WebProjectCreateData webProjectCreateData) throws IOException {
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        File file = webProjectCreateData.getProjectDir();
        assert (file != null) : "Project folder can't be null";
        final FileObject fileObject = FileUtil.createFolder((File)file);
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = WebProjectUtilities.createProjectImpl(webProjectCreateData, fileObject);
            }
        });
        return antProjectHelperArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AntProjectHelper createProjectImpl(final WebProjectCreateData webProjectCreateData, FileObject fileObject) throws IOException {
        Object object;
        FileLock fileLock;
        FileObject fileObject2;
        Object object2;
        String string = webProjectCreateData.getName();
        String string2 = webProjectCreateData.getServerInstanceID();
        String string3 = webProjectCreateData.getSourceStructure();
        Profile profile = webProjectCreateData.getJavaEEProfile();
        String string4 = webProjectCreateData.getContextPath();
        String string5 = webProjectCreateData.getJavaPlatformName();
        String string6 = webProjectCreateData.getSourceLevel();
        assert (string != null) : "Project name can't be null";
        assert (string2 != null) : "Server instance ID can't be null";
        assert (string3 != null) : "Source structure can't be null";
        assert (profile != null) : "Java EE version can't be null";
        boolean bl = SRC_STRUCT_BLUEPRINTS.equals(string3);
        boolean bl2 = SRC_STRUCT_JAKARTA.equals(string3);
        String string7 = WebProjectUtilities.configureServerLibrary(webProjectCreateData.getLibrariesDefinition(), string2, fileObject, webProjectCreateData.getServerLibraryName() != null);
        final AntProjectHelper antProjectHelper = WebProjectUtilities.setupProject(fileObject, string, string2, profile, webProjectCreateData.getLibrariesDefinition(), string7, webProjectCreateData.skipTests());
        FileObject fileObject3 = fileObject.createFolder(DEFAULT_SRC_FOLDER);
        FileObject fileObject4 = null;
        if (bl) {
            fileObject3.createFolder(DEFAULT_JAVA_FOLDER);
            fileObject4 = fileObject3.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (bl2) {
            fileObject4 = fileObject.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (fileObject4 != null) {
            object2 = WebProjectUtilities.readResource(WebProjectUtilities.class.getResourceAsStream(RESOURCE_FOLDER + "MANIFEST.MF"));
            fileObject2 = FileUtil.createData((FileObject)fileObject4, (String)"MANIFEST.MF");
            fileLock = fileObject2.lock();
            object = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
            try {
                ((Writer)object).write((String)object2);
            }
            finally {
                ((BufferedWriter)object).close();
                fileLock.releaseLock();
            }
        }
        if (!webProjectCreateData.skipTests()) {
            FileUtil.createFolder((FileObject)fileObject, (String)DEFAULT_TEST_FOLDER);
        }
        object2 = fileObject.createFolder(DEFAULT_DOC_BASE_FOLDER);
        fileObject2 = object2.createFolder(WEB_INF);
        DDHelper.createWebXml((Profile)profile, (boolean)webProjectCreateData.isWebXmlRequired(), (FileObject)fileObject2);
        if (webProjectCreateData.isCDIEnabled()) {
            DDHelper.createBeansXml((Profile)profile, (FileObject)fileObject2);
        }
        fileLock = antProjectHelper.getProperties("nbproject/project.properties");
        object = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = object.getOwnerDocument();
        Element element = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        element2.setAttribute("id", "src.dir");
        element2.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
        element.appendChild(element2);
        if (bl) {
            fileLock.setProperty("src.dir", "src/java");
        } else {
            fileLock.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        object.appendChild(element);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        element4.setAttribute("id", "test.src.dir");
        element4.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
        element3.appendChild(element4);
        fileLock.setProperty("test.src.dir", DEFAULT_TEST_FOLDER);
        object.appendChild(element3);
        antProjectHelper.putPrimaryConfigurationData((Element)object, true);
        fileLock.put("source.root", bl ? DEFAULT_SRC_FOLDER : ".");
        fileLock.setProperty("web.docbase.dir", DEFAULT_DOC_BASE_FOLDER);
        if (bl) {
            fileLock.setProperty("src.dir", "${source.root}/java");
            fileLock.setProperty("conf.dir", "${source.root}/conf");
        } else {
            fileLock.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        if (bl2) {
            fileLock.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        }
        fileLock.setProperty("persistence.xml.dir", "${conf.dir}");
        fileLock.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        fileLock.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
        fileLock.setProperty("webinf.dir", "web/WEB-INF");
        WebProject webProject = (WebProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        UpdateHelper updateHelper = webProject.getUpdateHelper();
        if (string6 == null) {
            string6 = "1.6";
        }
        PlatformUiSupport.storePlatform((EditableProperties)fileLock, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/web-project/3", (String)string5, (SpecificationVersion)new SpecificationVersion(string6));
        antProjectHelper.putProperties("nbproject/project.properties", (EditableProperties)fileLock);
        ProjectManager.getDefault().saveProject((Project)webProject);
        final ReferenceHelper referenceHelper = webProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    WebProjectUtilities.copyRequiredLibraries(antProjectHelper, referenceHelper, webProjectCreateData);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException.getException());
        }
        ProjectWebModule projectWebModule = (ProjectWebModule)webProject.getLookup().lookup(ProjectWebModule.class);
        if (projectWebModule != null) {
            projectWebModule.setContextPath(string4);
        }
        ProjectUtils.getSources((Project)webProject).getSourceGroups(DEFAULT_JAVA_FOLDER);
        return antProjectHelper;
    }

    public static Set<FileObject> ensureWelcomePage(FileObject fileObject, FileObject fileObject2) throws IOException {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        if (fileObject2 == null) {
            FileObject fileObject3 = WebProjectUtilities.createIndexJSP(fileObject);
            if (fileObject3 != null) {
                hashSet.add(fileObject3);
            }
            return hashSet;
        }
        try {
            FileObject fileObject4;
            WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject2);
            WelcomeFileList welcomeFileList = webApp.getSingleWelcomeFileList();
            if (welcomeFileList == null) {
                welcomeFileList = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                webApp.setWelcomeFileList(welcomeFileList);
            }
            if (welcomeFileList.sizeWelcomeFile() == 0 && (fileObject4 = WebProjectUtilities.createIndexJSP(fileObject)) != null) {
                hashSet.add(fileObject4);
                welcomeFileList.addWelcomeFile("index.jsp");
                webApp.write(fileObject2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return hashSet;
    }

    private static FileObject createIndexJSP(FileObject fileObject) throws IOException {
        FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/JSP_Servlet/JSP.jsp");
        if (fileObject2 == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, "index").getPrimaryFile();
    }

    @Deprecated
    public static AntProjectHelper importProject(File file, String string, FileObject fileObject, FileObject fileObject2, FileObject fileObject3, FileObject fileObject4, String string2, String string3, String string4) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(string);
        webProjectCreateData.setWebModuleFO(fileObject);
        webProjectCreateData.setSourceFolders(new File[]{FileUtil.toFile((FileObject)fileObject2)});
        webProjectCreateData.setTestFolders(null);
        webProjectCreateData.setDocBase(fileObject3);
        webProjectCreateData.setLibFolder(fileObject4);
        webProjectCreateData.setJavaEEVersion(string2);
        webProjectCreateData.setServerInstanceID(string3);
        webProjectCreateData.setBuildfile(string4);
        return WebProjectUtilities.importProject(webProjectCreateData);
    }

    @Deprecated
    public static AntProjectHelper importProject(File file, String string, FileObject fileObject, File[] fileArray, File[] fileArray2, FileObject fileObject2, FileObject fileObject3, String string2, String string3, String string4) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(string);
        webProjectCreateData.setWebModuleFO(fileObject);
        webProjectCreateData.setSourceFolders(fileArray);
        webProjectCreateData.setTestFolders(fileArray2);
        webProjectCreateData.setDocBase(fileObject2);
        webProjectCreateData.setLibFolder(fileObject3);
        webProjectCreateData.setJavaEEVersion(string2);
        webProjectCreateData.setServerInstanceID(string3);
        webProjectCreateData.setBuildfile(string4);
        return WebProjectUtilities.importProject(webProjectCreateData);
    }

    public static AntProjectHelper importProject(final WebProjectCreateData webProjectCreateData) throws IOException {
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        File file = webProjectCreateData.getProjectDir();
        assert (file != null) : "Project folder can't be null";
        final FileObject fileObject = FileUtil.createFolder((File)file);
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = WebProjectUtilities.importProjectImpl(webProjectCreateData, fileObject);
            }
        });
        return antProjectHelperArray[0];
    }

    private static AntProjectHelper importProjectImpl(final WebProjectCreateData webProjectCreateData, FileObject fileObject) throws IOException {
        int n;
        Object object;
        FileObject[] fileObjectArray;
        String string = webProjectCreateData.getName();
        FileObject fileObject2 = webProjectCreateData.getWebModuleFO();
        final File[] fileArray = webProjectCreateData.getSourceFolders();
        File[] fileArray2 = webProjectCreateData.getTestFolders();
        FileObject fileObject3 = webProjectCreateData.getDocBase();
        FileObject fileObject4 = webProjectCreateData.getLibFolder();
        Profile profile = webProjectCreateData.getJavaEEProfile();
        String string2 = webProjectCreateData.getServerInstanceID();
        String string3 = webProjectCreateData.getBuildfile();
        String string4 = webProjectCreateData.getJavaPlatformName();
        String string5 = webProjectCreateData.getSourceLevel();
        boolean bl = webProjectCreateData.getJavaSourceBased();
        FileObject fileObject5 = webProjectCreateData.getWebInfFolder();
        assert (string != null) : "Project name can't be null";
        assert (fileObject2 != null) : "File object representation of the imported web project location can't be null";
        assert (fileArray != null) : "Source package root can't be null";
        assert (fileObject3 != null) : "Web Pages folder can't be null";
        assert (string2 != null) : "Server instance ID can't be null";
        assert (profile != null) : "Java EE version can't be null";
        String string6 = WebProjectUtilities.configureServerLibrary(webProjectCreateData.getLibrariesDefinition(), string2, fileObject, webProjectCreateData.getServerLibraryName() != null);
        final AntProjectHelper antProjectHelper = WebProjectUtilities.setupProject(fileObject, string, string2, profile, webProjectCreateData.getLibrariesDefinition(), string6, webProjectCreateData.skipTests());
        final WebProject webProject = (WebProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        final ReferenceHelper referenceHelper = webProject.getReferenceHelper();
        EditableProperties editableProperties = new EditableProperties(true);
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject.equals(fileObject2)) {
            editableProperties.setProperty("source.root", ".");
        } else {
            editableProperties.setProperty("source.root", referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject2), null));
        }
        editableProperties.setProperty("web.docbase.dir", WebProjectUtilities.createFileReference(referenceHelper, fileObject, fileObject2, fileObject3));
        final File[] fileArray3 = fileArray2;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties editableProperties;
                    String string;
                    String string2;
                    int n;
                    Element element = antProjectHelper.getPrimaryConfigurationData(true);
                    Document document = element.getOwnerDocument();
                    Element element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    element.appendChild(element2);
                    Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    element.appendChild(element3);
                    NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    assert (nodeList.getLength() == 1);
                    element2 = (Element)nodeList.item(0);
                    nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    assert (nodeList.getLength() == 1);
                    element3 = (Element)nodeList.item(0);
                    for (n = 0; n < fileArray.length; ++n) {
                        string2 = "src.dir" + (n == 0 ? "" : Integer.toString(n + 1));
                        string = referenceHelper.createForeignFileReference(fileArray[n], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                        Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                        element4.setAttribute("id", string2);
                        element4.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
                        element2.appendChild(element4);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put(string2, string);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    if (fileArray3 == null || fileArray3.length == 0) {
                        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties2.put("test.src.dir", "");
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
                    } else {
                        for (n = 0; n < fileArray3.length; ++n) {
                            if (!fileArray3[n].exists()) {
                                FileUtil.createFolder((File)fileArray3[n]);
                            }
                            string2 = fileArray3[n].getName();
                            string = "test." + string2 + ".dir";
                            int n2 = 1;
                            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            while (editableProperties.containsKey((Object)string)) {
                                string = "test." + string2 + ++n2 + ".dir";
                            }
                            String string3 = referenceHelper.createForeignFileReference(fileArray3[n], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                            Element element5 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                            element5.setAttribute("id", string);
                            element5.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
                            element3.appendChild(element5);
                            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put(string, string3);
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        }
                    }
                    antProjectHelper.putPrimaryConfigurationData(element, true);
                    ProjectManager.getDefault().saveProject((Project)webProject);
                    WebProjectUtilities.copyRequiredLibraries(antProjectHelper, referenceHelper, webProjectCreateData);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            IOException iOException = new IOException("project creation failed");
            iOException.initCause(mutexException);
            throw iOException;
        }
        if (fileObject4 != null) {
            editableProperties.setProperty("lib.dir", WebProjectUtilities.createFileReference(referenceHelper, fileObject, fileObject2, fileObject4));
            if (fileObject4.isFolder()) {
                fileObjectArray = fileObject4.getChildren();
                object = new LinkedList();
                for (n = 0; n < fileObjectArray.length; ++n) {
                    if (!FileUtil.isArchiveFile((FileObject)fileObjectArray[n])) continue;
                    object.add(URLMapper.findURL((FileObject)FileUtil.getArchiveRoot((FileObject)fileObjectArray[n]), (int)1));
                }
                webProject.getClassPathModifier().addRoots(object.toArray(new URL[object.size()]), "javac.classpath");
            }
        }
        if (!"build.xml".equals(string3)) {
            editableProperties.setProperty("buildfile", string3);
        }
        fileObjectArray = FileSearchUtility.getChildrenToDepth((FileObject)fileObject, (int)4, (boolean)true);
        object = "";
        while (fileObjectArray.hasMoreElements()) {
            FileObject fileObject6 = (FileObject)fileObjectArray.nextElement();
            if (!fileObject6.isFolder() || !fileObject6.getName().equalsIgnoreCase(DEFAULT_CONF_FOLDER)) continue;
            object = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject6);
            break;
        }
        if (((String)object).equals("")) {
            fileObject.createFolder(DEFAULT_CONF_FOLDER);
            editableProperties.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        } else {
            editableProperties.setProperty("conf.dir", (String)object);
        }
        editableProperties.setProperty("persistence.xml.dir", "${conf.dir}");
        for (n = 0; n < fileArray.length; ++n) {
            if (!new File(fileArray[n], "META-INF" + File.separatorChar + "persistence.xml").exists()) continue;
            editableProperties.setProperty("persistence.xml.dir", "${src.dir}" + (n == 0 ? "" : Integer.toString(n + 1)) + "/META-INF");
            break;
        }
        editableProperties.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        String string7 = fileObject5 != null ? WebProjectUtilities.createFileReference(referenceHelper, fileObject, fileObject2, fileObject5) : "web/WEB-INF";
        editableProperties.setProperty("webinf.dir", string7);
        editableProperties.setProperty("java.source.based", bl + "");
        UpdateHelper updateHelper = webProject.getUpdateHelper();
        if (string5 != null && string5.equals("1.7")) {
            string5 = "1.6";
        }
        PlatformUiSupport.storePlatform((EditableProperties)editableProperties, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/web-project/3", (String)string4, (SpecificationVersion)(string5 != null ? new SpecificationVersion(string5) : null));
        Utils.updateProperties(antProjectHelper, "nbproject/project.properties", editableProperties);
        ProjectManager.getDefault().saveProject((Project)webProject);
        return antProjectHelper;
    }

    private static void copyRequiredLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, WebProjectCreateData webProjectCreateData) throws IOException {
        Profile profile;
        if (!antProjectHelper.isSharableProject()) {
            return;
        }
        if (!webProjectCreateData.skipTests() && referenceHelper.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (!webProjectCreateData.skipTests() && referenceHelper.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        if (((profile = webProjectCreateData.getJavaEEProfile()).equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB)) && referenceHelper.getProjectLibraryManager().getLibrary("javaee-endorsed-api-6.0") == null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("javaee-endorsed-api-6.0"));
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)antProjectHelper, (ReferenceHelper)referenceHelper);
    }

    private static String configureServerLibrary(final String string, final String string2, final FileObject fileObject, boolean bl) {
        String string3 = null;
        if (string != null && bl) {
            try {
                string3 = (String)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                    public String run() throws Exception {
                        return SharabilityUtility.findOrCreateLibrary((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)fileObject), (String)string), (String)string2).getName();
                    }
                });
            }
            catch (MutexException mutexException) {
                Exceptions.printStackTrace((Throwable)mutexException.getException());
            }
        }
        return string3;
    }

    private static String createFileReference(ReferenceHelper referenceHelper, FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject3)) {
            return WebProjectUtilities.relativePath(fileObject, fileObject3);
        }
        if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3)) {
            String string = WebProjectUtilities.relativePath(fileObject2, fileObject3);
            return string.length() > 0 ? "${source.root}/" + string : SOURCE_ROOT_REF;
        }
        return referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject3), null);
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException("Cannot find relative path, " + fileObject + " is not parent of " + fileObject2);
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject fileObject, String string, String string2, Profile profile, String string3, String string4, boolean bl) throws IOException {
        String[] stringArray;
        Utils.logUI(NbBundle.getBundle(WebProjectUtilities.class), "UI_WEB_PROJECT_CREATE_SHARABILITY", new Object[]{string3 != null, string4 != null});
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.web.project", (String)string3);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "minimum-ant-version");
        element3.appendChild(document.createTextNode(MINIMUM_ANT_VERSION));
        element.appendChild(element3);
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-libraries");
        element.appendChild(element4);
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-additional-libraries");
        element.appendChild(element5);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.setProperty("annotation.processing.enabled", "true");
        editableProperties.setProperty("annotation.processing.enabled.in.editor", "true");
        editableProperties.setProperty("annotation.processing.run.all.processors", "true");
        editableProperties.setProperty("annotation.processing.processors.list", "");
        editableProperties.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        editableProperties.setProperty("dist.dir", "dist");
        editableProperties.setProperty("dist.war", "${dist.dir}/${war.name}");
        editableProperties.setProperty("dist.ear.war", "${dist.dir}/${war.ear.name}");
        if (antProjectHelper.isSharableProject() && string4 != null) {
            editableProperties.setProperty("javac.classpath", "${libs." + string4 + "." + "classpath" + "}");
        } else {
            editableProperties.setProperty("javac.classpath", "");
        }
        J2EEProjectProperties.setServerProperties((EditableProperties)editableProperties, (EditableProperties)editableProperties2, (String)string4, null, null, (String)string2, (Profile)profile, (J2eeModule.Type)J2eeModule.Type.WAR);
        editableProperties.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        editableProperties.setProperty("javac.test.processorpath", new String[]{"${javac.test.classpath}"});
        editableProperties.setProperty("j2ee.platform", profile.toPropertiesString());
        editableProperties.setProperty("war.name", PropertyUtils.getUsablePropertyName((String)string) + ".war");
        editableProperties.setProperty("war.ear.name", PropertyUtils.getUsablePropertyName((String)string) + ".war");
        editableProperties.setProperty("jar.compress", "false");
        editableProperties.setProperty("war.content.additional", "");
        editableProperties.setProperty("client.urlPart", "");
        editableProperties.setProperty("display.browser", "true");
        editableProperties.setProperty("j2ee.compile.on.save", "true");
        editableProperties.setProperty("j2ee.deploy.on.save", DeployOnSaveUtils.isDeployOnSaveSupported((String)string2));
        editableProperties.setProperty("javac.debug", "true");
        editableProperties.setProperty("javac.deprecation", "false");
        editableProperties.setProperty("javac.compilerargs", "");
        editableProperties.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_javac.compilerargs")}, false);
        if (bl) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "${javac.classpath}:";
            stringArray = stringArray2;
            stringArray2[1] = "${build.classes.dir}";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "${javac.classpath}:";
            stringArray3[1] = "${build.classes.dir}:";
            stringArray3[2] = "${libs.junit.classpath}:";
            stringArray = stringArray3;
            stringArray3[3] = "${libs.junit_4.classpath}";
        }
        editableProperties.setProperty("javac.test.classpath", stringArray);
        editableProperties.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        editableProperties.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        editableProperties.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        editableProperties.setProperty("build.test.results.dir", "${build.dir}/test/results");
        editableProperties.setProperty("build.web.dir", "${build.dir}/web");
        editableProperties.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties.setProperty("build.classes.dir", "${build.web.dir}/WEB-INF/classes");
        editableProperties.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        editableProperties.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        editableProperties.setProperty("build.web.excludes", "${build.classes.excludes}");
        editableProperties.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        editableProperties.setProperty("no.dependencies", "false");
        editableProperties.setProperty("platform.active", "default_platform");
        editableProperties.setProperty("debug.classpath", Utils.getDefaultDebugClassPath());
        editableProperties.setProperty("runmain.jvmargs", "");
        editableProperties.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        editableProperties.setProperty("javadoc.private", "false");
        editableProperties.setProperty("javadoc.notree", "false");
        editableProperties.setProperty("javadoc.use", "true");
        editableProperties.setProperty("javadoc.nonavbar", "false");
        editableProperties.setProperty("javadoc.noindex", "false");
        editableProperties.setProperty("javadoc.splitindex", "true");
        editableProperties.setProperty("javadoc.author", "false");
        editableProperties.setProperty("javadoc.version", "false");
        editableProperties.setProperty("javadoc.windowtitle", "");
        editableProperties.setProperty("javadoc.encoding", "${source.encoding}");
        editableProperties.setProperty("javadoc.preview", "true");
        editableProperties.setProperty("javadoc.additionalparam", "");
        editableProperties.setProperty("compile.jsps", "false");
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        if (profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB)) {
            editableProperties.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-6.0.classpath}"});
        }
        J2EEProjectProperties.createDeploymentScript((FileObject)fileObject, (EditableProperties)editableProperties, (EditableProperties)editableProperties2, (String)string2, (J2eeModule.Type)J2eeModule.Type.WAR);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        return antProjectHelper;
    }

    public static void upgradeJ2EEProfile(WebProject webProject) {
        if (Profile.JAVA_EE_6_WEB.equals(webProject.getAPIEjbJar().getJ2eeProfile())) {
            Boolean bl = Boolean.FALSE;
            try {
                bl = (Boolean)webProject.getAPIEjbJar().getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Boolean>(){

                    public Boolean run(EjbJarMetadata ejbJarMetadata) {
                        EnterpriseBeans enterpriseBeans;
                        EjbJar ejbJar = ejbJarMetadata.getRoot();
                        if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
                            if (enterpriseBeans.getMessageDriven().length > 0 || enterpriseBeans.getEntity().length > 0) {
                                return Boolean.TRUE;
                            }
                            for (Session session : enterpriseBeans.getSession()) {
                                if (session.getRemote() == null) continue;
                                return Boolean.TRUE;
                            }
                        }
                        return Boolean.FALSE;
                    }
                }).get();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            if (bl.booleanValue() && Util.getSupportedProfiles((Project)webProject).contains(Profile.JAVA_EE_6_FULL)) {
                UpdateHelper updateHelper = webProject.getUpdateHelper();
                EditableProperties editableProperties = updateHelper.getProperties("nbproject/project.properties");
                editableProperties.setProperty("j2ee.platform", Profile.JAVA_EE_6_FULL.toPropertiesString());
                updateHelper.putProperties("nbproject/project.properties", editableProperties);
                try {
                    ProjectManager.getDefault().saveProject((Project)webProject);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResource(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
                string2 = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }
}

