/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.palette.PaletteItemDataNode;
import org.netbeans.modules.vmd.palette.PaletteKit;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class PaletteMap
implements ActiveDocumentSupport.Listener,
DescriptorRegistryListener,
PropertyChangeListener {
    private static final PaletteMap INSTANCE = new PaletteMap();
    private final WeakHashMap<String, WeakReference<PaletteKit>> kitMap = new WeakHashMap();
    private String activeProjectID;
    private DescriptorRegistry registeredRegistry;
    private final AtomicBoolean requiresPaletteUpdate = new AtomicBoolean(false);
    private final Set<String> registeredProjects = new HashSet<String>();
    private static RequestProcessor updateRP = new RequestProcessor("Update paletteKit");

    private PaletteMap() {
        ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this);
    }

    public static PaletteMap getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeDocumentChanged(DesignDocument deactivatedDocument, DesignDocument activatedDocument) {
        boolean isProjectIDChanged;
        String oldProjectID;
        if (activatedDocument == null) {
            return;
        }
        DescriptorRegistry currentRegistry = activatedDocument.getDescriptorRegistry();
        if (this.registeredRegistry != currentRegistry) {
            if (this.registeredRegistry != null) {
                this.registeredRegistry.removeRegistryListener((DescriptorRegistryListener)this);
            }
            this.registeredRegistry = currentRegistry;
            if (this.registeredRegistry != null) {
                this.registeredRegistry.addRegistryListener((DescriptorRegistryListener)this);
            }
        }
        PaletteMap paletteMap = this;
        synchronized (paletteMap) {
            oldProjectID = this.activeProjectID;
            this.activeProjectID = activatedDocument.getDocumentInterface().getProjectID();
        }
        boolean bl = isProjectIDChanged = !this.activeProjectID.equals(oldProjectID);
        if (isProjectIDChanged) {
            this.registerClassPathListener(activatedDocument);
        }
        this.updatePalette(activatedDocument, isProjectIDChanged);
    }

    public void activeComponentsChanged(Collection<DesignComponent> activeComponents) {
    }

    public void descriptorRegistryUpdated() {
        this.updatePalette(ActiveDocumentSupport.getDefault().getActiveDocument(), false);
    }

    private void updatePalette(DesignDocument document, boolean isProjectIDChanged) {
        if (isProjectIDChanged) {
            for (WeakReference<PaletteKit> kitReference : this.kitMap.values()) {
                PaletteKit kit = (PaletteKit)kitReference.get();
                if (kit == null) continue;
                kit.clearNodesStateCache();
            }
        }
        if (document == null) {
            return;
        }
        WeakReference<PaletteKit> kitReference = this.kitMap.get(document.getDocumentInterface().getProjectType());
        if (kitReference == null) {
            return;
        }
        PaletteKit kit = (PaletteKit)kitReference.get();
        if (kit == null) {
            return;
        }
        kit.setActiveDocument(document);
        if (isProjectIDChanged) {
            this.scheduleUpdateAfteCPScanned(document, kit);
        } else {
            kit.init();
        }
    }

    public synchronized PaletteKit getPaletteKitForProjectType(String projectType) {
        PaletteKit kit;
        WeakReference<PaletteKit> reference = this.kitMap.get(projectType);
        PaletteKit paletteKit = kit = reference != null ? (PaletteKit)reference.get() : null;
        if (kit == null) {
            kit = new PaletteKit(projectType);
            this.kitMap.put(projectType, new WeakReference<PaletteKit>(kit));
        }
        return kit;
    }

    void checkValidity(String projectType, Lookup lookup) {
        PaletteKit kit;
        WeakReference<PaletteKit> kitReference = this.kitMap.get(projectType);
        PaletteKit paletteKit = kit = kitReference != null ? (PaletteKit)kitReference.get() : null;
        if (kit == null) {
            PaletteItemDataNode node = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
            if (node != null) {
                node.setNeedCheck(false);
                node.setValid(true);
            }
        } else {
            kit.checkValidity(lookup);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.schedulePaletteUpdate();
    }

    private void scheduleUpdateAfteCPScanned(DesignDocument document, final PaletteKit kit) {
        Project project = org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)document);
        final ClasspathInfo info = this.getClasspathInfo(project);
        if (info == null) {
            return;
        }
        class UpdateTask
        implements Runnable,
        Task<CompilationController> {
            UpdateTask() {
            }

            @Override
            public void run() {
                try {
                    JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]).runWhenScanFinished((Task)this, true);
                }
                catch (IOException ex) {
                    Debug.warning((Object[])new Object[]{ex});
                }
            }

            public void run(CompilationController controller) throws Exception {
                kit.init();
            }
        }
        updateRP.post((Runnable)new UpdateTask());
    }

    private void registerClassPathListener(DesignDocument document) {
        Project project = org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)document);
        ClasspathInfo info = this.getClasspathInfo(project);
        if (info == null) {
            return;
        }
        String projID = document.getDocumentInterface().getProjectID();
        if (!this.registeredProjects.contains(projID)) {
            ListenerCancellableTask ct = new ListenerCancellableTask(info);
            try {
                JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]).runUserActionTask((Task)ct, true);
                this.registeredProjects.add(projID);
            }
            catch (IOException ex) {
                Debug.warning((Object[])new Object[]{ex});
            }
        }
    }

    private ClasspathInfo getClasspathInfo(Project project) {
        if (project == null) {
            return null;
        }
        SourceGroup group = this.getSourceGroup(project);
        if (group == null) {
            return null;
        }
        FileObject fileObject = group.getRootFolder();
        return ClasspathInfo.create((FileObject)fileObject);
    }

    private SourceGroup getSourceGroup(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups == null || sourceGroups.length < 1) {
            return null;
        }
        return sourceGroups[0];
    }

    private void schedulePaletteUpdate() {
        if (this.requiresPaletteUpdate.getAndSet(true)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (PaletteMap.this.requiresPaletteUpdate.getAndSet(false)) {
                    for (WeakReference kitReference : PaletteMap.this.kitMap.values()) {
                        PaletteKit kit = (PaletteKit)kitReference.get();
                        if (kit == null) continue;
                        kit.clearNodesStateCache();
                        kit.refreshPaletteController();
                    }
                }
            }
        });
    }

    private final class ListenerCancellableTask
    implements Task<CompilationController> {
        private ClasspathInfo info;

        public ListenerCancellableTask(ClasspathInfo info) {
            this.info = info;
        }

        public void run(CompilationController controller) throws Exception {
            ClassPath cp = this.info.getClassPath(ClasspathInfo.PathKind.BOOT);
            PropertyChangeListener wcl = WeakListeners.propertyChange((PropertyChangeListener)PaletteMap.this, (Object)cp);
            cp.addPropertyChangeListener(wcl);
        }
    }
}

