    /*
 * DateFieldBindingProvider.java
 *
 * Created on April 17, 2007, 8:41 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.databinding.lcdui;

import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import org.netbeans.microedition.databinding.DataBinder;

/**
 *
 * @author breh
 */
public class DateFieldBindingProvider extends ItemBindingProvider implements ItemCommandListener, ItemStateListener {
    
    
    private static final Command COMMIT_COMMAND = new Command("OK","OK",Command.OK,1);
    
    public static final String FEATURE_DATETIME = "dateTime";
    public static final String FEATURE_INPUTMODE = "inputMode";
    
    private FeatureInputDateTime featureInputDateTime;
    private DateField dateField;
    private String elPointer;
    
    public static final class FeatureInputDateTime {
        private Form parentForm;
        private Command commitCommand;

        
        public FeatureInputDateTime(String elExpression) {
            this(COMMIT_COMMAND);
        }
        
        
        public FeatureInputDateTime(Form parentForm) {
            this.parentForm = parentForm;
        }
        
        
        public FeatureInputDateTime(Command commitCommand) {
            this.commitCommand = commitCommand;
        }
        
    }
    
    /** Creates a new instance of DateFieldBindingProvider */
    public DateFieldBindingProvider() {
    }
    
    public void notifyBind(String elPointer, Object consumer, Object feature) {
        this.elPointer = elPointer;
        // install my ok command
        if ((consumer instanceof DateField)
        && (dateField == null) ) {
            dateField = (DateField)consumer;
            if (feature instanceof FeatureInputDateTime) {
                this.featureInputDateTime = (FeatureInputDateTime)feature;
                // install commit command
                if (featureInputDateTime.parentForm != null) {
                    featureInputDateTime.parentForm.setItemStateListener(this);
                } else if (featureInputDateTime.commitCommand != null) {
                    dateField.addCommand(featureInputDateTime.commitCommand);
                    dateField.setItemCommandListener(this);
                }
            }
        }
    }
    
    public void notifyUnbind(String elPointer, Object consumer, Object feature) {
        if (consumer == dateField) {
            if (featureInputDateTime.commitCommand != null) {
                // remove my commit command
                dateField.removeCommand(featureInputDateTime.commitCommand);
                dateField.setItemCommandListener(null);
            } else if (featureInputDateTime.parentForm != null) {
                featureInputDateTime.parentForm.setItemStateListener(null);
            }
        }
    }  
    

    public Object pullDataFromConsumer(String elPointer, Object consumer, Object feature) {
        if (consumer == dateField) {
            /*
            if (FEATURE_DATETIME.equals(FEATURE_DATETIME)) {
                return ((DateField)consumer).getDate();
            } else if (feature instanceof FeatureInputDateTime) { 
                
            } else {
                return null;
            }
            */
            return dateField.getDate();
        }
        // this is not exactly true !!! TODO
        return null;
    }

    public void pushDataToConsumer(String elPointer, Object consumer, Object feature, Object value) {
        //System.out.println("DateField push: "+feature+", "+value);
        if (consumer instanceof DateField) {
            DateField dateField = (DateField)consumer;
            if (FEATURE_DATETIME.equals(feature)) {
                updateDateField(value);
            } else if (feature instanceof FeatureInputDateTime) {
                updateDateField(value);
            } else if (FEATURE_INPUTMODE.equals(feature)) {
                if (value instanceof Integer) {
                    dateField.setInputMode(((Integer)value).intValue());
                }
            } else {
                super.pushDataToConsumer(elPointer, consumer,feature,value);
            }
        }
    }

    
    private void updateDateField(Object value) {
        if (value instanceof Date) {
            dateField.setDate((Date)value);
        } else if (value instanceof Long) {
            dateField.setDate(new Date(((Long)value).longValue()));
        } else if (value == null) {
            dateField.setDate(null);
        }
    }
    
    public void commandAction(Command command, Item item) {
        if ((item == dateField) && (command == COMMIT_COMMAND)) {
            // push the data to the binding
            if (featureInputDateTime != null) {
                DataBinder.updateDataSet(elPointer,this,dateField,featureInputDateTime);
            }
        }
    }

    public void itemStateChanged(Item item) {        
        if ((item == dateField) && (featureInputDateTime != null)) {
            DataBinder.updateDataSet(elPointer,this,dateField,featureInputDateTime);
        }        
    }
    
}
