/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */

/*
 * NewPIM.java
 *
 * Created on April 17, 2007, 4:48 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.databinding.pim;

import java.lang.IllegalArgumentException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.ToDo;
import javax.microedition.pim.ToDoList;
import org.netbeans.microedition.databinding.DataBinder;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;
import org.netbeans.microedition.databinding.IndexableDataSet;

/**
 *
 * @author Misk
 */
public class PIMDataSet implements DataSet {
    
    public static final String TODO     = "todo";
    public static final String CONTACT  = "contact";
    
    private ToDosDataSet todos;
    private ContactsDataSet contacts;
        
    /** Creates a new instance of NewPIM */
    public PIMDataSet() {
    }

    public Class getType( String dataItemName ) throws DataBindingException {
        return Object.class;
    }

    public Object getValue( String dataItemName ) throws DataBindingException {
        if( TODO.equals( dataItemName )) {
            if( todos == null ) 
                todos = new ToDosDataSet();
            return todos;
        } else if( CONTACT.equals( dataItemName )) {
            if( contacts == null ) contacts = new ContactsDataSet();
            return contacts;
        }
        throw new DataBindingException( "Invalid property name : " + dataItemName );
    }

    public void setValue( String dataItemName, Object value ) throws DataBindingException {
    }

    public void setAsString( String dataItemName, String value ) throws DataBindingException {
    }

    public boolean isReadOnly( String dataItemName ) throws DataBindingException {
        if( TODO.equals( dataItemName )) {
            return true;
        } else if( CONTACT.equals( dataItemName )) {
            return true;
        }
        throw new DataBindingException( "Invalid property name: " + dataItemName );
    }
        
    /**
     * Cretes new todo item in the todo list    
     * @param description of the todo
     */
    public static void createTodo( Date due, String summary, String note  ) {
        ToDoList todos = null;
        int count = 0;
        try {
            todos = (ToDoList) PIM.getInstance().openPIMList( PIM.TODO_LIST, PIM.READ_WRITE );

            ToDo todo = todos.createToDo();
            if( todos.isSupportedField( ToDo.DUE )) {
                todo.addDate( ToDo.DUE, todo.ATTR_NONE, due.getTime());
            }
            if( todos.isSupportedField( ToDo.SUMMARY )) {
                todo.addString( ToDo.SUMMARY, todo.ATTR_NONE, summary );
            }
            if( todos.isSupportedField( ToDo.NOTE )) {
                todo.addString( ToDo.NOTE, ToDo.ATTR_NONE, note );
            }
            todo.commit();
        } catch( PIMException ex ) {
            ex.printStackTrace();                
        } finally {
            if( todos != null ) {
                try { todos.close(); } catch( PIMException e ) {}
            }
        }
    }
}
