/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PrimitiveTypeArrayEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor {
    private Class valueType;
    private FormProperty formProperty;
    private static String ARR_BEGIN = "[";
    private static String ARR_END = "]";
    private static String NULL_STR = "null";
    private static String XML_PROP_NAME = "PropertyValue";
    private static String XML_ATT_NAME = "value";
    private char[] escChars = new char[]{'\t', '\b', '\n', '\r', '\f', '\'', '\"', '\\'};
    private String[] escCharsStr = new String[]{"\\t", "\\b", "\\n", "\\r", "\\f", "\\'", "\\\"", "\\\\"};

    private String[] splitCharArray(String body) {
        boolean reading = false;
        String tempVal = "";
        int prevChar = 32;
        int prevPrevChar = 32;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < body.length(); ++i) {
            char actChar = body.charAt(i);
            if (actChar == '\'' && prevChar != 92) {
                if (!reading) {
                    reading = true;
                    tempVal = "";
                } else {
                    reading = false;
                    list.add(tempVal);
                    tempVal = "";
                }
            } else if (actChar == '\'' && prevChar == 92 && prevPrevChar == 92) {
                reading = false;
                list.add(tempVal);
                tempVal = "";
            } else if (reading) {
                tempVal = tempVal + actChar;
            }
            prevPrevChar = prevChar;
            prevChar = actChar;
        }
        return list.toArray(new String[list.size()]);
    }

    private Object[] toCharObjectArray(Object array) {
        char[] source = (char[])array;
        Object[] result = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = this.convertChar2String(source[i]);
        }
        return result;
    }

    private String convertChar2String(char source) {
        for (int i = 0; i < this.escChars.length; ++i) {
            if (source != this.escChars[i]) continue;
            return "'" + this.escCharsStr[i] + "'";
        }
        return "'" + String.valueOf(source) + "'";
    }

    private char convertString2Char(String source) throws ParseException {
        if (source.length() > 1) {
            for (int i = 0; i < this.escCharsStr.length; ++i) {
                if (!source.equals(this.escCharsStr[i])) continue;
                return this.escChars[i];
            }
            throw new ParseException("", 0);
        }
        if (source.length() == 1) {
            return source.charAt(0);
        }
        throw new ParseException("", 0);
    }

    private String arr2Text(Object[] arr, boolean justContent) {
        StringBuilder strBuild = new StringBuilder();
        if (!justContent) {
            strBuild.append(ARR_BEGIN);
        }
        for (int i = 0; i < arr.length; ++i) {
            Object act = arr[i];
            strBuild.append(act);
            if (justContent && this.valueType.equals(float[].class)) {
                strBuild.append("f");
            }
            if (i == arr.length - 1) continue;
            strBuild.append(", ");
        }
        if (!justContent) {
            strBuild.append(ARR_END);
        }
        return strBuild.toString();
    }

    private Object text2Arr(String text) throws ParseException {
        int i;
        String[] parts;
        String trimText = text.trim();
        if (trimText.length() == 0 || trimText.toLowerCase().equals(NULL_STR)) {
            return null;
        }
        if (text.length() < 2) {
            parts = new String[]{};
        } else {
            int arrEndPos;
            int arrBeginPos = text.indexOf(ARR_BEGIN);
            if (arrBeginPos + 1 < (arrEndPos = text.indexOf(ARR_END))) {
                String body = text.substring(text.indexOf(ARR_BEGIN) + 1, text.indexOf(ARR_END));
                parts = !this.valueType.equals(char[].class) ? body.split(",") : this.splitCharArray(body);
            } else {
                parts = new String[]{};
            }
        }
        if (this.valueType.equals(boolean[].class)) {
            boolean[] result = new boolean[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Boolean.parseBoolean(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(byte[].class)) {
            byte[] result = new byte[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Byte.parseByte(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(short[].class)) {
            short[] result = new short[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Short.parseShort(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(int[].class)) {
            int[] result = new int[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Integer.parseInt(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(long[].class)) {
            long[] result = new long[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Long.parseLong(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(float[].class)) {
            float[] result = new float[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Float.parseFloat(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(double[].class)) {
            double[] result = new double[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = Double.parseDouble(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(char[].class)) {
            char[] result = new char[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = this.convertString2Char(parts[i]);
            }
            return result;
        }
        return null;
    }

    @Override
    public String getAsText() {
        if (this.getValue() != null) {
            Object[] result = new Object[]{};
            result = this.valueType.equals(char[].class) ? this.toCharObjectArray(this.getValue()) : Utilities.toObjectArray((Object)this.getValue());
            return this.arr2Text(result, false);
        }
        return NULL_STR;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(this.text2Arr(text));
        }
        catch (Exception e) {
            String msg = NbBundle.getBundle(PrimitiveTypeArrayEditor.class).getString("MSG_ERR_ParseError");
            throw new IllegalArgumentException(String.format(msg, text, this.valueType.getSimpleName()), e);
        }
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.valueType = property.getValueType();
        this.formProperty = property;
    }

    @Override
    public void updateFormVersionLevel() {
        this.formProperty.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB65, FormModel.FormVersion.NB65);
    }

    @Override
    public String getJavaInitializationString() {
        Object[] valObj = this.valueType.equals(char[].class) ? this.toCharObjectArray(this.getValue()) : Utilities.toObjectArray((Object)this.getValue());
        return "new " + this.valueType.getSimpleName() + " {" + this.arr2Text(valObj, true) + "}";
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_PROP_NAME.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String value = attributes.getNamedItem(XML_ATT_NAME).getNodeValue();
            this.setAsText(value);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_PROP_NAME);
        el.setAttribute(XML_ATT_NAME, this.getAsText());
        return el;
    }
}

