/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormOthersNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AddAction;
import org.netbeans.modules.form.actions.ReloadAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

class FormRootNode
extends FormNode {
    private Node.Property[] codeGenProperties;
    private Node.Property[] resourceProperties;
    private Node.Property[] allProperties;

    public FormRootNode(FormModel formModel) {
        super((Children)new RootChildren(formModel), formModel);
        this.setName("Form Root Node");
        this.setIconBaseWithExtension("org/netbeans/modules/form/resources/formDesigner.gif");
        this.updateName(formModel.getName());
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    @Override
    public Action[] getActions(boolean context) {
        if (this.actions == null) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (this.isModifiableContainer()) {
                l.add(SystemAction.get(AddAction.class));
                l.add(null);
                l.add(SystemAction.get(PasteAction.class));
                l.add(null);
                l.add(SystemAction.get(ReorderAction.class));
                l.add(null);
            }
            l.add(SystemAction.get(ReloadAction.class));
            l.add(null);
            for (Action a : super.getActions(context)) {
                l.add(a);
            }
            this.actions = l.toArray(new Action[l.size()]);
        }
        return this.actions;
    }

    void updateName(String name) {
        this.setDisplayName(FormUtils.getFormattedBundleString("FMT_FormNodeName", new Object[]{name}));
    }

    FormOthersNode getOthersNode() {
        return ((RootChildren)this.getChildren()).othersNode;
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet codeSet = new Node.PropertySet("codeGeneration", FormUtils.getBundleString("CTL_SyntheticTab"), FormUtils.getBundleString("CTL_SyntheticTabHint")){

            public Node.Property[] getProperties() {
                return FormRootNode.this.getCodeGenProperties();
            }
        };
        Node.PropertySet resourceSet = new Node.PropertySet("resources", FormUtils.getBundleString("CTL_ResourceTab"), FormUtils.getBundleString("CTL_ResourceTabHint")){

            public Node.Property[] getProperties() {
                return FormRootNode.this.getResourceProperties();
            }
        };
        return new Node.PropertySet[]{codeSet, resourceSet};
    }

    Node.Property[] getCodeGenProperties() {
        if (this.codeGenProperties == null) {
            this.codeGenProperties = this.createCodeGenProperties();
        }
        return this.codeGenProperties;
    }

    private Node.Property[] createCodeGenProperties() {
        return FormEditor.getCodeGenerator(this.getFormModel()).getSyntheticProperties(null);
    }

    Node.Property[] getResourceProperties() {
        if (this.resourceProperties == null) {
            this.resourceProperties = this.createResourceProperties();
        }
        return this.resourceProperties;
    }

    private Node.Property[] createResourceProperties() {
        return FormEditor.getResourceSupport(this.getFormModel()).createFormProperties();
    }

    Node.Property[] getAllProperties() {
        if (this.allProperties == null) {
            int codeGenCount = this.getCodeGenProperties().length;
            int resCount = this.getResourceProperties().length;
            this.allProperties = new Node.Property[codeGenCount + resCount];
            System.arraycopy(this.codeGenProperties, 0, this.allProperties, 0, codeGenCount);
            System.arraycopy(this.resourceProperties, 0, this.allProperties, codeGenCount, resCount);
        }
        return this.allProperties;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        if (this.isModifiableContainer()) {
            CopySupport.createPasteTypes(t, s, this.getFormModel(), null);
        }
    }

    private boolean isModifiableContainer() {
        return !this.getFormModel().isReadOnly() && !FormRootNode.shouldHaveOthersNode(this.getFormModel());
    }

    private static boolean shouldHaveOthersNode(FormModel formModel) {
        return formModel.getTopRADComponent() instanceof RADVisualContainer;
    }

    static class RootChildren
    extends FormNode.FormNodeChildren {
        static final Object OTHERS_ROOT = new Object();
        private FormModel formModel;
        private FormOthersNode othersNode;

        protected RootChildren(FormModel formModel) {
            this.formModel = formModel;
            this.updateKeys();
        }

        @Override
        protected void updateKeys() {
            RADComponent rootComp;
            this.othersNode = null;
            LinkedList<Object> keys = new LinkedList<Object>();
            boolean otherComps = FormRootNode.shouldHaveOthersNode(this.formModel);
            if (otherComps) {
                keys.add(OTHERS_ROOT);
            }
            if ((rootComp = this.formModel.getTopRADComponent()) != null) {
                keys.add(rootComp);
            }
            if (!otherComps) {
                keys.addAll(this.formModel.getOtherComponents());
            }
            this.setKeys(keys.toArray());
        }

        protected Node[] createNodes(Object key) {
            FormNode node;
            if (key == OTHERS_ROOT) {
                this.othersNode = new FormOthersNode(this.formModel);
                node = this.othersNode;
            } else {
                node = new RADComponentNode((RADComponent)key);
            }
            node.getChildren().getNodes();
            return new Node[]{node};
        }

        protected final FormModel getFormModel() {
            return this.formModel;
        }
    }
}

