/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Position;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.openide.filesystems.FileObject;

public class FormJavaSource {
    private final FormDataObject formDataObject;
    private List<String> fields = null;
    private static final String[] PROPERTY_PREFIXES = new String[]{"get", "is"};

    public FormJavaSource(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    public void refresh() {
        this.fields = Collections.emptyList();
        this.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.PARSED);
                FormJavaSource.this.fields = FormJavaSource.this.getFieldNames(controller);
            }
        });
    }

    private void runUserActionTask(CancellableTask<CompilationController> task) {
        FileObject javaFileObject = this.formDataObject.getPrimaryFile();
        JavaSource js = JavaSource.forFileObject((FileObject)javaFileObject);
        if (js != null) {
            try {
                js.runUserActionTask(task, true);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void runModificationTask(CancellableTask<WorkingCopy> task) {
        FileObject javaFileObject = this.formDataObject.getPrimaryFile();
        JavaSource js = JavaSource.forFileObject((FileObject)javaFileObject);
        if (js != null) {
            try {
                js.runModificationTask(task).commit();
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean containsField(String name, boolean refresh) {
        if (refresh) {
            this.refresh();
        }
        return this.fields != null && this.fields.contains(name);
    }

    private ClassTree findClassTree(CompilationController controller) {
        String fileName = this.formDataObject.getPrimaryFile().getName();
        for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !fileName.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            return (ClassTree)tree;
        }
        return null;
    }

    private static TypeKind primitiveClassToTypeKind(Class clazz) {
        TypeKind kind = null;
        if (clazz == Character.TYPE) {
            kind = TypeKind.CHAR;
        } else if (clazz == Boolean.TYPE) {
            kind = TypeKind.BOOLEAN;
        } else if (clazz == Integer.TYPE) {
            kind = TypeKind.INT;
        } else if (clazz == Long.TYPE) {
            kind = TypeKind.LONG;
        } else if (clazz == Byte.TYPE) {
            kind = TypeKind.BYTE;
        } else if (clazz == Short.TYPE) {
            kind = TypeKind.SHORT;
        } else if (clazz == Float.TYPE) {
            kind = TypeKind.FLOAT;
        } else if (clazz == Double.TYPE) {
            kind = TypeKind.DOUBLE;
        }
        return kind;
    }

    private TypeMirror clazzToTypeMirror(CompilationController controller, Class clazz) {
        TypeMirror type;
        if (clazz.isPrimitive()) {
            TypeKind kind = FormJavaSource.primitiveClassToTypeKind(clazz);
            type = controller.getTypes().getPrimitiveType(kind);
        } else if (clazz.isArray()) {
            type = this.clazzToTypeMirror(controller, clazz.getComponentType());
            type = controller.getTypes().getArrayType(type);
        } else {
            String returnTypeName = clazz.getCanonicalName();
            TypeElement returnTypeElm = controller.getElements().getTypeElement(returnTypeName);
            type = returnTypeElm.asType();
        }
        return type;
    }

    private List<String> findMethodsByReturnType(CompilationController controller, TypeElement celem, Class returnType) {
        ArrayList<String> methods = new ArrayList<String>();
        TypeMirror type = this.clazzToTypeMirror(controller, returnType);
        for (Element element : celem.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            TypeMirror methodRT = method.getReturnType();
            if (!controller.getTypes().isAssignable(type, methodRT)) continue;
            methods.add(method.getSimpleName().toString());
        }
        return methods;
    }

    public String[] getMethodNames(final Class returnType) {
        final Object[] result = new Object[1];
        this.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree ct = FormJavaSource.this.findClassTree(controller);
                if (ct != null) {
                    TreePath cpath = controller.getTrees().getPath(controller.getCompilationUnit(), ct);
                    TypeElement celem = (TypeElement)controller.getTrees().getElement(cpath);
                    List names = FormJavaSource.this.findMethodsByReturnType(controller, celem, returnType);
                    result[0] = FormJavaSource.toArray(names);
                }
            }
        });
        return result[0] == null ? new String[]{} : (String[])result[0];
    }

    public String getAnnotationCode(final String methodName, final Position startPosition, final Position endPosition, final boolean removeAnnotations) {
        final StringBuilder sb = new StringBuilder();
        this.runModificationTask(new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy wc) throws Exception {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree ct = FormJavaSource.this.findClassTree((CompilationController)wc);
                int start = startPosition.getOffset();
                int end = endPosition.getOffset();
                if (ct != null) {
                    SourcePositions sp = wc.getTrees().getSourcePositions();
                    for (Tree tree : ct.getMembers()) {
                        MethodTree method;
                        if (Tree.Kind.METHOD != tree.getKind() || !methodName.equals((method = (MethodTree)tree).getName().toString())) continue;
                        long methodStart = sp.getStartPosition(wc.getCompilationUnit(), method);
                        long methodEnd = sp.getEndPosition(wc.getCompilationUnit(), method);
                        if (methodStart <= (long)end && (long)start <= methodEnd) {
                            for (AnnotationTree annotationTree : method.getModifiers().getAnnotations()) {
                                sb.append(annotationTree.toString()).append('\n');
                            }
                        }
                        if (!removeAnnotations) continue;
                        ModifiersTree oldModifiers = method.getModifiers();
                        TreeMaker treeMaker = wc.getTreeMaker();
                        ModifiersTree newModifiers = treeMaker.Modifiers(oldModifiers.getFlags());
                        wc.rewrite((Tree)oldModifiers, (Tree)newModifiers);
                    }
                }
            }
        });
        return sb.length() == 0 ? null : sb.toString();
    }

    public String[] getPropertyReadMethodNames(Class returnType) {
        String[] names = this.getMethodNames(returnType);
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (String name : names) {
            if (FormJavaSource.extractPropertyName(name).equals("")) continue;
            result.add(name);
        }
        return FormJavaSource.toArray(result);
    }

    public static String extractPropertyName(String methodName) {
        for (int i = 0; i < PROPERTY_PREFIXES.length; ++i) {
            if (!methodName.startsWith(PROPERTY_PREFIXES[i]) || methodName.length() <= PROPERTY_PREFIXES[i].length()) continue;
            return Introspector.decapitalize(methodName.substring(PROPERTY_PREFIXES[i].length()));
        }
        return "";
    }

    private List<String> getFieldNames(final CompilationController controller) {
        SimpleSection variablesSection = this.formDataObject.getFormEditorSupport().getVariablesSection();
        if (variablesSection == null) {
            return null;
        }
        final int genVariablesStartOffset = variablesSection.getStartPosition().getOffset();
        final int genVariablesEndOffset = variablesSection.getEndPosition().getOffset();
        final SourcePositions positions = controller.getTrees().getSourcePositions();
        TreeScanner<Void, List<String>> scan = new TreeScanner<Void, List<String>>(){

            @Override
            public Void visitClass(ClassTree node, List<String> p) {
                long startOffset = positions.getStartPosition(controller.getCompilationUnit(), node);
                long endOffset = positions.getEndPosition(controller.getCompilationUnit(), node);
                if ((long)genVariablesStartOffset > startOffset && (long)genVariablesEndOffset < endOffset) {
                    for (Tree tree : node.getMembers()) {
                        if (tree.getKind() != Tree.Kind.VARIABLE) continue;
                        this.testVariable((VariableTree)tree, p);
                    }
                }
                return null;
            }

            private void testVariable(VariableTree node, List<String> p) {
                long startOffset = positions.getStartPosition(controller.getCompilationUnit(), node);
                if (startOffset >= (long)genVariablesEndOffset || startOffset <= (long)genVariablesStartOffset) {
                    p.add(node.getName().toString());
                }
            }
        };
        ArrayList<String> fieldNames = new ArrayList<String>();
        scan.scan(controller.getCompilationUnit(), fieldNames);
        return fieldNames;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static boolean isInDefaultPackage(FormModel formModel) {
        FileObject fdo = FormEditor.getFormDataObject(formModel).getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)fdo, (String)"classpath/source");
        String name = cp.getResourceName(fdo);
        return name.indexOf(47) < 0;
    }
}

