/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.DefaultRADAction;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormOthersNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EditFormAction;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;

public class FormEditor {
    static final int LOADING = 1;
    static final int SAVING = 2;
    private FormModel formModel;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private CodeGenerator codeGenerator;
    private FormJavaSource formJavaSource;
    private ResourceSupport resourceSupport;
    private BindingDesignSupport bindingSupport;
    private List<Throwable> persistenceErrors;
    private PersistenceManager persistenceManager;
    private boolean formLoaded = false;
    private static Map<FormModel, FormEditor> openForms = new Hashtable<FormModel, FormEditor>();
    private static Map<FormModel, AssistantModel> formModelToAssistant = new WeakHashMap<FormModel, AssistantModel>();
    private List<Window> floatingWindows;
    private FormDataObject formDataObject;
    private PropertyChangeListener dataObjectListener;
    private static PreferenceChangeListener settingsListener;
    private PropertyChangeListener paletteListener;
    private FormModelListener formListener;
    private List<Action> defaultActions;
    private boolean upgradeCheckPosted;

    FormEditor(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    public final FormNode getFormRootNode() {
        return this.formRootNode;
    }

    public final FormNode getOthersContainerNode() {
        FormOthersNode othersNode = this.formRootNode.getOthersNode();
        return othersNode != null ? othersNode : this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    private final FormJavaSource getFormJavaSource() {
        return this.formJavaSource;
    }

    CodeGenerator getCodeGenerator() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.codeGenerator == null) {
            this.codeGenerator = new JavaCodeGenerator();
        }
        return this.codeGenerator;
    }

    ResourceSupport getResourceSupport() {
        if (this.resourceSupport == null && this.formModel != null) {
            this.resourceSupport = new ResourceSupport(this.formModel);
            this.resourceSupport.init();
        }
        return this.resourceSupport;
    }

    BindingDesignSupport getBindingSupport() {
        if (this.bindingSupport == null && this.formModel != null) {
            this.bindingSupport = new BindingDesignSupport(this.formModel);
        }
        return this.bindingSupport;
    }

    void setPersistenceManager(PersistenceManager pm) {
        this.persistenceManager = pm;
    }

    boolean isFormLoaded() {
        return this.formLoaded;
    }

    void loadFormDesigner() {
        block2: {
            this.getFormDataObject().getFormEditorSupport().showOpeningStatus("FMT_OpeningForm");
            this.preCreationUpdate();
            try {
                this.loadFormData();
            }
            catch (PersistenceException ex) {
                this.logPersistenceError(ex, 0);
                if (this.formLoaded) break block2;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormEditor.this.getFormDataObject().getFormEditorSupport().selectJavaEditor();
                    }
                });
            }
        }
        this.getFormDataObject().getFormEditorSupport().hideOpeningStatus();
        this.reportErrors(1);
        this.postCreationUpdate();
    }

    boolean loadForm() {
        if (this.formLoaded) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.loadFormData();
            }
            catch (PersistenceException ex) {
                this.logPersistenceError(ex, 0);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FormEditor.this.loadFormData();
                        }
                        catch (PersistenceException ex) {
                            FormEditor.this.logPersistenceError(ex, 0);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.formLoaded;
    }

    private void loadFormData() throws PersistenceException {
        FileObject projectDirectory;
        FileObject nbprojectFolder;
        if (this.formLoaded) {
            return;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.formDataObject.getFormFile());
        if (p != null && (nbprojectFolder = (projectDirectory = p.getProjectDirectory()).getFileObject("nbproject", null)) == null && projectDirectory.getFileObject("pom", "xml") != null) {
            ClassPathUtils.resetFormClassLoader(p);
        }
        this.resetPersistenceErrorLog();
        if (this.persistenceManager == null) {
            this.persistenceManager = this.recognizeForm(this.formDataObject);
        }
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        this.formJavaSource = new FormJavaSource(this.formDataObject);
        this.formModel.getCodeStructure().setFormJavaSource(this.formJavaSource);
        openForms.put(this.formModel, this);
        Logger.getLogger("TIMER").log(Level.FINE, "FormModel", new Object[]{this.formDataObject.getPrimaryFile(), this.formModel});
        this.formModel.getSettings().getAutoSetComponentName();
        try {
            FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    FormEditor.this.persistenceManager.loadForm(FormEditor.this.formDataObject, FormEditor.this.formModel, FormEditor.this.persistenceErrors);
                    return null;
                }
            });
        }
        catch (PersistenceException ex) {
            this.persistenceManager = null;
            openForms.remove(this.formModel);
            this.formModel = null;
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.persistenceManager = null;
            openForms.remove(this.formModel);
            this.formModel = null;
            return;
        }
        this.formLoaded = true;
        this.getCodeGenerator().initialize(this.formModel);
        ResourceSupport resupport = this.getResourceSupport();
        if (resupport.getDesignLocale() != null) {
            resupport.updateDesignLocale();
        }
        this.getBindingSupport();
        this.formModel.fireFormLoaded();
        if (this.formModel.wasCorrected()) {
            this.formModel.fireFormChanged(false);
        }
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.formDataObject.getNodeDelegate().getChildren().add(new Node[]{this.formRootNode});
        this.attachFormListener();
        this.attachDataObjectListener();
        FormEditor.attachSettingsListener();
        this.attachPaletteListener();
    }

    public boolean saveForm() {
        try {
            this.saveFormData();
            return true;
        }
        catch (PersistenceException ex) {
            this.logPersistenceError(ex, 0);
            return false;
        }
    }

    void saveFormData() throws PersistenceException {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly() && !this.formModel.isReadOnly()) {
            this.formModel.fireFormToBeSaved();
            this.resetPersistenceErrorLog();
            this.persistenceManager.saveForm(this.formDataObject, this.formModel, this.persistenceErrors);
        }
    }

    private void resetPersistenceErrorLog() {
        if (this.persistenceErrors != null) {
            this.persistenceErrors.clear();
        } else {
            this.persistenceErrors = new ArrayList<Throwable>();
        }
    }

    private void logPersistenceError(Throwable t, int index) {
        if (this.persistenceErrors == null) {
            this.persistenceErrors = new ArrayList<Throwable>();
        }
        if (index < 0) {
            this.persistenceErrors.add(t);
        } else {
            this.persistenceErrors.add(index, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManager recognizeForm(FormDataObject formDO) throws PersistenceException {
        PersistenceException ex;
        Iterator<PersistenceManager> it = PersistenceManager.getManagers();
        if (!it.hasNext()) {
            PersistenceException ex2 = new PersistenceException("No persistence manager registered");
            ErrorManager.getDefault().annotate((Throwable)ex2, 65536, null, FormUtils.getBundleString("MSG_ERR_NoPersistenceManager"), null, null);
            throw ex2;
        }
        do {
            PersistenceManager pm;
            PersistenceManager persistenceManager = pm = it.next();
            synchronized (persistenceManager) {
                try {
                    if (pm.canLoadForm(formDO)) {
                        this.resetPersistenceErrorLog();
                        return pm;
                    }
                }
                catch (PersistenceException ex3) {
                    this.logPersistenceError(ex3);
                }
            }
        } while (it.hasNext());
        if (!this.anyPersistenceError()) {
            ex = new PersistenceException("Form file format not recognized");
            ErrorManager.getDefault().annotate((Throwable)ex, 65536, null, FormUtils.getBundleString("MSG_ERR_NotRecognizedForm"), null, null);
        } else {
            Throwable annotateT = null;
            int n = this.persistenceErrors.size();
            if (n == 1) {
                ex = (PersistenceException)this.persistenceErrors.get(0);
                Throwable t = ex.getOriginalException();
                annotateT = t != null ? t : ex;
                n = 0;
            } else {
                annotateT = ex = new PersistenceException("Form file cannot be loaded");
            }
            ErrorManager.getDefault().annotate(annotateT, FormUtils.getBundleString("MSG_ERR_LoadingErrors"));
            for (int i = 0; i < n; ++i) {
                PersistenceException pe = (PersistenceException)this.persistenceErrors.get(i);
                Throwable t = pe.getOriginalException();
                ErrorManager.getDefault().annotate((Throwable)ex, t != null ? t : pe);
            }
            this.resetPersistenceErrorLog();
        }
        throw ex;
    }

    private void logPersistenceError(Throwable t) {
        this.logPersistenceError(t, -1);
    }

    boolean anyPersistenceError() {
        return this.persistenceErrors != null && !this.persistenceErrors.isEmpty();
    }

    public void reportErrors(int operation) {
        if (!this.anyPersistenceError()) {
            return;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        GandalfPersistenceManager persistManager = (GandalfPersistenceManager)this.persistenceManager;
        boolean checkLoadingErrors = operation == 1 && this.formLoaded;
        boolean anyNonFatalLoadingError = false;
        StringBuilder userErrorMsgs = new StringBuilder();
        for (Throwable t : this.persistenceErrors) {
            Throwable th;
            if (t instanceof PersistenceException && (th = ((PersistenceException)t).getOriginalException()) != null) {
                t = th;
            }
            if (checkLoadingErrors && !anyNonFatalLoadingError) {
                ErrorManager.Annotation[] annotations = errorManager.findAnnotations(t);
                int severity = 0;
                if (annotations != null && annotations.length != 0) {
                    for (int i = 0; i < annotations.length; ++i) {
                        int s = annotations[i].getSeverity();
                        if (s == 0) {
                            s = 4096;
                        }
                        if (s <= severity) continue;
                        severity = s;
                    }
                } else {
                    severity = 4096;
                }
                if (severity > 16) {
                    anyNonFatalLoadingError = true;
                }
            }
            errorManager.notify(1, t);
            if (persistManager != null) {
                userErrorMsgs.append(persistManager.getExceptionAnnotation(t));
                userErrorMsgs.append("\n\n");
                continue;
            }
            errorManager.notify(16, t);
        }
        if (checkLoadingErrors && anyNonFatalLoadingError) {
            final String wholeMsg = userErrorMsgs.append(FormUtils.getBundleString("MSG_FormLoadedWithErrors")).toString();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!FormEditor.this.isFormLoaded()) {
                        return;
                    }
                    JButton viewOnly = new JButton(FormUtils.getBundleString("CTL_ViewOnly"));
                    JButton allowEditing = new JButton(FormUtils.getBundleString("CTL_AllowEditing"));
                    Object ret = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)wholeMsg, FormUtils.getBundleString("CTL_FormLoadedWithErrors"), -1, 2, new Object[]{viewOnly, allowEditing, NotifyDescriptor.CANCEL_OPTION}, (Object)viewOnly));
                    if (ret == viewOnly) {
                        FormEditor.this.setFormReadOnly();
                    } else if (ret == allowEditing) {
                        FormEditor.this.destroyInvalidComponents();
                    } else {
                        FormEditor.this.getFormDesigner().reset(FormEditor.this);
                        FormEditor.this.closeForm();
                        FormEditor.this.getFormDataObject().getFormEditorSupport().selectJavaEditor();
                    }
                }
            });
        }
        this.resetPersistenceErrorLog();
    }

    private void destroyInvalidComponents() {
        Collection<RADComponent> allComps = this.formModel.getAllComponents();
        ArrayList<RADComponent> invalidComponents = new ArrayList<RADComponent>(allComps.size());
        for (RADComponent comp : allComps) {
            if (comp.isValid()) continue;
            invalidComponents.add(comp);
        }
        for (RADComponent comp : invalidComponents) {
            try {
                RADComponentNode node = comp.getNodeReference();
                if (node == null) continue;
                node.destroy();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setFormReadOnly() {
        this.formModel.setReadOnly(true);
        this.getFormDesigner().getHandleLayer().setViewOnly(true);
        this.detachFormListener();
        this.getFormDataObject().getFormEditorSupport().updateMVTCDisplayName();
    }

    boolean needPostCreationUpdate() {
        return Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("justCreatedByNewWizard"));
    }

    private void preCreationUpdate() {
        Object className;
        FileObject fob = this.formDataObject.getPrimaryFile();
        Object libName = fob.getAttribute("requiredLibrary");
        if (!(libName == null || (className = fob.getAttribute("requiredClass")) != null && ClassPathUtils.isOnClassPath(fob, className.toString()))) {
            try {
                Library lib = LibraryManager.getDefault().getLibrary((String)libName);
                ClassPathUtils.updateProject(fob, new ClassSource(className == null ? null : className.toString(), new ClassSource.LibraryEntry(lib)));
            }
            catch (IOException ioex) {
                Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, ioex.getLocalizedMessage(), ioex);
            }
        }
    }

    private void postCreationUpdate() {
        if (this.formLoaded && this.formModel != null && !this.formModel.isReadOnly() && this.needPostCreationUpdate()) {
            this.formModel.setMaxVersionLevel(FormModel.LATEST_VERSION);
            FormLAF.executeWithLookAndFeel(this.formModel, new Runnable(){

                @Override
                public void run() {
                    FormEditor.this.getResourceSupport().prepareNewForm();
                }
            });
            this.formModel.getSettings().getLayoutCodeTarget();
            this.formModel.fireFormChanged(true);
            this.checkSuppressWarningsAnnotation();
            FormEditorSupport fes = this.formDataObject.getFormEditorSupport();
            try {
                if (fes.isModified()) {
                    this.saveFormData();
                    fes.saveSourceOnly();
                }
                this.formDataObject.getPrimaryFile().setAttribute("justCreatedByNewWizard", null);
                this.formDataObject.getPrimaryFile().setAttribute("nonEditableTemplate", null);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner designer) {
        this.formDesigner = designer;
    }

    void closeForm() {
        if (this.formLoaded) {
            FormEditor next;
            this.formModel.fireFormToBeClosed();
            openForms.remove(this.formModel);
            formModelToAssistant.remove(this.formModel);
            this.formLoaded = false;
            if (this.formDataObject.isValid()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FormEditor.this.formDataObject.isValid()) {
                            FormEditor.this.formDataObject.getNodeDelegate().getChildren().remove(new Node[]{FormEditor.this.formRootNode});
                        }
                        FormEditor.this.formRootNode = null;
                    }
                });
            }
            this.detachFormListener();
            this.detachDataObjectListener();
            this.detachPaletteListener();
            if (openForms.isEmpty()) {
                next = null;
                FormEditor.detachSettingsListener();
            } else {
                next = openForms.values().iterator().next();
            }
            if (ComponentInspector.exists()) {
                ComponentInspector.getInstance().focusForm(next);
            }
            if (this.floatingWindows != null) {
                if (this.floatingWindows.size() > 0) {
                    LinkedList<Window> tempList = new LinkedList<Window>(this.floatingWindows);
                    for (Window window : tempList) {
                        if (!window.isVisible()) continue;
                        window.setVisible(false);
                    }
                }
                this.floatingWindows = null;
            }
            this.formDesigner = null;
            this.persistenceManager = null;
            this.persistenceErrors = null;
            this.formModel = null;
            this.codeGenerator = null;
            this.formJavaSource = null;
            this.resourceSupport = null;
            this.bindingSupport = null;
        }
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly() || this.formModel.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelListener(){

            @Override
            public void formChanged(FormModelEvent[] events) {
                if (events == null) {
                    return;
                }
                boolean modifying = false;
                HashSet<ComponentContainer> changedContainers = events.length > 0 ? new HashSet<ComponentContainer>() : null;
                HashSet<RADComponent> compsToSelect = null;
                FormNode nodeToSelect = null;
                for (int i = 0; i < events.length; ++i) {
                    int type;
                    FormModelEvent ev = events[i];
                    if (ev.isModifying()) {
                        modifying = true;
                    }
                    if ((type = ev.getChangeType()) != 4 && type != 5 && type != 7 && type != 8 && type != 9) continue;
                    ComponentContainer cont = ev.getContainer();
                    if (changedContainers == null || !changedContainers.contains(cont)) {
                        FormEditor.this.updateNodeChildren(cont);
                        if (changedContainers != null) {
                            changedContainers.add(cont);
                        }
                    }
                    if (type == 8) {
                        FormNode select = cont instanceof RADComponent ? ((RADComponent)((Object)cont)).getNodeReference() : FormEditor.this.getOthersContainerNode();
                        if (!(nodeToSelect instanceof RADComponentNode)) {
                            if (nodeToSelect == FormEditor.this.formRootNode) continue;
                            nodeToSelect = select;
                            continue;
                        }
                        if (nodeToSelect == select) continue;
                        nodeToSelect = FormEditor.this.formRootNode;
                        continue;
                    }
                    if (type == 4) {
                        nodeToSelect = ((RADVisualContainer)cont).getLayoutNodeReference();
                        continue;
                    }
                    if (type != 7 || !ev.getComponent().isInModel()) continue;
                    if (compsToSelect == null) {
                        compsToSelect = new HashSet<RADComponent>();
                    }
                    compsToSelect.add(ev.getComponent());
                    compsToSelect.remove(ev.getContainer());
                }
                FormDesigner designer = FormEditor.this.getFormDesigner();
                if (designer != null) {
                    if (compsToSelect != null) {
                        designer.clearSelectionImpl();
                        Iterator it = compsToSelect.iterator();
                        while (it.hasNext()) {
                            designer.addComponentToSelectionImpl((RADComponent)it.next());
                        }
                        designer.updateComponentInspector();
                    } else if (nodeToSelect != null) {
                        designer.setSelectedNode(nodeToSelect);
                    }
                }
                if (modifying) {
                    FormEditor.this.getFormDataObject().getFormEditorSupport().markFormModified();
                    FormEditor.this.checkFormVersionUpgrade();
                }
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    void updateNodeChildren(ComponentContainer metacont) {
        FormNode node = null;
        if (metacont == null || metacont == this.formModel.getModelContainer()) {
            node = this.formRootNode != null ? this.getOthersContainerNode() : null;
        } else if (metacont instanceof RADComponent) {
            node = ((RADComponent)((Object)metacont)).getNodeReference();
        }
        if (node != null) {
            node.updateChildren();
        }
    }

    private void checkFormVersionUpgrade() {
        FormModel.FormVersion currentVersion = this.formModel.getCurrentVersionLevel();
        FormModel.FormVersion maxVersion = this.formModel.getMaxVersionLevel();
        if (currentVersion.ordinal() > maxVersion.ordinal()) {
            if (EventQueue.isDispatchThread()) {
                this.processVersionUpgrade(true);
            } else {
                this.confirmVersionUpgrade();
            }
        }
    }

    private void processVersionUpgrade(boolean processingEvents) {
        if (!processingEvents && this.formModel.hasPendingEvents()) {
            processingEvents = true;
        }
        if (processingEvents) {
            if (!this.upgradeCheckPosted) {
                this.upgradeCheckPosted = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormEditor.this.upgradeCheckPosted = false;
                        if (FormEditor.this.formModel != null) {
                            FormEditor.this.processVersionUpgrade(false);
                        }
                    }
                });
            }
        } else {
            String upgradeOption = FormUtils.getBundleString("CTL_UpgradeOption");
            String undoOption = FormUtils.getBundleString("CTL_CancelOption");
            NotifyDescriptor d = new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_UpgradeQuestion"), FormUtils.getBundleString("TITLE_FormatUpgrade"), -1, 3, (Object[])new String[]{upgradeOption, undoOption}, (Object)upgradeOption);
            if (DialogDisplayer.getDefault().notify(d) == upgradeOption) {
                this.confirmVersionUpgrade();
            } else {
                this.revertVersionUpgrade();
            }
        }
    }

    private void confirmVersionUpgrade() {
        if (this.formModel != null) {
            this.formModel.setMaxVersionLevel(FormModel.LATEST_VERSION);
        }
    }

    private void revertVersionUpgrade() {
        if (this.formModel != null) {
            this.formModel.getUndoRedoManager().undo();
            this.formModel.revertVersionLevel();
        }
    }

    private void attachDataObjectListener() {
        if (this.dataObjectListener != null) {
            return;
        }
        this.dataObjectListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if ("name".equals(ev.getPropertyName())) {
                    String name = FormEditor.this.formDataObject.getName();
                    FormEditor.this.formModel.setName(name);
                    FormEditor.this.formRootNode.updateName(name);
                } else if ("cookie".equals(ev.getPropertyName()) && ComponentInspector.exists()) {
                    Node[] nodes = ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!(nodes[i] instanceof FormNode)) continue;
                        ((FormNode)nodes[i]).updateCookies();
                    }
                }
            }
        };
        this.formDataObject.addPropertyChangeListener(this.dataObjectListener);
    }

    private void detachDataObjectListener() {
        if (this.dataObjectListener != null) {
            this.formDataObject.removePropertyChangeListener(this.dataObjectListener);
            this.dataObjectListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                for (FormModel formModel : openForms.keySet()) {
                    FormDesigner designer;
                    String propName = evt.getKey();
                    if ("useIndentEngine".equals(propName)) {
                        formModel.fireSyntheticPropertyChanged(null, propName, null, evt.getNewValue());
                        continue;
                    }
                    if ("selectionBorderSize".equals(propName) || "selectionBorderColor".equals(propName) || "connectionBorderColor".equals(propName) || "formDesignerBackgroundColor".equals(propName) || "formDesignerBorderColor".equals(propName)) {
                        designer = FormEditor.getFormDesigner(formModel);
                        if (designer == null) continue;
                        designer.updateVisualSettings();
                        continue;
                    }
                    if (!"toolBarPalette".equals(propName) || (designer = FormEditor.getFormDesigner(formModel)) == null) continue;
                    designer.getFormToolBar().showPaletteButton(FormLoaderSettings.getInstance().isPaletteInToolBar());
                }
            }
        };
        FormLoaderSettings.getPreferences().addPreferenceChangeListener(settingsListener);
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormLoaderSettings.getPreferences().removePreferenceChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private void attachPaletteListener() {
        if (this.paletteListener != null) {
            return;
        }
        this.paletteListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedItem".equals(evt.getPropertyName())) {
                    FormDesigner designer;
                    FormModel formModel = FormEditor.this.getFormModel();
                    if (FormEditor.this.isFormLoaded() && formModel != null && !formModel.isReadOnly() && (designer = FormEditor.getFormDesigner(formModel)) != null) {
                        if (evt.getNewValue() == null) {
                            if (designer.getDesignerMode() == 2) {
                                designer.setDesignerMode(0);
                            }
                        } else {
                            if (designer.getDesignerMode() == 2) {
                                designer.setDesignerMode(0);
                            }
                            designer.setDesignerMode(2);
                        }
                    }
                }
            }
        };
        PaletteUtils.addPaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
    }

    private void detachPaletteListener() {
        if (this.paletteListener != null) {
            PaletteUtils.removePaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
            this.paletteListener = null;
        }
    }

    void reinstallListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formModel.addFormModelListener(this.formListener);
        }
    }

    public static JEditorPane createCodeEditorPane(FormModel formModel) {
        FormDataObject dobj = FormEditor.getFormDataObject(formModel);
        JavaCodeGenerator codeGen = (JavaCodeGenerator)FormEditor.getCodeGenerator(formModel);
        codeGen.regenerateCode();
        JEditorPane codePane = new JEditorPane();
        SimpleSection sec = dobj.getFormEditorSupport().getInitComponentSection();
        int pos = sec.getText().indexOf(123) + 2 + sec.getStartPosition().getOffset();
        FormUtils.setupEditorPane(codePane, dobj.getPrimaryFile(), pos);
        return codePane;
    }

    public static synchronized AssistantModel getAssistantModel(FormModel formModel) {
        assert (formModel != null);
        AssistantModel assistant = formModelToAssistant.get(formModel);
        if (assistant == null) {
            assistant = new AssistantModel();
            formModelToAssistant.put(formModel, assistant);
        }
        return assistant;
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDesigner() : null;
    }

    public static CodeGenerator getCodeGenerator(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getCodeGenerator() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDataObject() : null;
    }

    public static FormJavaSource getFormJavaSource(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormJavaSource() : null;
    }

    static ResourceSupport getResourceSupport(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getResourceSupport() : null;
    }

    public static BindingDesignSupport getBindingSupport(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getBindingSupport() : null;
    }

    public static FormEditor getFormEditor(FormModel formModel) {
        return openForms.get(formModel);
    }

    UndoRedo.Manager getFormUndoRedoManager() {
        return this.formModel != null ? this.formModel.getUndoRedoManager() : null;
    }

    public void registerFloatingWindow(Window window) {
        if (this.floatingWindows == null) {
            this.floatingWindows = new ArrayList<Window>();
        } else {
            this.floatingWindows.remove(window);
        }
        this.floatingWindows.add(window);
    }

    public void unregisterFloatingWindow(Window window) {
        if (this.floatingWindows != null) {
            this.floatingWindows.remove(window);
        }
    }

    public void registerDefaultComponentAction(Action action) {
        if (this.defaultActions == null) {
            this.createDefaultComponentActionsList();
        } else {
            this.defaultActions.remove(action);
        }
        this.defaultActions.add(0, action);
    }

    public void unregisterDefaultComponentAction(Action action) {
        if (this.defaultActions != null) {
            this.defaultActions.remove(action);
        }
    }

    private void createDefaultComponentActionsList() {
        this.defaultActions = new LinkedList<Action>();
        this.defaultActions.add((Action)SystemAction.get(EditContainerAction.class));
        this.defaultActions.add((Action)SystemAction.get(EditFormAction.class));
        this.defaultActions.add((Action)SystemAction.get(DefaultRADAction.class));
    }

    Collection<Action> getDefaultComponentActions() {
        if (this.defaultActions == null) {
            this.createDefaultComponentActionsList();
        }
        return Collections.unmodifiableList(this.defaultActions);
    }

    public static boolean updateProjectForNaturalLayout(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        if (formEditor != null && formModel.getSettings().getLayoutCodeTarget() != 1 && !ClassPathUtils.isOnClassPath(formEditor.getFormDataObject().getFormFile(), GroupLayout.class.getName())) {
            try {
                Library lib = LibraryManager.getDefault().getLibrary("swing-layout");
                if (lib == null) {
                    return false;
                }
                ClassSource cs = new ClassSource("", new ClassSource.LibraryEntry(lib));
                return Boolean.TRUE == ClassPathUtils.updateProject(formEditor.getFormDataObject().getFormFile(), cs);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean updateProjectForBeansBinding(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        if (formEditor != null && !ClassPathUtils.isOnClassPath(formEditor.getFormDataObject().getFormFile(), Binding.class.getName())) {
            try {
                Library lib = LibraryManager.getDefault().getLibrary("beans-binding");
                if (lib == null) {
                    return false;
                }
                ClassSource cs = new ClassSource("", new ClassSource.LibraryEntry(lib));
                return Boolean.TRUE == ClassPathUtils.updateProject(formEditor.getFormDataObject().getFormFile(), cs);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean isNonVisualTrayEnabled() {
        return Boolean.getBoolean("netbeans.form.non_visual_tray");
    }

    private void checkSuppressWarningsAnnotation() {
        FileObject fo = this.getFormDataObject().getPrimaryFile();
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)fo);
        boolean invalidSL = sourceLevel != null && "1.5".compareTo(sourceLevel) > 0;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        if (invalidSL || cp.findResource("java/lang/SuppressWarnings.class") == null) {
            final String foName = fo.getName();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            final int[] positions = new int[]{-1, -1};
            try {
                js.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy wcopy) throws Exception {
                        wcopy.toPhase(JavaSource.Phase.RESOLVED);
                        ClassTree clazz = null;
                        CompilationUnitTree cu = wcopy.getCompilationUnit();
                        for (Tree tree : cu.getTypeDecls()) {
                            ClassTree cand;
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !foName.equals((cand = (ClassTree)tree).getSimpleName().toString())) continue;
                            clazz = cand;
                        }
                        if (clazz == null) {
                            return;
                        }
                        for (Tree tree : clazz.getMembers()) {
                            MethodTree method;
                            if (tree.getKind() != Tree.Kind.METHOD || !"initComponents".equals((method = (MethodTree)tree).getName().toString()) || !method.getParameters().isEmpty()) continue;
                            ModifiersTree modifiers = method.getModifiers();
                            for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                                if (!annotationTree.getAnnotationType().toString().contains("SuppressWarnings")) continue;
                                SourcePositions sp = wcopy.getTrees().getSourcePositions();
                                positions[0] = (int)sp.getStartPosition(cu, annotationTree);
                                positions[1] = (int)sp.getEndPosition(cu, annotationTree);
                            }
                        }
                    }
                }).commit();
            }
            catch (IOException ioex) {
                Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, ioex.getLocalizedMessage(), ioex);
            }
            if (positions[0] != -1) {
                try {
                    this.getFormDataObject().getFormEditorSupport().getDocument().remove(positions[0], positions[1] - positions[0]);
                }
                catch (BadLocationException blex) {
                    Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, blex.getLocalizedMessage(), blex);
                }
            }
        }
    }
}

